/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.tasks.DavDataSerializer;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.writer.AsyncSerializableDataset;
import java.util.Arrays;
import java.util.zip.Deflater;

public class SerializeTaskHelper {
    final DavDataSerializer serializer = new DavDataSerializer();
    final Deflater deflater = new Deflater();
    final byte[] writeBuf = new byte[4096];

    static byte[] getBuf(byte[] defaultBuffer, int desiredSize) {
        return desiredSize <= defaultBuffer.length ? defaultBuffer : new byte[desiredSize];
    }

    public void complete(AsyncSerializableDataset dataset) {
        byte[] originalData = this.serializer.serializeData(dataset.originalData());
        if (originalData.length > ContainerFile.MAX_UNCOMPRESSED) {
            byte[] dest = SerializeTaskHelper.getBuf(this.writeBuf, originalData.length);
            this.deflater.reset();
            this.deflater.setInput(originalData);
            this.deflater.finish();
            int compressedDataLength = this.deflater.deflate(dest);
            if (compressedDataLength < originalData.length && this.deflater.finished()) {
                dataset.complete(Arrays.copyOf(dest, compressedDataLength), originalData.length);
                return;
            }
        }
        dataset.complete(originalData, 0);
    }
}

