/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks.base;

import de.bsvrz.ars.ars.mgmt.tasks.base.ShortTermTask;
import de.bsvrz.ars.ars.mgmt.tasks.base.Task;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskExecutor;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskProducer;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskProgressInterface;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskState;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TaskManager {
    private static final Set<Task> activeTasks = new HashSet<Task>();
    private static Task exclusiveTask = null;
    private static final Lock taskLock = new ReentrantLock();
    private static final Condition tasksEmpty = taskLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, T extends Exception> R compute(Task task, TaskProducer<R, T> executor) throws T, InterruptedException {
        task.setTaskState(TaskState.START_WORK);
        taskLock.lock();
        if (activeTasks.contains(task)) {
            throw new IllegalStateException("Task bereits registriert.");
        }
        try {
            while (exclusiveTask != null) {
                tasksEmpty.await();
            }
            activeTasks.add(task);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        finally {
            taskLock.unlock();
        }
        try {
            task.setTaskState(TaskState.WORKING);
            R r = executor.run(task);
            return r;
        }
        finally {
            task.setTaskState(TaskState.FINISH_WORK);
            taskLock.lock();
            try {
                activeTasks.remove(task);
                if (activeTasks.isEmpty()) {
                    tasksEmpty.signal();
                }
            }
            finally {
                taskLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, T extends Exception> R computeExclusively(Task task, TaskProducer<R, T> executor) throws T, InterruptedException {
        task.setTaskState(TaskState.START_WORK);
        taskLock.lock();
        if (activeTasks.contains(task)) {
            throw new IllegalStateException("Task bereits registriert.");
        }
        try {
            while (!activeTasks.isEmpty()) {
                tasksEmpty.await();
            }
            activeTasks.add(task);
            exclusiveTask = task;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        finally {
            taskLock.unlock();
        }
        try {
            task.setTaskState(TaskState.WORKING);
            R r = executor.run(task);
            return r;
        }
        finally {
            task.setTaskState(TaskState.FINISH_WORK);
            taskLock.lock();
            try {
                activeTasks.remove(task);
                exclusiveTask = null;
                assert (activeTasks.isEmpty());
                tasksEmpty.signal();
            }
            finally {
                taskLock.unlock();
            }
        }
    }

    public static <R, T extends Exception> R compute(String name, TaskProducer<R, T> executor) throws T, InterruptedException {
        return TaskManager.compute(new ShortTermTask(name), executor);
    }

    public static <R, T extends Exception> R computeExclusively(String name, TaskProducer<R, T> executor) throws T, InterruptedException {
        return TaskManager.computeExclusively(new ShortTermTask(name), executor);
    }

    public static <T extends Exception> void run(Task task, TaskExecutor<T> executor) throws T {
        try {
            TaskManager.compute(task, (TaskProgressInterface tpi) -> {
                executor.run(tpi);
                return null;
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static <T extends Exception> void runExclusively(Task task, TaskExecutor<T> executor) throws T {
        try {
            TaskManager.computeExclusively(task, (TaskProgressInterface tpi) -> {
                executor.run(tpi);
                return null;
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static <T extends Exception> void run(String name, TaskExecutor<T> executor) throws T {
        try {
            TaskManager.compute(name, (TaskProgressInterface tpi) -> {
                executor.run(tpi);
                return null;
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static <T extends Exception> void runExclusively(String name, TaskExecutor<T> executor) throws T {
        try {
            TaskManager.computeExclusively(name, (TaskProgressInterface tpi) -> {
                executor.run(tpi);
                return null;
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static Set<Task> getActiveTasks() {
        taskLock.lock();
        try {
            Set<Task> set = Set.copyOf(activeTasks);
            return set;
        }
        finally {
            taskLock.unlock();
        }
    }
}

