/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks.base;

import de.bsvrz.ars.ars.mgmt.tasks.base.TimeoutCallback;
import de.bsvrz.ars.ars.mgmt.tasks.base.TimeoutFunction;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class TimeoutManager {
    private static final Debug _debug = Debug.getLogger();
    private static final ScheduledExecutorService checkExecutor = Executors.newSingleThreadScheduledExecutor();
    public static final long STANDARD_TIMEOUT = 60000L;

    public static <T> T callWithTimeout(TimeoutFunction<T> func) throws TimeoutException, InterruptedException {
        return TimeoutManager.callWithTimeout(func, 60000L);
    }

    public static <T> T callWithTimeout(TimeoutFunction<T> func, final long timeoutMillis) throws TimeoutException, InterruptedException {
        final AtomicLong timeLimit = new AtomicLong(System.currentTimeMillis() + timeoutMillis);
        final AtomicBoolean finished = new AtomicBoolean(false);
        Thread executingThread = Thread.currentThread();
        checkExecutor.schedule(() -> TimeoutManager.checkDelay(finished, timeLimit, executingThread), timeoutMillis, TimeUnit.MILLISECONDS);
        TimeoutCallback callback = new TimeoutCallback(){

            @Override
            public void tick() {
                timeLimit.set(System.currentTimeMillis() + timeoutMillis);
            }

            @Override
            public void cancel() {
                finished.set(true);
            }
        };
        try {
            T result = func.call(callback);
            finished.set(true);
            if (Thread.interrupted()) {
                if (System.currentTimeMillis() >= timeLimit.get()) {
                    _debug.fine("Cleared interrupted status");
                } else {
                    throw new InterruptedException();
                }
            }
            return result;
        }
        catch (InterruptedException e) {
            if (System.currentTimeMillis() >= timeLimit.get()) {
                throw new TimeoutException();
            }
            throw e;
        }
    }

    private static void checkDelay(AtomicBoolean finished, AtomicLong timeLimit, Thread executingThread) {
        long limit = timeLimit.get();
        long remainingDelay = limit - System.currentTimeMillis();
        if (finished.get()) {
            return;
        }
        if (remainingDelay <= 0L) {
            executingThread.interrupt();
        } else {
            checkExecutor.schedule(() -> TimeoutManager.checkDelay(finished, timeLimit, executingThread), remainingDelay, TimeUnit.MILLISECONDS);
        }
    }
}

