/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks.query;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.query.DataWriter;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.dataSerializer.Deserializer;
import de.bsvrz.sys.funclib.dataSerializer.NoSuchVersionException;
import de.bsvrz.sys.funclib.dataSerializer.Serializer;
import de.bsvrz.sys.funclib.dataSerializer.SerializingFactory;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.kernsoftware.ConnectionManager;
import de.bsvrz.sys.funclib.losb.util.ByteIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class QueryHandler
implements ClientSenderInterface {
    private static final Debug _debug = Debug.getLogger();
    private int serializerVersion = 0;
    private SendingState sendingState = SendingState.STOP;
    public static final int SENDCONTROL_TIMEOUT = 30000;
    private final Object syncObj = new Object();
    private AttributeGroup atgQuery;
    private DataDescription ddResponse;
    private SystemObject queryAppObj;
    private int queryIdx;
    private final ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
    private Serializer serializer;
    private Deserializer deserializer;
    private final String name;
    private final ArchiveManager archMgr;
    private final int messageTypeResult;

    public QueryHandler(String name, ArchiveManager archMgr, int messageTypeResult, @Nullable Data data) {
        this.name = name;
        this.archMgr = archMgr;
        this.messageTypeResult = messageTypeResult;
        DataModel dataModel = this.archMgr.getDataModel();
        if (dataModel == null) {
            return;
        }
        this.atgQuery = dataModel.getAttributeGroup("atg.archivAnfrageSchnittstelle");
        this.ddResponse = new DataDescription(this.atgQuery, dataModel.getAspect("asp.antwort"));
        if (data == null) {
            return;
        }
        this.queryAppObj = data.getReferenceValue("absender").getSystemObject();
        this.queryIdx = data.getUnscaledValue("anfrageIndex").intValue();
        byte[] dataArray = data.getUnscaledArray("daten").getByteArray();
        this.serializerVersion = ByteIO.readSignedInt4Bytes((byte[])dataArray, (int)0);
        ByteArrayInputStream bis = new ByteArrayInputStream(dataArray, 4, dataArray.length - 4);
        try {
            this.deserializer = SerializingFactory.createDeserializer((int)this.serializerVersion, (InputStream)bis);
        }
        catch (NoSuchVersionException noSuchVersionException) {
            // empty catch block
        }
        try {
            this.serializer = SerializingFactory.createSerializer((int)this.serializerVersion, (OutputStream)this.resultStream);
        }
        catch (NoSuchVersionException noSuchVersionException) {
            // empty catch block
        }
    }

    public SystemObject getQueryApplication() {
        return this.queryAppObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendingState waitForSendControl() throws InterruptedException {
        SendingState state;
        long timeoutTime = System.currentTimeMillis() + 60000L;
        Object object = this.syncObj;
        synchronized (object) {
            long delta;
            while (this.sendingState == SendingState.STOP && (delta = timeoutTime - System.currentTimeMillis()) > 0L) {
                this.syncObj.wait(delta);
            }
            state = this.sendingState;
        }
        return state;
    }

    public void sendErrorResponse(@NotNull String errorMessage) {
        this.sendResponse(false, errorMessage);
    }

    public void sendSuccessResponse() {
        this.sendResponse(true, "");
    }

    public void sendErrorResponse(int messageTypeResult, @NotNull String errorMessage) {
        this.sendResponse(messageTypeResult, false, errorMessage);
    }

    public void sendSuccessResponse(int messageTypeResult) {
        this.sendResponse(messageTypeResult, true, "");
    }

    public void sendResponse(boolean success, @NotNull String msg) {
        this.sendResponse(this.messageTypeResult, success, msg);
    }

    public void sendResponse(int messageTypeResult, boolean success, @NotNull String msg) {
        this.sendResponse(messageTypeResult, success, msg, it -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(int messageTypeResult, boolean success, @NotNull String msg, DataWriter additionalData) {
        try {
            if (this.serializer == null) {
                _debug.warning(this.name + ": Kann keine Antwort senden, unbekannte Serializer-Version: " + this.serializerVersion);
                return;
            }
            try {
                this.subscribeSender();
            }
            catch (OneSubscriptionPerSendData e) {
                throw new AssertionError((Object)e);
            }
            SendingState state = this.waitForSendControl();
            if (state != SendingState.SEND) {
                _debug.warning(this.name + ": Keine positive Sendesteuerung zum Verschicken der Antwort nach 30 Sekunden erhalten.");
                return;
            }
            Data data = this.archMgr.getDavCon().createData(this.atgQuery);
            data.getReferenceValue("absender").setSystemObject((SystemObject)this.archMgr.getArchiveObject());
            data.getUnscaledValue("anfrageIndex").set(this.queryIdx);
            data.getUnscaledValue("nachrichtenTyp").set(messageTypeResult);
            this.resultStream.reset();
            this.serializer.writeByte(success ? 1 : 0);
            if (!msg.isEmpty()) {
                this.serializer.writeString(msg);
            } else if (success) {
                additionalData.accept(this.serializer);
            }
            byte[] message = this.resultStream.toByteArray();
            Data.NumberArray dataBytes = data.getUnscaledArray("daten");
            dataBytes.set(message);
            ResultData rd = new ResultData(this.queryAppObj, this.ddResponse, System.currentTimeMillis(), data);
            this.archMgr.getDavCon().sendData(rd);
            this.resultStream.reset();
        }
        catch (InterruptedException e) {
            _debug.warning("Archivsystem beendet. Versenden der Antwort abgebrochen.");
        }
        catch (Exception e) {
            _debug.warning("Versenden der Antwort fehlgeschlagen.", (Throwable)e);
        }
        finally {
            this.unsubscribeSender();
        }
    }

    @NotNull
    public Deserializer getDeserializer() throws NoSuchVersionException {
        if (this.serializer == null) {
            throw new NoSuchVersionException("Deserializer Serializer-Version: " + this.serializerVersion);
        }
        return this.deserializer;
    }

    private void subscribeSender() throws OneSubscriptionPerSendData {
        this.sendingState = SendingState.STOP;
        ConnectionManager.subscribeSender((ClientDavInterface)this.archMgr.getDavCon(), (ClientSenderInterface)this, (SystemObject)this.queryAppObj, (DataDescription)this.ddResponse, (SenderRole)SenderRole.sender());
    }

    private void unsubscribeSender() {
        try {
            ConnectionManager.unsubscribeSender((ClientDavInterface)this.archMgr.getDavCon(), (ClientSenderInterface)this, (SystemObject)this.queryAppObj, (DataDescription)this.ddResponse);
        }
        catch (Exception e) {
            _debug.warning(this.name + " Sende-Abmeldung fehlgeschlagen.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        Object object2 = this.syncObj;
        synchronized (object2) {
            this.sendingState = state == 0 ? SendingState.SEND : (this.sendingState == SendingState.SEND ? SendingState.ABORT : SendingState.STOP);
            this.syncObj.notifyAll();
        }
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return true;
    }

    protected static enum SendingState {
        SEND,
        STOP,
        ABORT;

    }
}

