/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.IndexAggregator;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.DataTimeIndex;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.result.AggregateIndexResult;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.index.result.LocatedIndexResult;
import java.util.Map;

public class CompoundDataTimeIndex {
    private final Map<DataTimeIndex, PersistenceDirectory> subIndexes;

    public CompoundDataTimeIndex(Map<DataTimeIndex, PersistenceDirectory> subIndexes) {
        this.subIndexes = subIndexes;
    }

    public CompoundDataTimeIndex(IndexAggregator<DataTimeIndex> aggregator) {
        this(aggregator.getMap());
    }

    public LocatedIndexResult<IndexValues> getContainerIDByDataTime(long minimumTime, long maximumTime) throws IndexException {
        AggregateIndexResult<IndexValues> result = new AggregateIndexResult<IndexValues>();
        for (Map.Entry<DataTimeIndex, PersistenceDirectory> e : this.subIndexes.entrySet()) {
            IndexResult<IndexValues> time = e.getKey().getContainerIDByDataTime(minimumTime, maximumTime);
            result.add(time, e.getValue());
        }
        return result;
    }
}

