/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.mgmt.tasks.ArchiveDataSerializer;
import de.bsvrz.ars.ars.persistence.CacheManager;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerHdr;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.KeyValParam;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.StandardOpenContainerData;
import de.bsvrz.ars.ars.persistence.WriteAction;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.util.BufferedRandomAccessFile;
import de.bsvrz.dav.daf.util.CloseableRandomAccessFile;
import de.bsvrz.dav.daf.util.FileAccess;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.ByteIO;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;

public final class ContainerFile {
    static final byte[] VERSION_STRING = new byte[]{118, 49, 48, 48};
    public static final int DATALEN_LEN = 4;
    static final int DATAHDR_LEN = 24;
    static final int COMPRESS_LEN = 4;
    public static final int NOT_COMPRESSED = 0;
    public static final byte[] NO_SOURCE = new byte[]{78, 79, 95, 83, 82, 67};
    public static final byte[] NO_DATA = new byte[]{78, 79, 68, 65, 84, 65};
    public static final byte[] NO_RIGHTS = new byte[]{78, 79, 82, 73, 71, 72};
    public static final byte[] POT_GAP = new byte[]{80, 79, 84, 71, 65, 80};
    public static int MAX_UNCOMPRESSED = 64;
    public static final Pattern CONT_FILENAME_PAT = Pattern.compile("dc(\\d{13})\\.dat");
    public static final FilenameFilter CONT_FILENAME_FILTER = (dir, name) -> CONT_FILENAME_PAT.matcher(name).matches();
    public static final int BUFFER_SIZE = 4096;
    private final byte[] byte8Buf = new byte[8];
    private final ContainerHdr containerHdr = new ContainerHdr();
    private long containerId;
    @Nullable
    private Path contFile;
    private boolean readOnly;
    private boolean headerRead;
    private final CacheManager _cacheManager = CacheManager.getInstance();
    @Nullable
    private CacheManager.Cache _cache;
    private static final int HEADER_LENGTH = VERSION_STRING.length + 4 + ContainerHdr.HDR_TXT_LEN + ByteIO.SEPARATOR.length;

    public static boolean isContainerFile(Path it) {
        return CONT_FILENAME_PAT.matcher(it.getFileName().toString()).matches();
    }

    private boolean accessed() {
        return this.contFile != null;
    }

    public String toString() {
        if (this.accessed()) {
            if (this.readOnly) {
                return "[accessed read only: file='" + String.valueOf(this.contFile.toAbsolutePath()) + "']";
            }
            return "[accessed: cId=" + this.containerId + ",file='" + String.valueOf(this.contFile.toAbsolutePath()) + "']";
        }
        return "[unaccessed]";
    }

    public static long getContID(Path file) {
        return ContainerFile.getContID(file.getFileName().toString());
    }

    public static long getContID(String fileName) {
        if (fileName.length() == 19 && fileName.startsWith("dc") && fileName.endsWith(".dat")) {
            try {
                return Long.parseLong(fileName.substring(2, 15));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Ung\u00fcltiger Container-Dateiname: " + fileName, e);
            }
        }
        throw new IllegalArgumentException("Ung\u00fcltiger Container-Dateiname: " + fileName + " L\u00e4nge: " + fileName.length() + ", Erwartet: 19");
    }

    public static String getContainerFileName(long containerId) {
        char[] chars = new char[]{'d', 'c', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '.', 'd', 'a', 't'};
        String containerIdString = Long.toString(containerId);
        int containerIdStringLength = containerIdString.length();
        containerIdString.getChars(0, containerIdStringLength, chars, 15 - containerIdStringLength);
        return new String(chars);
    }

    void accessContainer(long contId, Path containerDir, boolean readonly) throws PersistenceException {
        if (this.accessed()) {
            throw new PersistenceException("accessContainer(" + contId + "," + String.valueOf(containerDir) + ") nicht m\u00f6glich: bereits Container im Zugriff: " + String.valueOf(this));
        }
        this.containerId = contId;
        this.contFile = containerDir.resolve(ContainerFile.getContainerFileName(contId));
        this.readOnly = readonly;
        this.headerRead = false;
        if (readonly) {
            this._cache = this._cacheManager.getCache(this);
            if (this._cache != null) {
                this._cache.flush();
                this._cache = null;
            }
        } else {
            this._cache = this._cacheManager.getCache(this);
        }
    }

    void accessContainerReadOnly(Path contFile) throws PersistenceException {
        if (this.accessed()) {
            throw new PersistenceException("accessContainerReadOnly(" + String.valueOf(contFile.toAbsolutePath()) + ") nicht m\u00f6glich: bereits Container im Zugriff\n" + String.valueOf(this));
        }
        this.containerId = ContainerFile.getContID(contFile);
        this.contFile = contFile;
        this.readOnly = true;
        this.headerRead = false;
        this._cache = this._cacheManager.getCache(this);
        if (this._cache != null) {
            this._cache.flush();
            this._cache = null;
        }
    }

    private void forgetCache() {
        this._cacheManager.forgetCache(this);
        this._cache = null;
    }

    void leaveContainer() {
        this._cache = null;
        this.containerId = -1L;
        this.contFile = null;
        this.containerHdr.clear();
        this.headerRead = false;
    }

    boolean existsContainer() throws PersistenceException {
        return this._cache != null || Files.exists(this.checkContainerAccessed(), new LinkOption[0]);
    }

    void createContainer(ContainerDirectory location) throws PersistenceException {
        Path contFile = this.checkContainerAccessedRW();
        if (Files.exists(contFile, new LinkOption[0])) {
            throw new PersistenceException("Erzeugen der Container-Datei fehlgeschlagen: Datei existiert bereits\n" + String.valueOf(this));
        }
        if (this._cache != null) {
            this.forgetCache();
        }
        this._cache = this._cacheManager.createCache(this, true, location.dataIdentification());
        this.createDefaultContainerHeader(location);
        this.writeInitialContainerHeader();
    }

    public void closeContainer(StandardOpenContainerData openContainerData) throws PersistenceException {
        this.checkContainerAccessedRW();
        if (this._cache != null) {
            this._cache.flush();
            this.forgetCache();
        }
        if (!this.existsContainer()) {
            System.out.println("openContainerData = " + String.valueOf(openContainerData));
        }
        this.ensureHeaderRead();
        this.setContHdrParam(ContainerHdr.CHP_ANZ_DS, openContainerData.getNumContainerEntries());
        this.setContHdrParam(ContainerHdr.CHP_ARC_TIME_MIN, openContainerData.getMinArcTime());
        this.setContHdrParam(ContainerHdr.CHP_ARC_TIME_MAX, openContainerData.getMaxArcTime());
        this.setContHdrParam(ContainerHdr.CHP_DATA_TIME_MIN, openContainerData.getMinDataTime());
        this.setContHdrParam(ContainerHdr.CHP_DATA_TIME_MAX, openContainerData.getMaxDataTime());
        this.setContHdrParam(ContainerHdr.CHP_DATA_IDX_MIN, openContainerData.getMinDataIdx());
        this.setContHdrParam(ContainerHdr.CHP_DATA_IDX_MAX, openContainerData.getMaxDataIdx());
        this.writeContainerHeader();
    }

    boolean isContainerClosed() throws PersistenceException {
        this.checkContainerAccessed();
        this.ensureHeaderRead();
        return this.getContHdrParamAsInt(ContainerHdr.CHP_ANZ_DS) >= 0;
    }

    public void ensureHeaderRead() throws PersistenceException {
        if (!this.headerRead) {
            this.readContainerHeader();
        }
    }

    private void createDefaultContainerHeader(ContainerDirectory location) throws PersistenceException {
        this.containerHdr.clear();
        this.containerHdr.setVal(ContainerHdr.CHP_CONT_ID, this.containerId);
        this.containerHdr.setVal(ContainerHdr.CHP_OBJ_ID, location.getObjectId());
        this.containerHdr.setVal(ContainerHdr.CHP_ATG_ID, location.getAtgId());
        this.containerHdr.setVal(ContainerHdr.CHP_ASP_ID, location.getAspectId());
        this.containerHdr.setVal(ContainerHdr.CHP_SIM_VAR, location.getSimVariant());
        this.containerHdr.setVal(ContainerHdr.CHP_DATA_KIND, location.archiveDataKind());
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_ANZ_DS);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_DATA_IDX_MIN);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_DATA_IDX_MAX);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_DATA_TIME_MIN);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_DATA_TIME_MAX);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_ARC_TIME_MIN);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_ARC_TIME_MAX);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_LOESCHEN);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_MEDIUM_ID);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_TO_SAVE);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_DELETED);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_LOESCHUTZ);
        this.containerHdr.setDefaultVal(ContainerHdr.CHP_RESTORED);
        this.headerRead = true;
    }

    public void writeContainerHeader() throws PersistenceException {
        Path contFile = this.checkContainerAccessedHeaderRead();
        String hdrTxt = this.containerHdr.writeContainerHdr();
        ByteIO.writeSignedInt4Bytes((byte[])this.byte8Buf, (int)0, (int)(hdrTxt.length() + ByteIO.SEPARATOR.length));
        CloseableRandomAccessFile raf = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(ContainerFile.getHeaderLen());
            out.write(VERSION_STRING);
            out.write(this.byte8Buf, 0, 4);
            out.write(hdrTxt.getBytes(StandardCharsets.ISO_8859_1));
            out.write(ByteIO.SEPARATOR);
            final CloseableRandomAccessFile finalRaf = raf = new CloseableRandomAccessFile(contFile.toFile());
            out.writeTo(new OutputStream(this){

                @Override
                public void write(int b) throws IOException {
                    finalRaf.write(b);
                }

                @Override
                public void write(@NotNull byte[] b, int off, int len) throws IOException {
                    finalRaf.write(b, off, len);
                }
            });
        }
        catch (IOException e) {
            try {
                throw new PersistenceException("Container-Header-Parameter konnte nicht geaendert werden: " + e.getMessage() + "\n" + String.valueOf(this), e);
            }
            catch (Throwable throwable) {
                this.closeRandomAccessFile((FileAccess)raf);
                throw throwable;
            }
        }
        this.closeRandomAccessFile((FileAccess)raf);
    }

    private void writeInitialContainerHeader() throws PersistenceException {
        Path contFile = this.checkContainerAccessedHeaderRead();
        String hdrTxt = this.containerHdr.writeContainerHdr();
        ByteIO.writeSignedInt4Bytes((byte[])this.byte8Buf, (int)0, (int)(hdrTxt.length() + ByteIO.SEPARATOR.length));
        if (this._cache != null) {
            this._cache.cache(VERSION_STRING, VERSION_STRING.length);
            this._cache.cache(this.byte8Buf, 4);
            byte[] hdrBytes = hdrTxt.getBytes(StandardCharsets.ISO_8859_1);
            this._cache.cache(hdrBytes, hdrBytes.length);
            this._cache.cache(ByteIO.SEPARATOR, ByteIO.SEPARATOR.length);
        } else {
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(contFile, new OpenOption[0]), ContainerFile.getHeaderLen());){
                out.write(VERSION_STRING);
                out.write(this.byte8Buf, 0, 4);
                out.write(hdrTxt.getBytes(StandardCharsets.ISO_8859_1));
                out.write(ByteIO.SEPARATOR);
                out.flush();
            }
            catch (IOException e) {
                throw new PersistenceException("Container-Header-Parameter konnte nicht geaendert werden: " + e.getMessage() + "\n" + String.valueOf(this), e);
            }
        }
    }

    void readContainerHeader(FileAccess raf) throws PersistenceException {
        try {
            raf.readFully(this.byte8Buf, 0, VERSION_STRING.length + 4);
            int headerLength = ByteIO.readSignedInt4Bytes((byte[])this.byte8Buf, (int)VERSION_STRING.length);
            byte[] buf = new byte[headerLength];
            raf.readFully(buf, 0, headerLength);
            this.containerHdr.readContainerHdr(buf, headerLength);
            this.headerRead = true;
        }
        catch (IOException e) {
            throw new PersistenceException("Container-Header konnte nicht gelesen werden: " + e.getMessage() + "\n" + String.valueOf(this), e);
        }
    }

    void readContainerHeader() throws PersistenceException {
        if (this._cache != null) {
            this._cache.flush();
        }
        try {
            Path contFile = this.checkContainerAccessed();
            if (!Files.exists(contFile, new LinkOption[0])) {
                throw new PersistenceException("Container-Header konnte nicht gelesen werden: Datei existiert nicht: " + String.valueOf(contFile) + "\n" + String.valueOf(this));
            }
            try (CloseableRandomAccessFile raf = new CloseableRandomAccessFile(contFile.toFile());){
                this.readContainerHeader((FileAccess)raf);
            }
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException("Container-Header konnte nicht gelesen werden: " + e.getMessage() + "\n" + String.valueOf(this), e);
        }
    }

    String getContHdrParamAsString(KeyValParam param) throws PersistenceException {
        this.checkContainerAccessedHeaderRead();
        String val = this.containerHdr.getValAsString(param);
        if (val != null) {
            return val;
        }
        throw new PersistenceException("ContainerHeaderParam nicht vorhanden: " + String.valueOf(param) + "\n" + String.valueOf(this));
    }

    ArchiveDataKind getContHdrParamAsArchiveDataKind(KeyValParam param) throws PersistenceException {
        this.checkContainerAccessedHeaderRead();
        ArchiveDataKind adk = this.containerHdr.getValAsArchiveDataKind(param);
        if (adk != null) {
            return adk;
        }
        throw new PersistenceException("ContainerHeaderParam nicht besetzt: " + String.valueOf(param) + "\n" + String.valueOf(this));
    }

    long getContHdrParamAsLong(KeyValParam param) throws PersistenceException {
        this.checkContainerAccessedHeaderRead();
        Long l = this.containerHdr.getValAsLong(param);
        if (l != null) {
            return l;
        }
        throw new PersistenceException("ContainerHeaderParam nicht besetzt: " + String.valueOf(param) + "\n" + String.valueOf(this));
    }

    int getContHdrParamAsInt(KeyValParam param) throws PersistenceException {
        this.checkContainerAccessedHeaderRead();
        Integer i = this.containerHdr.getValAsInt(param);
        if (i != null) {
            return i;
        }
        throw new PersistenceException("ContainerHeaderParam nicht besetzt: " + String.valueOf(param) + "\n" + String.valueOf(this));
    }

    boolean getContHdrParamAsBool(KeyValParam param) throws PersistenceException {
        this.checkContainerAccessedHeaderRead();
        Boolean b = this.containerHdr.getValAsBool(param);
        if (b != null) {
            return b;
        }
        throw new PersistenceException("ContainerHeaderParam nicht besetzt: " + String.valueOf(param) + "\n" + String.valueOf(this));
    }

    void setContHdrParam(KeyValParam param, long val) throws PersistenceException {
        this.checkContainerAccessedHeaderRead();
        this.containerHdr.setVal(param, val);
    }

    void setContHdrParam(KeyValParam param, boolean val) throws PersistenceException {
        this.checkContainerAccessedHeaderRead();
        this.containerHdr.setVal(param, val);
    }

    void setContHdrParam(KeyValParam param, String val) throws PersistenceException {
        this.checkContainerAccessedHeaderRead();
        this.containerHdr.setVal(param, val);
    }

    void restoreHeader(File srcFile) throws PersistenceException {
        File contFile = this.checkContainerAccessedRW().toFile();
        if (this._cache != null) {
            this._cache.flush();
            this.forgetCache();
        }
        try {
            byte[] newHdr;
            int newHdrLenNoLenField;
            long oldHdrLenNoLenField;
            try (BufferedRandomAccessFile origContStr = new BufferedRandomAccessFile(contFile);){
                origContStr.readFully(this.byte8Buf, 0, VERSION_STRING.length + 4);
                oldHdrLenNoLenField = ByteIO.readSignedInt4Bytes((byte[])this.byte8Buf, (int)VERSION_STRING.length);
            }
            try (BufferedRandomAccessFile srcContStr = new BufferedRandomAccessFile(srcFile);){
                srcContStr.readFully(this.byte8Buf, 0, VERSION_STRING.length + 4);
                newHdrLenNoLenField = ByteIO.readSignedInt4Bytes((byte[])this.byte8Buf, (int)VERSION_STRING.length);
                newHdr = new byte[newHdrLenNoLenField];
                srcContStr.readFully(newHdr, 0, newHdrLenNoLenField);
            }
            if ((long)newHdrLenNoLenField == oldHdrLenNoLenField) {
                try (BufferedRandomAccessFile raf = new BufferedRandomAccessFile(contFile, "rw");){
                    raf.seek(0L);
                    raf.write(this.byte8Buf, 0, VERSION_STRING.length + 4);
                    raf.write(newHdr, 0, newHdrLenNoLenField);
                }
            }
            File tmpFile = Util.deleteCreateNewFile((File)contFile.getParentFile(), (String)(contFile.getName() + ".tmp"));
            try (DataInputStream origContStr = new DataInputStream(new FileInputStream(contFile));
                 DataOutputStream newContStr = new DataOutputStream(new FileOutputStream(tmpFile));){
                origContStr.readFully(this.byte8Buf, 0, VERSION_STRING.length);
                newContStr.write(this.byte8Buf, 0, VERSION_STRING.length);
                newContStr.write(newHdr, 0, newHdrLenNoLenField);
                origContStr.skipBytes((int)oldHdrLenNoLenField);
                Util.copyStreams((InputStream)origContStr, (OutputStream)newContStr);
            }
            Files.move(tmpFile.toPath(), contFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.readContainerHeader();
        }
        catch (IOException e) {
            throw new PersistenceException("Container-Header konnte nicht wiederhergestellt werden. Quelle: '" + srcFile.getAbsolutePath() + "' Grund: " + String.valueOf(e) + "\n" + String.valueOf(this), e);
        }
    }

    void appendSerializedData(ArchiveDataSerializer serializer, IdDataIdentification dataIdentification) throws PersistenceException {
        this.appendSerializedData(serializer.getActualWriteBuf(), serializer.getTotalWriteDataSize(), dataIdentification);
    }

    void appendSerializedData(byte[] actualWriteBuf, int totalWriteDataSize, IdDataIdentification dataIdentification) throws PersistenceException {
        Path contFile = this.checkContainerAccessedRW();
        if (this._cache == null) {
            this._cache = this._cacheManager.createCache(this, false, dataIdentification);
        }
        if (this._cache != null) {
            boolean isFirstDataInContainer = this._cache.getContainerSize() == (long)ContainerFile.getHeaderLen();
            this._cache.cache(actualWriteBuf, totalWriteDataSize);
            if (isFirstDataInContainer) {
                this._cache.flush();
            }
        } else {
            ContainerFile.writeContainerFileSafely(contFile, false, out -> out.write(actualWriteBuf, 0, totalWriteDataSize));
        }
    }

    /*
     * Loose catch block
     */
    public static void writeContainerFileSafely(Path containerFile, boolean create, WriteAction writeAction) throws PersistenceException {
        boolean openedFile = false;
        while (true) {
            StandardOpenOption openOption = create ? StandardOpenOption.CREATE : StandardOpenOption.APPEND;
            try (OutputStream out = Files.newOutputStream(containerFile, openOption);){
                openedFile = true;
                writeAction.execute(out);
                return;
            }
            catch (NoSuchFileException e) {
                if (openedFile || !Files.isRegularFile(containerFile, new LinkOption[0])) {
                    throw new PersistenceException("Archivdatensatz konnte nicht in Container-Datei geschrieben werden: " + e.getMessage() + "\nDatei existiert nicht: " + String.valueOf(containerFile), e);
                }
                Thread.yield();
                continue;
            }
            break;
        }
        catch (IOException e) {
            throw new PersistenceException("Archivdatensatz konnte nicht in Container-Datei geschrieben werden: " + e.getMessage() + "\n" + String.valueOf(containerFile), e);
        }
    }

    long getContainerSize() throws PersistenceException {
        Path contFile = this.checkContainerAccessed();
        if (this._cache != null) {
            return this._cache.getContainerSize();
        }
        try {
            return Files.size(contFile);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public static int getHeaderLen() {
        return HEADER_LENGTH;
    }

    public static int getTotalDataOverhead() {
        return 32 + ByteIO.SEPARATOR.length;
    }

    @NotNull
    private Path checkContainerAccessed() throws PersistenceException {
        if (!this.accessed()) {
            throw new PersistenceException("Container zuerst mit accessContainer() spezifizieren");
        }
        return this.contFile;
    }

    private Path checkContainerAccessedRW() throws PersistenceException {
        Path result = this.checkContainerAccessed();
        if (this.readOnly) {
            throw new PersistenceException("Container nur zum Lesen adressiert\n" + String.valueOf(this));
        }
        return result;
    }

    private Path checkContainerAccessedHeaderRead() throws PersistenceException {
        Path result = this.checkContainerAccessed();
        if (!this.headerRead) {
            throw new PersistenceException("Container-Header weder eingelesen noch neu erzeugt\n" + String.valueOf(this));
        }
        return result;
    }

    private void closeRandomAccessFile(@Nullable FileAccess raf) throws PersistenceException {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (IOException e) {
                throw new PersistenceException("Container-Datei konnte nicht geschlossen werden: " + e.getMessage() + "\n" + String.valueOf(this), e);
            }
        }
    }

    public long getContainerId() {
        return this.containerId;
    }

    @Nullable
    public Path getContFile() {
        return this.contFile;
    }
}

