/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.mgmt.tasks.ArchiveDataSerializer;
import de.bsvrz.ars.ars.persistence.BasicContainerFileHandle;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.KeyValParam;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.nio.file.Path;
import java.util.Objects;

public class ContainerFileHandle
extends BasicContainerFileHandle {
    private final PersistenceDirectoryLayoutInstance persistenceDirectoryLayoutInstance;

    public ContainerFileHandle(@NotNull ContainerDirectory containerDirectory, long containerId, boolean readonly, @NotNull PersistenceDirectoryLayoutInstance persistenceDirectoryLayoutInstance) throws PersistenceException {
        super(containerDirectory);
        Objects.requireNonNull(containerDirectory, "containerDirectory == null");
        Objects.requireNonNull(persistenceDirectoryLayoutInstance, "persistenceDirectoryLayoutInstance == null");
        this.persistenceDirectoryLayoutInstance = persistenceDirectoryLayoutInstance;
        Path contDir = this.createDirectoriesIfAbsent();
        this.getContainerFile().accessContainer(containerId, contDir, readonly);
    }

    private Path createDirectoriesIfAbsent() throws PersistenceException {
        Path path = this.persistenceDirectoryLayoutInstance.getPath(this.getLocation());
        return PersistenceDirectory.createDirectoriesIfAbsent(path);
    }

    public boolean existsContainer() throws PersistenceException {
        return this.getContainerFile().existsContainer();
    }

    public void createContainer() throws PersistenceException {
        this.getContainerFile().createContainer(this.getLocation());
    }

    public void setContainerHeaderParam(KeyValParam param, String val) throws PersistenceException {
        this.getContainerFile().setContHdrParam(param, val);
    }

    public void setContainerHeaderParam(KeyValParam param, long val) throws PersistenceException {
        this.getContainerFile().setContHdrParam(param, val);
    }

    public void writeContainerHeaderWithoutUpdatingIndex() throws PersistenceException {
        this.getContainerFile().writeContainerHeader();
    }

    public long getContainerSize() throws PersistenceException {
        return this.getContainerFile().getContainerSize();
    }

    public void appendSerializedData(ArchiveDataSerializer serializer) throws PersistenceException {
        this.getContainerFile().appendSerializedData(serializer, this.getLocation().dataIdentification());
    }
}

