/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.KeyValParam;
import de.bsvrz.ars.ars.persistence.KeyValProps;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ContainerHdr
extends KeyValProps {
    protected static final List<KeyValParam> allParams = new ArrayList<KeyValParam>();
    private static final int SV_STR_LEN = 3;
    private static final int DATAKIND_STR_LEN = 2;
    public static final String MEDIUM_UNSAVED = "unsaved   ";
    public static final String MEDIUM_DESTROYED = "destroyed ";
    private static final String DATAKIND_UNDEF = "  ";
    public static final int CONT_UNCLOSED = -1;
    private static final String[] DATAKINDS = new String[]{"OA", "ON", "NA", "NN", "  "};
    public static final KeyValParam CHP_CONT_ID = KeyValParam.createNumParam("contID", 0L, 13, 0L, 0xFFFFFFFFFFL, 5);
    public static final KeyValParam CHP_ANZ_DS = KeyValParam.createNumParam("anzDS", -1L, 10, -1L, Integer.MAX_VALUE, 4);
    public static final KeyValParam CHP_OBJ_ID = KeyValParam.createNumParam("objID", 0L, 19, 0L, Long.MAX_VALUE, 8);
    public static final KeyValParam CHP_ATG_ID = KeyValParam.createNumParam("atgID", 0L, 19, 0L, Long.MAX_VALUE, 8);
    public static final KeyValParam CHP_ASP_ID = KeyValParam.createNumParam("aspID", 0L, 19, 0L, Long.MAX_VALUE, 8);
    public static final KeyValParam CHP_SIM_VAR = KeyValParam.createNumParam("sv", 0L, 3, 0L, 999L, 2);
    public static final KeyValParam CHP_DATA_KIND = KeyValParam.createStringParam("art", "  ", 2, DATAKINDS);
    public static final KeyValParam CHP_DATA_IDX_MIN = KeyValParam.createNumParam("DImin", 0L, 19, 0L, Long.MAX_VALUE, 8);
    public static final KeyValParam CHP_DATA_IDX_MAX = KeyValParam.createNumParam("DImax", 0L, 19, 0L, Long.MAX_VALUE, 8);
    public static final KeyValParam CHP_DATA_TIME_MIN = KeyValParam.createNumParam("DZmin", 0L, 15, 0L, 0xFFFFFFFFFFFFL, 6);
    public static final KeyValParam CHP_DATA_TIME_MAX = KeyValParam.createNumParam("DZmax", 0L, 15, 0L, 0xFFFFFFFFFFFFL, 6);
    public static final KeyValParam CHP_ARC_TIME_MIN = KeyValParam.createNumParam("AZmin", 0L, 15, 0L, 0xFFFFFFFFFFFFL, 6);
    public static final KeyValParam CHP_ARC_TIME_MAX = KeyValParam.createNumParam("AZmax", 0L, 15, 0L, 0xFFFFFFFFFFFFL, 6);
    public static final KeyValParam CHP_TO_SAVE = KeyValParam.createStringParam("sichern", "0", 1, new String[]{"0", "1"});
    public static final KeyValParam CHP_MEDIUM_ID = KeyValParam.createStringParam("mediumID", "unsaved   ", 10);
    public static final KeyValParam CHP_LOESCHEN = KeyValParam.createNumParam("loeschen", 0L, 15, 0L, 0xFFFFFFFFFFFFL, 6);
    public static final KeyValParam CHP_LOESCHUTZ = KeyValParam.createNumParam("loeschutz", 0L, 15, 0L, 0xFFFFFFFFFFFFL, 6);
    public static final KeyValParam CHP_DELETED = KeyValParam.createStringParam("geloescht", "0", 1, new String[]{"0", "1"});
    public static final KeyValParam CHP_RESTORED = KeyValParam.createStringParam("wdhgest", "0", 1, new String[]{"0", "1"});
    public static final int HDR_TXT_LEN;

    @Nullable
    public ArchiveDataKind getValAsArchiveDataKind(KeyValParam chp) throws PersistenceException {
        if (chp.isNumeric()) {
            throw new PersistenceException("Parameter ist numerisch und nicht als ArchiveDataKind interpretierbar: " + String.valueOf(chp) + " " + String.valueOf(this));
        }
        String val = this.properties.getProperty(chp.getKey());
        if (val == null) {
            return null;
        }
        for (int i = 0; i < DATAKINDS.length; ++i) {
            if (!DATAKINDS[i].equals(val)) continue;
            return Util.getDataKindFromIndex((int)i);
        }
        throw new PersistenceException("Parameter ist nicht als ArchiveDataKind interpretierbar: " + String.valueOf(chp) + " " + String.valueOf(this));
    }

    public void setVal(KeyValParam chp, ArchiveDataKind val) throws PersistenceException {
        String txtVal = DATAKINDS[Util.getDataKindIndex((ArchiveDataKind)val)];
        chp.checkVal(txtVal);
        this.properties.setProperty(chp.getKey(), chp.formatVal(txtVal));
    }

    public static List<KeyValParam> getAllParams() {
        return allParams;
    }

    public String writeContainerHdr() {
        StringBuilder sb = new StringBuilder(HDR_TXT_LEN);
        for (KeyValParam param : ContainerHdr.getAllParams()) {
            sb.append(param.getKey()).append("=").append(this.properties.getProperty(param.getKey())).append("\n");
        }
        return sb.toString();
    }

    public void readContainerHdr(byte[] buf, int length) throws IOException, PersistenceException {
        this.properties.clear();
        Properties tmpProp = new Properties();
        tmpProp.load(new ByteArrayInputStream(buf, 0, length));
        for (KeyValParam param : ContainerHdr.getAllParams()) {
            this.setVal(param, (String)tmpProp.get(param.getKey()));
        }
    }

    static {
        allParams.add(CHP_CONT_ID);
        allParams.add(CHP_ANZ_DS);
        allParams.add(CHP_OBJ_ID);
        allParams.add(CHP_ATG_ID);
        allParams.add(CHP_ASP_ID);
        allParams.add(CHP_SIM_VAR);
        allParams.add(CHP_DATA_KIND);
        allParams.add(CHP_DATA_IDX_MIN);
        allParams.add(CHP_DATA_IDX_MAX);
        allParams.add(CHP_DATA_TIME_MIN);
        allParams.add(CHP_DATA_TIME_MAX);
        allParams.add(CHP_ARC_TIME_MIN);
        allParams.add(CHP_ARC_TIME_MAX);
        allParams.add(CHP_TO_SAVE);
        allParams.add(CHP_MEDIUM_ID);
        allParams.add(CHP_LOESCHEN);
        allParams.add(CHP_DELETED);
        allParams.add(CHP_LOESCHUTZ);
        allParams.add(CHP_RESTORED);
        int headerLen = 0;
        for (KeyValParam param : ContainerHdr.getAllParams()) {
            headerLen += param.getKey().length() + "=".length() + param.getValLen() + "\n".length();
        }
        HDR_TXT_LEN = headerLen;
    }
}

