/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.Dataset;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.dataIdentificationSettings.DataIdentification;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;

public final class IdDataIdentification
implements Comparable<IdDataIdentification> {
    private final long _objectId;
    private final long _atgId;
    private final long _aspectId;
    private final int _simVariant;

    public IdDataIdentification(Dataset dataset) {
        this(dataset.getObject(), dataset.getDataDescription());
    }

    public IdDataIdentification(SystemObject object, DataDescription dataDescription) {
        this._objectId = object.getId();
        this._atgId = dataDescription.getAttributeGroup().getId();
        this._aspectId = dataDescription.getAspect().getId();
        short simVariant = dataDescription.getSimulationVariant();
        if (simVariant == -1) {
            simVariant = 0;
        }
        this._simVariant = simVariant;
    }

    public IdDataIdentification(long objectId, long atgId, long aspectId, int simulationVariant) {
        this._objectId = objectId;
        this._atgId = atgId;
        this._aspectId = aspectId;
        this._simVariant = simulationVariant;
    }

    public IdDataIdentification(ArchiveDataSpecification ads) {
        this(ads.getObject(), ads.getDataDescription());
    }

    public IdDataIdentification(DataIdentification dataIdentification) {
        this(dataIdentification.getObject(), dataIdentification.getDataDescription());
    }

    public IdContainerFileDir resolve(ArchiveDataKind archiveDataKind) {
        return new IdContainerFileDir(this, archiveDataKind);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdDataIdentification that = (IdDataIdentification)o;
        if (this._objectId != that._objectId) {
            return false;
        }
        if (this._atgId != that._atgId) {
            return false;
        }
        if (this._aspectId != that._aspectId) {
            return false;
        }
        return this._simVariant == that._simVariant;
    }

    public int hashCode() {
        int result = (int)(this._objectId ^ this._objectId >>> 32);
        result = 31 * result + (int)(this._atgId ^ this._atgId >>> 32);
        result = 31 * result + (int)(this._aspectId ^ this._aspectId >>> 32);
        result = 31 * result + this._simVariant;
        return result;
    }

    public long getObjectId() {
        return this._objectId;
    }

    public long getAtgId() {
        return this._atgId;
    }

    public long getAspectId() {
        return this._aspectId;
    }

    public int getSimVariant() {
        return this._simVariant;
    }

    public String toString() {
        return "obj: " + this._objectId + " atg: " + this._atgId + " asp: " + this._aspectId + " sv: " + this._simVariant;
    }

    @Override
    public int compareTo(@NotNull IdDataIdentification o) {
        int tmp = Long.compare(this.getObjectId(), o.getObjectId());
        if (tmp != 0) {
            return tmp;
        }
        tmp = Long.compare(this.getAtgId(), o.getAtgId());
        if (tmp != 0) {
            return tmp;
        }
        tmp = Long.compare(this.getAspectId(), o.getAspectId());
        if (tmp != 0) {
            return tmp;
        }
        return Integer.compare(this.getSimVariant(), o.getSimVariant());
    }
}

