/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.mgmt.datatree.IndexTree;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.cache.DataRange;
import de.bsvrz.ars.ars.persistence.directories.cache.ValidDataRange;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.backend.management.BaseIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToLongFunction;

public class IndexAggregator<T extends BaseIndex<?>> {
    private final List<IndexAndDirectory<T>> result = new ArrayList<IndexAndDirectory<T>>();
    private final ToLongFunction<ValidDataRange> minSupplier;
    private final ToLongFunction<ValidDataRange> maxSupplier;
    private final IndexSupplier<T> indexSupplier;

    public IndexAggregator(ToLongFunction<ValidDataRange> minSupplier, ToLongFunction<ValidDataRange> maxSupplier, IndexSupplier<T> indexSupplier) {
        this.minSupplier = minSupplier;
        this.maxSupplier = maxSupplier;
        this.indexSupplier = indexSupplier;
    }

    public void aggregate(Collection<? extends PersistenceDirectory> directories, LockedContainerDirectory dataIdentification, long lowerBound, long upperBound) throws IndexException {
        ArrayList<PersistenceDirectory> directoriesInRange = new ArrayList<PersistenceDirectory>();
        PersistenceDirectory latestBefore = null;
        long latestBeforeValue = Long.MIN_VALUE;
        for (PersistenceDirectory persistenceDirectory : directories) {
            DataRange dataRange = persistenceDirectory.getDataRange(dataIdentification);
            if (!(dataRange instanceof ValidDataRange)) continue;
            ValidDataRange validDataRange = (ValidDataRange)dataRange;
            long directoryMinimum = this.minSupplier.applyAsLong(validDataRange);
            long directoryMaximum = this.maxSupplier.applyAsLong(validDataRange);
            if (directoryMaximum < lowerBound && (latestBefore == null || directoryMaximum > latestBeforeValue)) {
                latestBeforeValue = directoryMaximum;
                latestBefore = persistenceDirectory;
            }
            if (directoryMinimum > upperBound || directoryMaximum < lowerBound) continue;
            directoriesInRange.add(persistenceDirectory);
        }
        this.result.clear();
        if (latestBefore != null) {
            this.addResult(dataIdentification, latestBefore);
        }
        for (PersistenceDirectory persistenceDirectory : directoriesInRange) {
            this.addResult(dataIdentification, persistenceDirectory);
        }
    }

    private void addResult(LockedContainerDirectory dataIdentification, PersistenceDirectory directory) throws IndexException {
        Optional<BaseIndex> optionalIndex = this.indexSupplier.apply(directory.getIndexTree(), dataIdentification);
        optionalIndex.ifPresent(i -> this.result.add(new IndexAndDirectory<BaseIndex>((BaseIndex)i, directory)));
    }

    public List<T> getIndexes() {
        ArrayList tmp = new ArrayList(this.result.size());
        for (IndexAndDirectory<T> item : this.result) {
            tmp.add(item.index);
        }
        return tmp;
    }

    public Map<T, PersistenceDirectory> getMap() {
        HashMap tmp = new HashMap(this.result.size());
        for (IndexAndDirectory<T> item : this.result) {
            tmp.put(item.index, item.directory);
        }
        return tmp;
    }

    static interface IndexSupplier<T> {
        public Optional<? extends T> apply(IndexTree var1, LockedContainerDirectory var2) throws IndexException;
    }

    record IndexAndDirectory<T extends BaseIndex<?>>(T index, PersistenceDirectory directory) {
    }
}

