/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.sys.funclib.losb.util.Util;

public class KeyValParam {
    private static final String TYPE_STRING = "String";
    private static final String TYPE_NUM = "Zahl";
    private String key;
    private String defaultValue;
    private String[] allowedStringValues;
    private int valueLength;
    private long minVal;
    private long maxVal;
    private String paramType;
    private int byteLength;

    public static KeyValParam createStringParam(String key, String defaultValue, int valueLength) {
        return KeyValParam.createStringParam(key, defaultValue, valueLength, null);
    }

    public static KeyValParam createStringParam(String key, String defaultValue, int valueLength, String[] allowedValues) {
        KeyValParam chp = new KeyValParam();
        chp.paramType = TYPE_STRING;
        chp.allowedStringValues = allowedValues;
        chp.key = key;
        chp.defaultValue = defaultValue;
        chp.valueLength = valueLength;
        chp.minVal = -1L;
        chp.maxVal = -1L;
        chp.byteLength = valueLength;
        return chp;
    }

    public static KeyValParam createNumParam(String key, long defaultValue, int valueLength, long minVal, long maxVal, int byteLength) {
        KeyValParam chp = new KeyValParam();
        chp.paramType = TYPE_NUM;
        chp.key = key;
        chp.valueLength = valueLength;
        chp.minVal = minVal;
        chp.maxVal = maxVal;
        chp.defaultValue = chp.formatVal(defaultValue);
        chp.byteLength = byteLength;
        assert (chp.defaultValue.length() <= valueLength);
        assert (chp.formatVal(minVal).length() <= valueLength);
        assert (chp.formatVal(maxVal).length() <= valueLength);
        assert (minVal <= defaultValue && defaultValue <= maxVal);
        return chp;
    }

    public void checkVal(long val) throws PersistenceException {
        if (this.isNumeric()) {
            if (this.minVal > val || val > this.maxVal) {
                throw new PersistenceException("Ungueltiger Parameterwert (" + val + ") fuer " + String.valueOf(this));
            }
        } else {
            this.checkStringVal(Long.toString(val));
        }
    }

    public void checkVal(String val) throws PersistenceException {
        if (this.isNumeric()) {
            long lVal;
            try {
                lVal = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                throw new PersistenceException("Wert ist nicht als Zahlwert interpretierbar: '" + val + "' " + String.valueOf(this), e);
            }
            if (this.minVal > lVal || lVal > this.maxVal) {
                throw new PersistenceException("Ungueltiger Parameterwert (" + val + ") fuer " + String.valueOf(this));
            }
        } else {
            this.checkStringVal(val);
        }
    }

    private void checkStringVal(String stringVal) throws PersistenceException {
        if (stringVal.length() > this.valueLength) {
            throw new PersistenceException("Ungueltiger Parameterwert (" + stringVal + ") fuer " + String.valueOf(this));
        }
        if (this.allowedStringValues != null) {
            for (String value : this.allowedStringValues) {
                if (!value.equals(stringVal)) continue;
                return;
            }
            throw new PersistenceException("Ungueltiger Parameterwert (" + stringVal + ") fuer " + String.valueOf(this));
        }
    }

    public String getKey() {
        return this.key;
    }

    public String formatVal(long val) {
        if (val < 0L) {
            return "-" + Util.leadZero((long)(-val), (int)(this.valueLength - 1));
        }
        return Util.leadZero((long)val, (int)this.valueLength);
    }

    public String formatVal(String val) {
        return Util.sr((String)val, (int)this.valueLength);
    }

    public String getDefaultVal() {
        return this.defaultValue;
    }

    public int getValLen() {
        return this.valueLength;
    }

    public boolean isNumeric() {
        return this.paramType.equals(TYPE_NUM);
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public String toString() {
        StringBuilder erg = new StringBuilder("Container-Parameter '" + this.getKey() + "' (" + this.paramType + ") Laenge=" + this.getValLen() + " ");
        if (this.isNumeric()) {
            erg.append("min=").append(this.minVal).append(", max=").append(this.maxVal);
        } else if (this.allowedStringValues != null) {
            erg.append(", Wertebereich {");
            for (String value : this.allowedStringValues) {
                erg.append(value).append(",");
            }
            erg = new StringBuilder(Util.removeLastChar((String)erg.toString()) + "}");
        }
        return erg.toString();
    }
}

