/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.RuntimeControl;
import de.bsvrz.ars.ars.mgmt.TaskManager;
import de.bsvrz.ars.ars.mgmt.TaskManagerInterface;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentNode;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentTree;
import de.bsvrz.ars.ars.mgmt.datatree.IndexTree;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.DebuggingSynchronizationManager;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationManager;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationManagerImpl;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.ars.ars.persistence.CacheManager;
import de.bsvrz.ars.ars.persistence.CompoundArchiveTimeIndex;
import de.bsvrz.ars.ars.persistence.CompoundDataIndexIndex;
import de.bsvrz.ars.ars.persistence.CompoundDataTimeIndex;
import de.bsvrz.ars.ars.persistence.ContainerCreator;
import de.bsvrz.ars.ars.persistence.ContainerDataIterator;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerFileHandle;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.IndexAggregator;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.RebuildMode;
import de.bsvrz.ars.ars.persistence.RestorePersDirTsk;
import de.bsvrz.ars.ars.persistence.StartupProperties;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.cache.ValidDataRange;
import de.bsvrz.ars.ars.persistence.directories.mgmt.PersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.SingletonPersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.TimeBasedPersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.DirectoryIsLockedException;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeDomain;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndex;
import de.bsvrz.ars.ars.persistence.index.DataIndexIndex;
import de.bsvrz.ars.ars.persistence.index.DataTimeIndex;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.result.LocatedIndexResult;
import de.bsvrz.ars.ars.persistence.iter.DataGapManager;
import de.bsvrz.ars.ars.persistence.sequence.AllDataSpecification;
import de.bsvrz.ars.ars.persistence.sequence.ArchiveTimeSequenceSpecification;
import de.bsvrz.ars.ars.persistence.sequence.DataIndexSequenceSpecification;
import de.bsvrz.ars.ars.persistence.sequence.SequenceSpecification;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class PersistenceManager
implements ContainerCreator,
DataGapManager,
TaskManager {
    private static final Debug _debug = Debug.getLogger();
    public static final String BACKUP_DIR_NAME = "backup";
    public static final String RESTART_TIME_FILE_NAME = "_restartTime.property";
    private static boolean _deleteBrokenContainers;
    private final PersistenceDirectoryManager _persistenceDirectoryManager;
    private final Path backupDirectory;
    private final DataIdentTree _dataIdentTree = new DataIdentTree();
    private final SynchronizationManager<IdDataIdentification> _indexLockManager;
    private AtomicLong nextContainerID = new AtomicLong(1L);
    private final TaskManagerInterface archivMgr;
    private final StartupProperties startupProps;
    private boolean _preventWriteStartupInfo = true;
    private final Path _unsubscriptionFile;

    public static void setDeleteBrokenContainers(boolean deleteBrokenContainers) {
        _deleteBrokenContainers = deleteBrokenContainers;
    }

    @Override
    public boolean shouldDeleteBrokenContainers() {
        return _deleteBrokenContainers;
    }

    public PersistenceManager(TaskManagerInterface archMgr, Path archPath, TimeDomain<?> domain) {
        this.archivMgr = Objects.requireNonNull(archMgr);
        this._persistenceDirectoryManager = domain == null ? new SingletonPersistenceDirectoryManager(this, archPath) : new TimeBasedPersistenceDirectoryManager(this, archPath, domain);
        this.backupDirectory = archPath.resolve(BACKUP_DIR_NAME);
        this.startupProps = new StartupProperties(archPath);
        this._unsubscriptionFile = archPath.resolve(RESTART_TIME_FILE_NAME);
        if (Files.exists(this._unsubscriptionFile, new LinkOption[0])) {
            try {
                this.loadUnsubscriptionTime();
            }
            catch (IOException e) {
                _debug.warning("Kann " + String.valueOf(this._unsubscriptionFile) + " nicht laden", (Throwable)e);
            }
        }
        this._indexLockManager = new DebuggingSynchronizationManager<IdDataIdentification>(new SynchronizationManagerImpl<IdDataIdentification>(element -> {
            for (PersistenceDirectory persistenceDirectory : this.getPersistenceDirectories(element.getSimVariant())) {
                persistenceDirectory.getIndexTree().ensureNoCached();
            }
        }, element -> {
            for (PersistenceDirectory persistenceDirectory : this.getPersistenceDirectories(element.getSimVariant())) {
                persistenceDirectory.getIndexTree().closeIndexes();
            }
        }));
    }

    @NotNull
    public Path getGapFilePath(IdDataIdentification dataIdentification) {
        return this._persistenceDirectoryManager.getGapFilePath(dataIdentification);
    }

    public void initialize() throws IOException, InterruptedException, PersistenceException, DirectoryIsLockedException {
        this._persistenceDirectoryManager.initialize();
    }

    public void deleteSimVar(SyncKey<IdDataIdentification> syncKey) throws PersistenceException {
        IdDataIdentification dataIdentification = syncKey.getElement();
        if (dataIdentification.getSimVariant() == 0) {
            throw new PersistenceException("Simulations-Variante '0' (Echtdaten) darf nicht geloescht werden!");
        }
        int simVariant = dataIdentification.getSimVariant();
        ActivePersistenceDirectory directory = this.getPersistenceDirectoryManager().getSimulationPersistenceDirectory(simVariant);
        if (directory == null) {
            return;
        }
        try {
            CacheManager cacheManager = CacheManager.getInstance();
            cacheManager.forgetCache(directory.getOpenContID(dataIdentification.resolve(ArchiveDataKind.ONLINE)));
            cacheManager.forgetCache(directory.getOpenContID(dataIdentification.resolve(ArchiveDataKind.ONLINE_DELAYED)));
            cacheManager.forgetCache(directory.getOpenContID(dataIdentification.resolve(ArchiveDataKind.REQUESTED)));
            cacheManager.forgetCache(directory.getOpenContID(dataIdentification.resolve(ArchiveDataKind.REQUESTED_DELAYED)));
            for (ArchiveDataKind archiveDataKind : ArchiveDataKindCombination.all()) {
                directory.getIndexTree().closeIndexes(new LockedContainerDirectory(syncKey, archiveDataKind));
                directory.deleteOpenContainerData(syncKey, archiveDataKind);
            }
            Path path = directory.getPath(dataIdentification);
            try {
                PersistenceManager.deletePath(path);
            }
            catch (IOException e) {
                throw new PersistenceException("Simulations-Varianten-Verzeichnis konnte nicht geloescht werden: " + String.valueOf(path), e);
            }
        }
        catch (Exception e) {
            _debug.warning("Fehler beim Vergessen des Caches", (Throwable)e);
        }
    }

    public static void deletePath(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void prepareShutdown() throws InterruptedException {
        CacheManager.getInstance().close();
        this.assertNoLocks();
        ActivePersistenceDirectory persistenceDirectory = this.getPersistenceDirectoryManager().getActivePersistenceDirectory();
        if (persistenceDirectory != null) {
            persistenceDirectory.closeIndexes(this.archivMgr.getNumCloseIndexThreads());
        }
        this.getPersistenceDirectoryManager().shutDown();
        if (this._preventWriteStartupInfo) {
            _debug.warning("Herunterfahren: Startup-Info wird unterdr\u00fcckt, weil beim Wiederherstellungslauf ein Fehler aufgetreten ist");
            return;
        }
        try {
            this.startupProps.setVal(StartupProperties.STUP_MAX_CONT_ID, this.getLastContainerID());
            this.startupProps.setVal(StartupProperties.STUP_LAST_ATIME, ArchiveTask.getLastArchiveTime());
            this.startupProps.writeStartUpProperties();
        }
        catch (PersistenceException e) {
            _debug.error("Herunterfahren: Fehler beim Erzeugen der Startup-Info: " + e.getMessage());
        }
    }

    public boolean startupProcedure(RebuildMode rebuildMode) {
        long mxAT;
        try {
            this.startupProps.readStartUpProperties();
            this.nextContainerID.set(this.startupProps.getValAsLong(StartupProperties.STUP_MAX_CONT_ID));
            mxAT = this.startupProps.getValAsLong(StartupProperties.STUP_LAST_ATIME);
        }
        catch (PersistenceException e) {
            _debug.info(e.getMessage() + Debug.NEWLINE + "Starte Wiederherstellungslauf im Modus '" + String.valueOf((Object)rebuildMode) + "'");
            RestorePersDirTsk restorePersDirTsk = new RestorePersDirTsk(this, "Wiederherstellungslauf", rebuildMode);
            while (!restorePersDirTsk.isTerminated()) {
                try {
                    if (this.archivMgr.wasTerminated()) {
                        restorePersDirTsk.terminateTask();
                        return false;
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    _debug.info("Wiederherstellungslauf abgebrochen.", (Throwable)ie);
                    return false;
                }
            }
            if (!restorePersDirTsk.getWorker().success()) {
                _debug.error("Wiederherstellungslauf fehlgeschlagen.");
                return false;
            }
            this.nextContainerID = new AtomicLong(restorePersDirTsk.getWorker().getMaxContID());
            mxAT = restorePersDirTsk.getWorker().getMaxArchiveTime();
        }
        this._preventWriteStartupInfo = false;
        RuntimeControl runtimeControl = this.archivMgr.getRuntimeControl();
        if (runtimeControl == null) {
            throw new AssertionError((Object)"Fehler in Initialisierungsreihenfolge");
        }
        long now = runtimeControl.getSystemTime();
        ArchiveTask.setLastArchiveTime(mxAT > 0L ? mxAT : now);
        _debug.info("StartupInfo: max. ContainerID=" + String.valueOf(this.nextContainerID) + ", max. Archivzeit=" + Util.timestrMillisFormatted((long)mxAT) + (String)(mxAT <= 0L ? " (nicht ermittelbar, wurde auf " + Util.timestrMillisFormatted((long)now) + " gesetzt)" : ""));
        try {
            this.startupProps.deleteStartupPropsFile();
        }
        catch (IOException e) {
            _debug.warning("StartUp-Properties konnten nicht geloescht werden: " + String.valueOf(this.startupProps), (Throwable)e);
        }
        return true;
    }

    public Statistics getStatistics() {
        return new Statistics();
    }

    @Override
    public long nextContainerID() {
        return this.nextContainerID.incrementAndGet();
    }

    @Override
    public int getCloseThreadCount() {
        return this.archivMgr.getNumCloseIndexThreads();
    }

    public long getLastContainerID() {
        return this.nextContainerID.longValue();
    }

    public void saveUnsubscriptionTime() {
        ListMultimap didForUnsubscriptionTime = MultimapBuilder.treeKeys().arrayListValues().build();
        RuntimeControl runtimeControl = this.archivMgr.getRuntimeControl();
        if (runtimeControl == null) {
            return;
        }
        Long now = runtimeControl.getSystemTime();
        for (DataIdentNode node : this._dataIdentTree) {
            if (node.hasValidData()) {
                didForUnsubscriptionTime.put((Object)now, (Object)node.getDataIdentification());
                continue;
            }
            long unsubscriptionTime = node.getUnsubscriptionTime();
            if (unsubscriptionTime == -1L) continue;
            didForUnsubscriptionTime.put((Object)unsubscriptionTime, (Object)node.getDataIdentification());
        }
        this.saveUnsubscriptionTime((Multimap<Long, IdDataIdentification>)didForUnsubscriptionTime, this._unsubscriptionFile);
    }

    public void saveUnsubscriptionTime(Multimap<Long, IdDataIdentification> didForUnsubscriptionTime, Path unsubscriptionFile) {
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(Files.newOutputStream(unsubscriptionFile, new OpenOption[0]))));){
            Set entries = didForUnsubscriptionTime.asMap().entrySet();
            stream.writeInt(entries.size());
            for (Map.Entry entry : entries) {
                stream.writeLong((Long)entry.getKey());
                List values = (List)entry.getValue();
                values.sort(null);
                stream.writeInt(values.size());
                for (IdDataIdentification value : values) {
                    stream.writeLong(value.getObjectId());
                    stream.writeLong(value.getAtgId());
                    stream.writeLong(value.getAspectId());
                    stream.writeShort(value.getSimVariant());
                }
            }
        }
        catch (IOException e) {
            _debug.error("Fehler beim Schreiben der Datenzeit: _restartTime.property ist nicht beschreibbar.", (Throwable)e);
        }
    }

    private void loadUnsubscriptionTime() throws IOException {
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(this._unsubscriptionFile, new OpenOption[0]))));){
            int numEntries = stream.readInt();
            for (int i = 0; i < numEntries; ++i) {
                long time = stream.readLong();
                int numValues = stream.readInt();
                for (int f = 0; f < numValues; ++f) {
                    long objId = stream.readLong();
                    long atgId = stream.readLong();
                    long aspId = stream.readLong();
                    short sv = stream.readShort();
                    this._dataIdentTree.get(new IdDataIdentification(objId, atgId, aspId, sv)).setUnsubscriptionTime(time);
                }
            }
        }
    }

    @Nullable
    public ContainerHeaders getLastContainerHeaders(LockedContainerDirectory containerDirectory) throws IndexException {
        List<? extends PersistenceDirectory> persistenceDirectories = this.getPersistenceDirectories(containerDirectory.getSimVariant());
        for (PersistenceDirectory persistenceDirectory : Lists.reverse(persistenceDirectories)) {
            ContainerHeaders headers = persistenceDirectory.getLastContainerHeaders(containerDirectory);
            if (headers == null) continue;
            return headers;
        }
        return null;
    }

    @Nullable
    public ContainerDataResult getLastDataSet(LockedContainerDirectory containerDirectory) throws IndexException, PersistenceException, SynchronizationFailedException {
        List<? extends PersistenceDirectory> persistenceDirectories = this.getPersistenceDirectories(containerDirectory.getSimVariant());
        for (PersistenceDirectory persistenceDirectory : Lists.reverse(persistenceDirectories)) {
            ContainerHeaders headers = persistenceDirectory.getLastContainerHeaders(containerDirectory);
            if (headers == null) continue;
            long contId = headers.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID);
            try (ContainerFileHandle containerFileHandle = persistenceDirectory.accessContainer(containerDirectory, contId);){
                ContainerDataIterator iterator = containerFileHandle.iterator();
                ContainerDataResult result = new ContainerDataResult();
                while (!iterator.isEmpty()) {
                    iterator.poll(result);
                }
                iterator.close();
                ContainerDataResult containerDataResult = result;
                return containerDataResult;
            }
        }
        return null;
    }

    @Override
    public SyncKey<IdDataIdentification> lockIndex(IdDataIdentification dataIdentification) throws SynchronizationFailedException {
        return this._indexLockManager.acquireWriteKey(dataIdentification);
    }

    public SetMultimap<IdDataIdentification, SyncKey<IdDataIdentification>> getIndexLocks() {
        return this._indexLockManager.getLocks();
    }

    public void assertNoLocks() {
        assert (this.assertNoLocksInternal(Thread.currentThread()));
    }

    private boolean assertNoLocksInternal(Thread currentThread) {
        Collection values = this.getIndexLocks().values();
        for (SyncKey value : values) {
            if (value.getThread() == currentThread) {
                throw new AssertionError((Object)("Thread " + String.valueOf(currentThread) + " darf keine Locks halten: " + String.valueOf(value)));
            }
        }
        return true;
    }

    @Nullable
    public ActivePersistenceDirectory getActivePersistenceDirectory(int simVariant) {
        if (simVariant == 0) {
            return this.getPersistenceDirectoryManager().getActivePersistenceDirectory();
        }
        return this.getPersistenceDirectoryManager().getSimulationPersistenceDirectory(simVariant);
    }

    public List<? extends PersistenceDirectory> getPersistenceDirectories(int simVariant, SequenceSpecification sequenceSpecification) {
        return this.getPersistenceDirectoryManager().getPersistenceDirectories(simVariant, sequenceSpecification);
    }

    public List<? extends PersistenceDirectory> getPersistenceDirectories(int simVariant) {
        return this.getPersistenceDirectoryManager().getPersistenceDirectories(simVariant, AllDataSpecification.Instance);
    }

    public LocatedIndexResult<IndexValues> getIndexResult(LockedContainerDirectory containerDirectory, ArchiveTimeSpecification archiveTimeSpecification) throws IndexException {
        ActivePersistenceDirectory persistenceDirectory = this.getActivePersistenceDirectory(containerDirectory.getSimVariant());
        if (persistenceDirectory != null) {
            persistenceDirectory.updateStandardIndexes(containerDirectory);
        }
        SequenceSpecification spec = this.createSequenceFromArchiveTimeSpecification(archiveTimeSpecification, containerDirectory, false);
        return this.getIndexResult(containerDirectory, spec);
    }

    public LocatedIndexResult<IndexValues> getIndexResult(LockedContainerDirectory containerDirectory, SequenceSpecification sequenceSpecification) throws IndexException {
        if (sequenceSpecification instanceof DataIndexSequenceSpecification) {
            DataIndexSequenceSpecification spec = (DataIndexSequenceSpecification)sequenceSpecification;
            return this.getCompoundDataIndexIndex(containerDirectory, sequenceSpecification).getContainerIDByDataIndex(spec.minimumIndex(), spec.maximumIndex());
        }
        if (sequenceSpecification instanceof ArchiveTimeSequenceSpecification) {
            ArchiveTimeSequenceSpecification spec = (ArchiveTimeSequenceSpecification)sequenceSpecification;
            return this.getCompoundArchiveTimeIndex(containerDirectory, sequenceSpecification).getContainerIDByArchiveTime(spec.minimumTime(), spec.maximumTime());
        }
        if (sequenceSpecification instanceof AllDataSpecification) {
            return this.getCompoundDataIndexIndex(containerDirectory, sequenceSpecification).getContainerIDByDataIndex(0L, Long.MAX_VALUE);
        }
        throw new AssertionError();
    }

    public SequenceSpecification createSequenceFromArchiveTimeSpecification(ArchiveTimeSpecification ats, LockedContainerDirectory containerDirectory) throws IndexException {
        return this.createSequenceFromArchiveTimeSpecification(ats, containerDirectory, true);
    }

    private SequenceSpecification createSequenceFromArchiveTimeSpecification(ArchiveTimeSpecification ats, LockedContainerDirectory containerDirectory, boolean needsIndexUpdate) throws IndexException {
        if (ats.isStartRelative()) {
            throw new UnsupportedOperationException("Ein relativer Intervallstart wird bei dieser Aktion nicht unterst\u00fctzt.");
        }
        if (ats.getTimingType().equals(TimingType.ARCHIVE_TIME)) {
            return new ArchiveTimeSequenceSpecification(ats.getIntervalStart(), ats.getIntervalEnd());
        }
        if (ats.getTimingType().equals(TimingType.DATA_INDEX)) {
            return new DataIndexSequenceSpecification(ats.getIntervalStart(), ats.getIntervalEnd());
        }
        if (ats.getTimingType().equals(TimingType.DATA_TIME)) {
            CompoundDataTimeIndex index;
            LocatedIndexResult<IndexValues> contIDs;
            ActivePersistenceDirectory persistenceDirectory;
            if (needsIndexUpdate && (persistenceDirectory = this.getActivePersistenceDirectory(containerDirectory.getSimVariant())) != null) {
                persistenceDirectory.updateStandardIndexes(containerDirectory);
            }
            if ((contIDs = (index = this.getCompoundDataTimeIndex(containerDirectory, ats.getIntervalStart(), ats.getIntervalEnd())).getContainerIDByDataTime(ats.getIntervalStart(), ats.getIntervalEnd())).isEmpty()) {
                return new DataIndexSequenceSpecification(0L, 0L);
            }
            return new DataIndexSequenceSpecification(contIDs.getMin(IndexValues.DataIndexMin), contIDs.getMax(IndexValues.DataIndexMax));
        }
        throw new AssertionError();
    }

    private CompoundArchiveTimeIndex getCompoundArchiveTimeIndex(LockedContainerDirectory containerDirectory, SequenceSpecification sequenceSpecification) throws IndexException {
        int simVariant = containerDirectory.getSimVariant();
        List<? extends PersistenceDirectory> reducedDirectories = this.getPersistenceDirectories(simVariant, sequenceSpecification);
        List<? extends PersistenceDirectory> allDirectories = this.getPersistenceDirectories(simVariant);
        CompoundArchiveTimeIndex result = PersistenceManager.createArchiveTimeIndex(containerDirectory, reducedDirectories, sequenceSpecification);
        if (reducedDirectories.equals(allDirectories) || result.isComplete(sequenceSpecification)) {
            return result;
        }
        return PersistenceManager.createArchiveTimeIndex(containerDirectory, allDirectories, sequenceSpecification);
    }

    @NotNull
    private static CompoundArchiveTimeIndex createArchiveTimeIndex(LockedContainerDirectory containerDirectory, Collection<? extends PersistenceDirectory> directories, SequenceSpecification sequenceSpecification) throws IndexException {
        long minArchiveTime = Long.MIN_VALUE;
        long maxArchiveTime = Long.MAX_VALUE;
        if (sequenceSpecification instanceof ArchiveTimeSequenceSpecification) {
            ArchiveTimeSequenceSpecification archiveTimeSequenceSpecification = (ArchiveTimeSequenceSpecification)sequenceSpecification;
            minArchiveTime = archiveTimeSequenceSpecification.minimumTime();
            maxArchiveTime = archiveTimeSequenceSpecification.maximumTime();
        }
        IndexAggregator<ArchiveTimeIndex> aggregator = new IndexAggregator<ArchiveTimeIndex>(ValidDataRange::minArchiveTime, ValidDataRange::maxArchiveTime, IndexTree::getArchiveTimeIndex);
        aggregator.aggregate(directories, containerDirectory, minArchiveTime, maxArchiveTime);
        return new CompoundArchiveTimeIndex(aggregator);
    }

    private CompoundDataIndexIndex getCompoundDataIndexIndex(LockedContainerDirectory containerDirectory, SequenceSpecification sequenceSpecification) throws IndexException {
        int simVariant = containerDirectory.getSimVariant();
        List<? extends PersistenceDirectory> reducedDirectories = this.getPersistenceDirectories(simVariant, sequenceSpecification);
        List<? extends PersistenceDirectory> allDirectories = this.getPersistenceDirectories(simVariant);
        CompoundDataIndexIndex result = PersistenceManager.createDataIndexIndex(containerDirectory, reducedDirectories, sequenceSpecification);
        if (reducedDirectories.equals(allDirectories) || result.isComplete(sequenceSpecification)) {
            return result;
        }
        return PersistenceManager.createDataIndexIndex(containerDirectory, allDirectories, sequenceSpecification);
    }

    @NotNull
    private static CompoundDataIndexIndex createDataIndexIndex(LockedContainerDirectory containerDirectory, Collection<? extends PersistenceDirectory> directories, SequenceSpecification sequenceSpecification) throws IndexException {
        long minDataIndex = Long.MIN_VALUE;
        long maxDataIndex = Long.MAX_VALUE;
        if (sequenceSpecification instanceof DataIndexSequenceSpecification) {
            DataIndexSequenceSpecification dataIndexSequenceSpecification = (DataIndexSequenceSpecification)sequenceSpecification;
            minDataIndex = dataIndexSequenceSpecification.minimumIndex();
            maxDataIndex = dataIndexSequenceSpecification.maximumIndex();
        }
        IndexAggregator<DataIndexIndex> aggregator = new IndexAggregator<DataIndexIndex>(ValidDataRange::minDataIndex, ValidDataRange::maxDataIndex, IndexTree::getDataIndexIndex);
        aggregator.aggregate(directories, containerDirectory, minDataIndex, maxDataIndex);
        return new CompoundDataIndexIndex(aggregator);
    }

    private CompoundDataTimeIndex getCompoundDataTimeIndex(LockedContainerDirectory containerDirectory, long minDataTime, long maxDataTime) throws IndexException {
        List<? extends PersistenceDirectory> directories = this.getPersistenceDirectories(containerDirectory.getSimVariant());
        IndexAggregator<DataTimeIndex> aggregator = new IndexAggregator<DataTimeIndex>(ValidDataRange::minDataTime, ValidDataRange::maxDataTime, IndexTree::getDataTimeIndex);
        aggregator.aggregate(directories, containerDirectory, minDataTime, maxDataTime);
        return new CompoundDataTimeIndex(aggregator);
    }

    public Path getBackupConfigurationDirectory() {
        return this.backupDirectory;
    }

    public void deletePersistenceDirectory(ActivePersistenceDirectory directory) throws PersistenceException {
        if (directory.getSimulationVariant() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            this.getPersistenceDirectoryManager().deleteSimulationDirectory(directory);
            PersistenceManager.deletePath(directory.getBasePath());
        }
        catch (IOException e) {
            throw new PersistenceException("Simulationsdatenverzeichnis '" + String.valueOf(directory) + "'konnte nicht gel\u00f6scht werden.", e);
        }
    }

    public void updateArchTime(long archTime) throws PersistenceException {
        try {
            this.getPersistenceDirectoryManager().updatePersistenceDirectories(archTime);
        }
        catch (IOException | InterruptedException e) {
            throw new PersistenceException("Fehler beim Erstellen eines neuen Persistenzverzeichnisses", e);
        }
    }

    @NotNull
    public ActivePersistenceDirectory updateAndGetActivePersistenceDirectory(long archTime, int simVariant) throws PersistenceException {
        this.updateArchTime(archTime);
        ActivePersistenceDirectory directory = this.getActivePersistenceDirectory(simVariant);
        if (directory == null) {
            if (simVariant == 0) {
                throw new PersistenceException("Das aktuelle Persistenzverzeichnis konnte nicht gelesen werden.");
            }
            throw new AssertionError((Object)("F\u00fcr Simulation " + simVariant + " wurde noch kein Verzeichnis angelegt."));
        }
        return directory;
    }

    public Path getRootPath() {
        return this.getPersistenceDirectoryManager().getRootPath();
    }

    public PersistenceDirectoryManager getPersistenceDirectoryManager() {
        return this._persistenceDirectoryManager;
    }

    @Override
    public DataIdentTree getDataIdentTree() {
        return this._dataIdentTree;
    }

    @Override
    public int getIndexCacheMaxSize() {
        return this.archivMgr.getIndexCacheMaxSize();
    }

    @Override
    public String formatObj(long objId) {
        SystemObject obj;
        DataModel dataModel;
        ArchiveManager am;
        ClientDavInterface davCon;
        TaskManagerInterface taskManagerInterface = this.archivMgr;
        if (taskManagerInterface instanceof ArchiveManager && (davCon = (am = (ArchiveManager)taskManagerInterface).getDavCon()) != null && (dataModel = davCon.getDataModel()) != null && (obj = dataModel.getObject(objId)) != null) {
            return obj.getPidOrId();
        }
        return String.valueOf(objId);
    }

    @Override
    public boolean isRangeUnavailable(long fromArchiveTime, long toArchiveTime) {
        return this.getPersistenceDirectoryManager().isRangeUnavailable(fromArchiveTime, toArchiveTime);
    }

    @Override
    public boolean wasTerminated() {
        return this.archivMgr.wasTerminated();
    }

    @Override
    public int getNumCloseIndexThreads() {
        return this.archivMgr.getNumCloseIndexThreads();
    }

    @Override
    @Nullable
    public RuntimeControl getRuntimeControl() {
        return this.archivMgr.getRuntimeControl();
    }

    @Override
    public void suspendTaskIfNecessary(Task task) throws InterruptedException {
        this.archivMgr.suspendTaskIfNecessary(task);
    }

    @Override
    public long countDataInQueues() {
        return this.archivMgr.countDataInQueues();
    }

    @Override
    public long estimateQueueMemoryUsage() {
        return this.archivMgr.estimateQueueMemoryUsage();
    }

    @Override
    public int getNumCheckPersistenceThreads() {
        return this.archivMgr.getNumCheckPersistenceThreads();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this;
    }

    public class Statistics {
        private final long numNodes;
        private final long indexLocks;
        private final long numOpenContainerData;
        private final long numFlagFiles;
        private final long queueMemorySize;
        private final long queueMemory;
        private final CacheManager.CacheMemoryUsage cachedMemory;

        private Statistics() {
            this.numNodes = PersistenceManager.this._dataIdentTree.size();
            this.indexLocks = PersistenceManager.this._indexLockManager.getLocks().size();
            ActivePersistenceDirectory persistenceDirectory = PersistenceManager.this._persistenceDirectoryManager.getActivePersistenceDirectory();
            if (persistenceDirectory == null) {
                this.numOpenContainerData = 0L;
                this.numFlagFiles = 0L;
            } else {
                this.numOpenContainerData = persistenceDirectory.openContainerDataSize();
                this.numFlagFiles = persistenceDirectory.getDirtyDirectoriesSize();
            }
            this.queueMemorySize = PersistenceManager.this.archivMgr.countDataInQueues();
            this.queueMemory = PersistenceManager.this.archivMgr.estimateQueueMemoryUsage();
            this.cachedMemory = CacheManager.getInstance().getCachedMemory();
        }

        public long getNumNodes() {
            return this.numNodes;
        }

        public long getNodeMemory() {
            return 108L * this.numNodes;
        }

        public long getIndexLocks() {
            return this.indexLocks;
        }

        public long getLockMemory() {
            return this.getIndexLocks() * 90L;
        }

        public long getNumOpenContainerData() {
            return this.numOpenContainerData;
        }

        public long getActiveMemory() {
            return this.numOpenContainerData * 192L + this.numFlagFiles * 108L;
        }

        public CacheManager.CacheMemoryUsage getCachedMemory() {
            return this.cachedMemory;
        }

        public long getQueueSize() {
            return this.queueMemorySize;
        }

        public long getQueueMemory() {
            return this.queueMemory;
        }

        public String toString() {
            return "Statistics{numNodes=" + this.numNodes + ", indexLocks=" + this.indexLocks + ", numOpenContainerData=" + this.numOpenContainerData + ", numFlagFiles=" + this.numFlagFiles + ", queueMemorySize=" + this.queueMemorySize + ", queueMemory=" + this.queueMemory + ", cachedMemory=" + String.valueOf(this.cachedMemory) + "}";
        }
    }
}

