/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.KeyValParam;
import de.bsvrz.ars.ars.persistence.KeyValProps;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class StartupProperties
extends KeyValProps {
    public static final String STARTUP_PROP_FILE_NAME = "_startUpInfo.property";
    protected static final List<KeyValParam> allParams = new ArrayList<KeyValParam>();
    private final Path startUpPropFile;
    private static final long INVALID_CONTAINER_ID = -1L;
    private static final long INVALID_TIME = -1L;
    public static final KeyValParam STUP_MAX_CONT_ID = KeyValParam.createNumParam("maxContainerID", -1L, 13, -1L, 0xFFFFFFFFFFL, 5);
    public static final KeyValParam STUP_LAST_ATIME = KeyValParam.createNumParam("lastArchiveTime", -1L, 15, -1L, 0xFFFFFFFFFFFFL, 6);
    public static final int HDR_TXT_LEN;

    public StartupProperties(Path persBaseDir) {
        this.startUpPropFile = persBaseDir.resolve(STARTUP_PROP_FILE_NAME);
    }

    public void readStartUpProperties() throws PersistenceException {
        this.properties.clear();
        try (InputStream fis = Files.newInputStream(this.startUpPropFile, new OpenOption[0]);){
            Properties tmpProp = new Properties();
            tmpProp.load(fis);
            for (KeyValParam param : allParams) {
                this.setVal(param, (String)tmpProp.get(param.getKey()));
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Startup-Properties konnten nicht gelesen werden", e);
        }
    }

    public void writeStartUpProperties() throws PersistenceException {
        try (BufferedWriter fw = Files.newBufferedWriter(this.startUpPropFile, StandardCharsets.ISO_8859_1, new OpenOption[0]);){
            StringBuilder sb = new StringBuilder(HDR_TXT_LEN);
            for (KeyValParam param : allParams) {
                sb.append(param.getKey()).append("=").append(this.properties.getProperty(param.getKey())).append("\n");
            }
            fw.write(sb.toString());
        }
        catch (IOException e) {
            throw new PersistenceException("Startup-Properties konnten nicht geschrieben werden", e);
        }
    }

    public void deleteStartupPropsFile() throws IOException {
        Files.deleteIfExists(this.startUpPropFile);
    }

    public String toString() {
        return "Startup Properties Datei '" + String.valueOf(this.startUpPropFile.toAbsolutePath()) + "'";
    }

    static {
        allParams.add(STUP_MAX_CONT_ID);
        allParams.add(STUP_LAST_ATIME);
        int headerLen = 0;
        for (KeyValParam param : allParams) {
            headerLen += param.getKey().length() + "=".length() + param.getValLen() + "\n".length();
        }
        HDR_TXT_LEN = headerLen;
    }
}

