/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories;

import com.google.common.util.concurrent.UncheckedExecutionException;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.ContainerCreator;
import de.bsvrz.ars.ars.persistence.ContainerDataIterator;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerFileHandle;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.OpenContainerData;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.StandaloneContainerFileHandle;
import de.bsvrz.ars.ars.persistence.StandardOpenContainerData;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.cache.DataRange;
import de.bsvrz.ars.ars.persistence.directories.cache.SimpleDataRange;
import de.bsvrz.ars.ars.persistence.directories.cache.ValidDataRange;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndex;
import de.bsvrz.ars.ars.persistence.index.ContainerManagementIndex;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.backend.management.BaseIndex;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.ars.ars.persistence.sequence.SequenceSpecification;
import de.bsvrz.ars.ars.persistence.walk.DataIdentificationDirWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public final class ActivePersistenceDirectory
extends PersistenceDirectory {
    private static final OpenContainerData.NoOpenContainer NO_OPEN_CONTAINER = OpenContainerData.NoOpenContainer.Instance;
    private final Map<IdContainerFileDir, OpenContainerData> openContainerData = new ConcurrentHashMap<IdContainerFileDir, OpenContainerData>();
    private final ContainerCreator containerCreator;
    public static final String REBUILD_INDEX_FILE_FLAG_NAME = "_rebuildIndex.flag";
    private final Set<IdContainerFileDir> dirtyDirectories = new HashSet<IdContainerFileDir>();

    public ActivePersistenceDirectory(@NotNull ContainerCreator containerCreator, @NotNull PersistenceDirectoryLayoutInstance layoutInstance) {
        super(containerCreator, layoutInstance);
        this.containerCreator = containerCreator;
    }

    @Override
    protected void handleUnclosedContainer(ContainerManagementIndex managementIndex, LockedContainerDirectory containerDirectory, long contId, BaseIndex<IndexValues> index) throws IndexException {
        StandardOpenContainerData openContainerData = this.getOpenContainerData(containerDirectory, managementIndex);
        if (openContainerData == null || openContainerData.getContainerId() != contId) {
            throw new IndexException("Inkonsistente Indexe, offener Container ist nicht eindeutig definiert", managementIndex.getFile());
        }
        index.setInsertValue(IndexValues.DataIndexMin, openContainerData.getMinDataIdx());
        index.setInsertValue(IndexValues.DataIndexMax, openContainerData.getMaxDataIdx());
        index.setInsertValue(IndexValues.DataTimeMin, openContainerData.getMinDataTime());
        index.setInsertValue(IndexValues.DataTimeMax, openContainerData.getMaxDataTime());
        index.setInsertValue(IndexValues.ArchiveTimeMin, openContainerData.getMinArcTime());
        index.setInsertValue(IndexValues.ArchiveTimeMax, openContainerData.getMaxArcTime());
    }

    protected static void updateContainerIndex(ContainerManagementData containerFile, ContainerManagementIndex index) throws PersistenceException {
        for (ContainerManagementInformation information : ContainerManagementInformation.values()) {
            if (information.isNumeric()) {
                long paramAsLong = containerFile.getContainerHeaderParamAsLong(information);
                index.setInsertValue(information, paramAsLong);
                continue;
            }
            String paramAsString = containerFile.getContainerHeaderParamAsString(information);
            index.setInsertValue(information, paramAsString);
        }
        try {
            index.insertOrReplace();
        }
        catch (IndexException e) {
            throw new PersistenceException("Fehler beim Aktualisieren der Header-Informationen in der Indexdatei", e);
        }
    }

    public ContainerFileHandle accessOpenContainer(ContainerDirectory containerDirectory, long openContID) throws PersistenceException {
        return new ContainerFileHandle(containerDirectory, openContID, false, this.getLayoutInstance());
    }

    public void updateContainerIndex(ContainerManagementData managementData, LockedContainerDirectory containerDirectory) throws PersistenceException, IndexException {
        Optional<? extends ContainerManagementIndex> containerManagementIndex = this.getIndexTree().getContainerManagementIndex(containerDirectory);
        if (containerManagementIndex.isPresent()) {
            ActivePersistenceDirectory.updateContainerIndex(managementData, containerManagementIndex.get());
        }
    }

    @Nullable
    public StandardOpenContainerData getOpenContainerData(ContainerDirectory containerFileDir) throws IndexException, SynchronizationFailedException {
        IdContainerFileDir key = IdContainerFileDir.of(containerFileDir);
        OpenContainerData data = this.getLoadedContainerData(key);
        if (data == null) {
            OpenContainerData tmp;
            try (LockedContainerDirectory containerDirectory = this.containerCreator.lockIndex(containerFileDir);){
                Optional<? extends ContainerManagementIndex> containerManagementIndex = this.getIndexTree().getContainerManagementIndex(containerDirectory);
                if (containerManagementIndex.isEmpty()) {
                    this.openContainerData.put(key, NO_OPEN_CONTAINER);
                    StandardOpenContainerData standardOpenContainerData = null;
                    return standardOpenContainerData;
                }
                tmp = this.initOpenContainerData(containerDirectory, containerManagementIndex.get());
            }
            data = this.openContainerData.computeIfAbsent(key, dir -> tmp);
        }
        if (data instanceof StandardOpenContainerData) {
            StandardOpenContainerData containerData = (StandardOpenContainerData)data;
            return containerData;
        }
        return null;
    }

    @Nullable
    public StandardOpenContainerData getOpenContainerData(LockedContainerDirectory containerDirectory, ContainerManagementIndex containerManagementIndex) {
        IdContainerFileDir key = IdContainerFileDir.of(containerDirectory);
        OpenContainerData data = this.getLoadedContainerData(key);
        if (data == null) {
            OpenContainerData tmp = this.initOpenContainerData(containerDirectory, containerManagementIndex);
            data = this.openContainerData.computeIfAbsent(key, dir -> tmp);
        }
        if (data instanceof StandardOpenContainerData) {
            StandardOpenContainerData containerData = (StandardOpenContainerData)data;
            return containerData;
        }
        return null;
    }

    @Nullable
    public OpenContainerData getLoadedContainerData(ContainerDirectory containerDirectory) {
        return this.openContainerData.get(IdContainerFileDir.of(containerDirectory));
    }

    protected OpenContainerData initOpenContainerData(LockedContainerDirectory containerDirectory, ContainerManagementIndex headerIndex) {
        try {
            boolean isOpen;
            if (headerIndex.numEntries() == 0L) {
                return NO_OPEN_CONTAINER;
            }
            long lastContId = headerIndex.getLast(ContainerManagementInformation.CHP_CONT_ID);
            boolean bl = isOpen = (int)headerIndex.getLast(ContainerManagementInformation.CHP_ANZ_DS) == -1;
            if (!isOpen) {
                return NO_OPEN_CONTAINER;
            }
            return this.initOpenContainerDataFromFile(containerDirectory, lastContId);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    private OpenContainerData initOpenContainerDataFromFile(LockedContainerDirectory dir, long containerId) throws SynchronizationFailedException, PersistenceException {
        if (!dir.lock().isValid()) {
            throw new IllegalArgumentException("Der Parameter \"indexLock\" ist ung\u00fcltig:" + String.valueOf(dir.lock()));
        }
        try (ContainerFileHandle handle = this.accessContainer(dir, containerId);){
            OpenContainerData openContainerData;
            int anz = 0;
            long minArchiveTime = Long.MAX_VALUE;
            long maxArchiveTime = -1L;
            long minDataTime = Long.MAX_VALUE;
            long maxDataTime = -1L;
            long minDataIndex = Long.MAX_VALUE;
            long maxDataIndex = -1L;
            boolean lastDataIsNoSrc = false;
            try (ContainerDataIterator iter = handle.iterator();){
                ContainerDataResult result = new ContainerDataResult();
                while (!iter.isEmpty()) {
                    ++anz;
                    iter.poll(result);
                    minArchiveTime = Math.min(minArchiveTime, result.getArchiveTime());
                    maxArchiveTime = Math.max(maxArchiveTime, result.getArchiveTime());
                    minDataTime = Math.min(minDataTime, result.getDataTime());
                    maxDataTime = Math.max(maxDataTime, result.getDataTime());
                    minDataIndex = Math.min(minDataIndex, result.getDataIndex());
                    maxDataIndex = Math.max(maxDataIndex, result.getDataIndex());
                    lastDataIsNoSrc = result.isNoSource();
                }
            }
            catch (PersistenceException ex) {
                debug.fine("Offener Container kann nicht gelesen werden", (Throwable)ex);
            }
            if (anz == 0) {
                openContainerData = NO_OPEN_CONTAINER;
                return openContainerData;
            }
            if (dir.archiveDataKind() == ArchiveDataKind.ONLINE) {
                this.containerCreator.getDataIdentTree().get(dir.dataIdentification()).setLastOAWasNoSource(lastDataIsNoSrc);
            }
            openContainerData = new StandardOpenContainerData(anz, minArchiveTime, maxArchiveTime, minDataTime, maxDataTime, minDataIndex, maxDataIndex, containerId);
            return openContainerData;
        }
    }

    Map<IdDataIdentification, StandardOpenContainerData[]> getOpenContainerData() {
        HashMap<IdDataIdentification, StandardOpenContainerData[]> tmpMap = new HashMap<IdDataIdentification, StandardOpenContainerData[]>();
        for (Map.Entry<IdContainerFileDir, OpenContainerData> entry : this.openContainerData.entrySet()) {
            IdDataIdentification dataIdentification = entry.getKey().dataIdentification();
            ArchiveDataKind archiveDataKind = entry.getKey().archiveDataKind();
            OpenContainerData openContainerData = entry.getValue();
            if (!(openContainerData instanceof StandardOpenContainerData)) continue;
            StandardOpenContainerData containerData = (StandardOpenContainerData)openContainerData;
            StandardOpenContainerData[] data = tmpMap.computeIfAbsent(dataIdentification, it -> new StandardOpenContainerData[4]);
            data[archiveDataKind.getCode() - 1] = containerData;
        }
        return tmpMap;
    }

    public void setOpenContainerData(LockedContainerDirectory containerDirectory, StandardOpenContainerData data) {
        this.openContainerData.put(IdContainerFileDir.of(containerDirectory), data);
    }

    public void removeOpenContainerData(ContainerDirectory containerDirectory) {
        this.openContainerData.put(IdContainerFileDir.of(containerDirectory), NO_OPEN_CONTAINER);
    }

    public void deleteOpenContainerData(SyncKey<IdDataIdentification> lock, ArchiveDataKind adk) {
        IdDataIdentification did = lock.getElement();
        this.openContainerData.remove(did.resolve(adk));
    }

    public long openContainerDataSize() {
        return this.openContainerData.size();
    }

    @NotNull
    public Path getRebuildIdxFile(ContainerDirectory directory) {
        return this.getPath(directory).resolve(REBUILD_INDEX_FILE_FLAG_NAME);
    }

    public void createRebuildIxdFlagFile(ContainerDirectory directory) throws PersistenceException {
        Path idxFile = this.getRebuildIdxFile(directory);
        try {
            if (!Files.exists(idxFile, new LinkOption[0])) {
                Files.createFile(idxFile, new FileAttribute[0]);
            } else {
                debug.fine(String.valueOf(idxFile) + ": Datei existiert bereits.");
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Fehler beim Anlegen der '" + String.valueOf(idxFile) + "'", e);
        }
    }

    void removeRebuildIxdFlagFile(Path didPath) {
        Path file = didPath.resolve(REBUILD_INDEX_FILE_FLAG_NAME);
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            debug.warning("Datei konnte nicht gel\u00f6scht werden: " + String.valueOf(file), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDirty(ContainerDirectory directory) throws PersistenceException {
        Set<IdContainerFileDir> set = this.dirtyDirectories;
        synchronized (set) {
            if (!this.dirtyDirectories.add(IdContainerFileDir.of(directory))) {
                this.createRebuildIxdFlagFile(directory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsClean(ContainerDirectory directory) {
        Set<IdContainerFileDir> set = this.dirtyDirectories;
        synchronized (set) {
            if (this.dirtyDirectories.remove(IdContainerFileDir.of(directory))) {
                this.removeRebuildIxdFlagFile(this.getPath(directory));
            }
        }
    }

    void closeIndex(LockedContainerDirectory containerDirectory, @Nullable StandardOpenContainerData data) throws IndexException {
        if (data != null) {
            this.updateStandardIndexes(containerDirectory, data);
        }
        this.getIndexTree().closeIndexes(containerDirectory);
        this.markAsClean(containerDirectory);
    }

    public void flushIndexes(LockedContainerDirectory containerDirectory) {
        this.getIndexTree().flushIndexes(containerDirectory);
    }

    public long maxATime(ContainerDirectory containerDirectory) throws IndexException, SynchronizationFailedException {
        StandardOpenContainerData openContainerData = this.getOpenContainerData(containerDirectory);
        if (openContainerData instanceof StandardOpenContainerData) {
            StandardOpenContainerData containerData = openContainerData;
            return containerData.getMaxArcTime();
        }
        try (LockedContainerDirectory lockedContainerDirectory = this.containerCreator.lockIndex(containerDirectory);){
            Optional<? extends ArchiveTimeIndex> archiveTimeIndex = this.getIndexTree().getArchiveTimeIndex(lockedContainerDirectory);
            if (archiveTimeIndex.isEmpty()) {
                long l = Long.MIN_VALUE;
                return l;
            }
            long l = archiveTimeIndex.get().getLast(IndexValues.ArchiveTimeMax);
            return l;
        }
    }

    public long getOpenContID(ContainerDirectory containerDirectory) throws IndexException, SynchronizationFailedException {
        StandardOpenContainerData openContainerData = this.getOpenContainerData(containerDirectory);
        if (openContainerData instanceof StandardOpenContainerData) {
            StandardOpenContainerData containerData = openContainerData;
            return containerData.getContainerId();
        }
        return -1L;
    }

    @Override
    public IndexResult<IndexValues> getIndexResult(LockedContainerDirectory containerDirectory, SequenceSpecification sequenceSpecification) throws IndexException, SynchronizationFailedException {
        StandardOpenContainerData openContainerData = this.getOpenContainerData(containerDirectory);
        if (openContainerData != null) {
            this.updateStandardIndexes(containerDirectory, openContainerData);
        }
        return super.getIndexResult(containerDirectory, sequenceSpecification);
    }

    @Override
    public long estimate() {
        return Math.max(super.estimate(), (long)this.openContainerData.size());
    }

    @Override
    public DataRange getDataRange(LockedContainerDirectory directory) throws IndexException {
        DataRange dataRange = this.computeDataRange(directory);
        try {
            StandardOpenContainerData openContainerData = this.getOpenContainerData(directory);
            if (openContainerData != null) {
                if (dataRange instanceof ValidDataRange) {
                    ValidDataRange validDataRange = (ValidDataRange)dataRange;
                    return new SimpleDataRange(Math.min(validDataRange.minArchiveTime(), openContainerData.getMinArcTime()), Math.max(validDataRange.maxArchiveTime(), openContainerData.getMaxArcTime()), Math.min(validDataRange.minDataTime(), openContainerData.getMinDataTime()), Math.max(validDataRange.maxDataTime(), openContainerData.getMaxDataTime()), Math.min(validDataRange.minDataIndex(), openContainerData.getMinDataIdx()), Math.max(validDataRange.maxDataIndex(), openContainerData.getMaxDataIdx()));
                }
                return new SimpleDataRange(openContainerData.getMinArcTime(), openContainerData.getMaxArcTime(), openContainerData.getMinDataTime(), openContainerData.getMaxDataTime(), openContainerData.getMinDataIdx(), openContainerData.getMaxDataIdx());
            }
        }
        catch (SynchronizationFailedException e) {
            throw new AssertionError((Object)e);
        }
        return dataRange;
    }

    public void addIndexEntries(LockedContainerDirectory containerDirectory, long dataIdx, long arsTime, long dataTime, long openContID) throws IndexException {
        StandardOpenContainerData openContainerData = new StandardOpenContainerData(1L, arsTime, arsTime, dataTime, dataTime, dataIdx, dataIdx, openContID);
        this.setOpenContainerData(containerDirectory, openContainerData);
        this.updateStandardIndexes(containerDirectory, openContainerData);
    }

    public void updateStandardIndexes(LockedContainerDirectory containerDirectory) throws IndexException {
        OpenContainerData data = this.getLoadedContainerData(IdContainerFileDir.of(containerDirectory));
        if (data instanceof StandardOpenContainerData) {
            StandardOpenContainerData containerData = (StandardOpenContainerData)data;
            this.updateStandardIndexes(containerDirectory, containerData);
        }
    }

    public void updateStandardIndexes(LockedContainerDirectory containerDirectory, StandardOpenContainerData data) throws IndexException {
        ArrayList<BaseIndex> indices = new ArrayList<BaseIndex>(3);
        Supplier<IndexException> errorHandler = () -> new IndexException("Indexe fehlen", this.getPath(containerDirectory));
        indices.add(this.getIndexTree().getArchiveTimeIndex(containerDirectory).orElseThrow(errorHandler));
        indices.add(this.getIndexTree().getDataTimeIndex(containerDirectory).orElseThrow(errorHandler));
        if (containerDirectory.archiveDataKind().isRequested()) {
            indices.add(this.getIndexTree().getDataIndexIndex(containerDirectory).orElseThrow(errorHandler));
        }
        for (BaseIndex index : indices) {
            index.setInsertValue(IndexValues.ContainerId, data.getContainerId());
            index.setInsertValue(IndexValues.DataTimeMin, data.getMinDataTime());
            index.setInsertValue(IndexValues.DataTimeMax, data.getMaxDataTime());
            index.setInsertValue(IndexValues.ArchiveTimeMin, data.getMinArcTime());
            index.setInsertValue(IndexValues.ArchiveTimeMax, data.getMaxArcTime());
            index.setInsertValue(IndexValues.DataIndexMin, data.getMinDataIdx());
            index.setInsertValue(IndexValues.DataIndexMax, data.getMaxDataIdx());
            index.insertOrReplace(true);
        }
        for (BaseIndex index : indices) {
            index.insertOrReplace();
        }
    }

    public void updateMaxValues(ContainerDirectory containerDirectory, long dataIdx, long arsTime, long dataTime) throws IndexException, SynchronizationFailedException {
        StandardOpenContainerData openContainerData = this.getOpenContainerData(containerDirectory);
        if (openContainerData != null) {
            openContainerData.updateMax(dataIdx, arsTime, dataTime);
        }
    }

    public void closeIndexes(int numThreads) throws InterruptedException {
        Instant start = Instant.now();
        AtomicLong run = new AtomicLong();
        try (ThreadPoolExecutor threadPool = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100));){
            AtomicLong indexed = new AtomicLong();
            AtomicBoolean indexFinished = new AtomicBoolean();
            Map<IdDataIdentification, StandardOpenContainerData[]> tmpMap = this.getOpenContainerData();
            threadPool.submit(() -> {
                for (Map.Entry entry : tmpMap.entrySet()) {
                    StandardOpenContainerData[] value = (StandardOpenContainerData[])entry.getValue();
                    threadPool.submit(new IndexCloserWorker(run, (IdDataIdentification)entry.getKey(), value));
                    indexed.getAndIncrement();
                }
                indexFinished.set(true);
            });
            threadPool.shutdown();
            while (!threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                if (indexFinished.get()) {
                    debug.info("Indexe werden geschlossen: " + run.get() + " von " + String.valueOf(indexed) + " Datenidentifikationen\n" + StatusPrinter.estimateRuntime(Duration.between(start, Instant.now()), run.get(), indexed.get()));
                    continue;
                }
                debug.info("Indexe werden geschlossen: " + run.get() + " von mindestens " + String.valueOf(indexed) + " Datenidentifikationen\n" + StatusPrinter.estimateMinRuntime(Duration.between(start, Instant.now()), run.get(), indexed.get()));
            }
        }
        debug.info("Alle Indexe in " + StatusPrinter.formatDuration(Duration.between(start, Instant.now())) + " geschlossen: " + run.get());
    }

    public void closeOpenContainer(LockedContainerDirectory containerDirectory) throws IndexException, SynchronizationFailedException {
        StandardOpenContainerData openContainerData = this.getOpenContainerData(containerDirectory);
        if (openContainerData != null) {
            try (ContainerFileHandle containerFileHandle = this.accessOpenContainer(containerDirectory, openContainerData.getContainerId());){
                ContainerFile cf = containerFileHandle.getContainerFile();
                cf.closeContainer(openContainerData);
                this.updateContainerIndex(containerFileHandle, new LockedContainerDirectory(containerDirectory.lock(), ((StandaloneContainerFileHandle)containerFileHandle).getLocation().archiveDataKind()));
                this.updateStandardIndexes(containerDirectory, openContainerData);
                this.removeOpenContainerData(containerDirectory);
            }
            catch (PersistenceException e) {
                debug.error("Fehler beim Abschliessen eines Containers: " + e.getMessage() + Debug.NEWLINE + String.valueOf(this), (Throwable)e);
            }
        }
    }

    public void closePermanently() throws InterruptedException, PersistenceException {
        DataIdentificationDirWalk walk = DataIdentificationDirWalk.allDirectories(this);
        walk.setStatusPrinter(null);
        int numThreads = this.containerCreator.getCloseThreadCount();
        walk.execute("Container abschlie\u00dfen", numThreads, (dataIdentificationDir, walk1) -> {
            try (SyncKey<IdDataIdentification> key = this.containerCreator.lockIndex(dataIdentificationDir.getDataIdentification());){
                for (ArchiveDataKind archiveDataKind : ArchiveDataKindCombination.all()) {
                    this.closeOpenContainer(new LockedContainerDirectory(key, archiveDataKind));
                }
            }
        });
        this.closeIndexes(numThreads);
    }

    public long getDirtyDirectoriesSize() {
        return this.dirtyDirectories.size();
    }

    class IndexCloserWorker
    implements Runnable {
        private final AtomicLong _run;
        private final IdDataIdentification _dataIdentification;
        private final StandardOpenContainerData[] _data;

        public IndexCloserWorker(AtomicLong run, @NotNull IdDataIdentification dataIdentification, StandardOpenContainerData[] data) {
            this._run = run;
            this._dataIdentification = dataIdentification;
            this._data = data;
        }

        @Override
        public void run() {
            try {
                this._run.incrementAndGet();
                for (int i = 0; i < this._data.length; ++i) {
                    ArchiveDataKind adk = ArchiveDataKind.getInstance((int)(i + 1));
                    StandardOpenContainerData openContainerData = this._data[i];
                    if (openContainerData == null) continue;
                    this.closeIndexHelper(openContainerData, adk);
                }
            }
            catch (SynchronizationFailedException | IndexException e) {
                PersistenceDirectory.debug.error("Herunterfahren: Fehler beim Schliessen der Indexe: ", (Throwable)e);
            }
        }

        private void closeIndexHelper(StandardOpenContainerData openContainerData, ArchiveDataKind dataKind) throws IndexException, SynchronizationFailedException {
            try (LockedContainerDirectory containerDirectory = ActivePersistenceDirectory.this.containerCreator.lockIndex(new IdContainerFileDir(this._dataIdentification, dataKind));){
                ActivePersistenceDirectory.this.closeIndex(containerDirectory, openContainerData);
            }
        }
    }
}

