/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories.mgmt;

import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.ars.ars.persistence.ContainerCreator;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.PersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.DirectoryIsLockedException;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.LockFileManager;
import de.bsvrz.ars.ars.persistence.layout.ClassicPersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.ars.ars.persistence.layout.ShortPersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.sequence.SequenceSpecification;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;

public class SingletonPersistenceDirectoryManager
implements PersistenceDirectoryManager {
    private final ActivePersistenceDirectory persistenceDirectory;
    private final NavigableMap<Integer, ActivePersistenceDirectory> simulationDirectories = new TreeMap<Integer, ActivePersistenceDirectory>();
    private final LockFileManager lockFileManager = new LockFileManager();
    private static final Debug _debug = Debug.getLogger();
    private final ContainerCreator containerCreator;
    private final Path rootPath;

    public SingletonPersistenceDirectoryManager(ContainerCreator containerCreator, Path rootPath) {
        this.containerCreator = containerCreator;
        this.rootPath = rootPath;
        PersistenceDirectoryLayoutInstance layoutInstance = ClassicPersistenceDirectoryLayout.instance(rootPath, 0);
        this.persistenceDirectory = new ActivePersistenceDirectory(containerCreator, layoutInstance);
    }

    @Override
    public void updatePersistenceDirectories(long archTime) {
    }

    @Override
    @Nullable
    public ActivePersistenceDirectory getActivePersistenceDirectory() {
        return this.persistenceDirectory;
    }

    @Override
    public List<? extends PersistenceDirectory> getPersistenceDirectories(int simVariant, SequenceSpecification sequenceSpecification) {
        if (simVariant != 0) {
            ActivePersistenceDirectory simulationPersistenceDirectory = this.getSimulationPersistenceDirectory(simVariant);
            if (simulationPersistenceDirectory != null) {
                return List.of(simulationPersistenceDirectory);
            }
            return List.of();
        }
        return List.of(this.persistenceDirectory);
    }

    @Override
    @NotNull
    public Path getRootPath() {
        return this.persistenceDirectory.getBasePath();
    }

    @Override
    public void initialize() throws IOException, DirectoryIsLockedException {
        this.lockFileManager.open(this.persistenceDirectory.getBasePath());
    }

    @Override
    @Nullable
    public synchronized ActivePersistenceDirectory getSimulationPersistenceDirectory(int simVariant) {
        if (simVariant < 1) {
            throw new IllegalArgumentException("Keine g\u00fcltige Simulationsvariante: " + simVariant);
        }
        return (ActivePersistenceDirectory)this.simulationDirectories.get(simVariant);
    }

    @Override
    public ActivePersistenceDirectory createSimulationDirectory(int simVariant) {
        if (simVariant < 1) {
            throw new IllegalArgumentException("Keine g\u00fcltige Simulationsvariante: " + simVariant);
        }
        return this.simulationDirectories.computeIfAbsent(simVariant, sv -> new ActivePersistenceDirectory(this.containerCreator, ShortPersistenceDirectoryLayout.instance(this.rootPath.resolve("sim" + sv), sv)));
    }

    @Override
    public synchronized void shutDown() {
        try {
            this.lockFileManager.close(this.persistenceDirectory.getBasePath());
        }
        catch (IOException e) {
            _debug.warning("Persistenzverzeichnis konnte nicht geschlossen werden: " + String.valueOf(this.persistenceDirectory.getBasePath().toAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    public synchronized void deleteSimulationDirectory(ActivePersistenceDirectory directory) {
        TaskManager.runExclusively("Simulationsverzeichnis f\u00fcr Simulation " + directory.getSimulationVariant() + " l\u00f6schen", tpi -> this.simulationDirectories.remove(directory.getSimulationVariant(), directory));
    }

    @Override
    @NotNull
    public Path getGapFilePath(IdDataIdentification dataIdentification) {
        return this.persistenceDirectory.getPath(dataIdentification).resolve("_datagaps.txt");
    }

    @Override
    public boolean isRangeUnavailable(long fromArchiveTime, long toArchiveTime) {
        return false;
    }
}

