/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories.mgmt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.ars.ars.persistence.ContainerCreator;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.ReadonlyPersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.PersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.DirectoryIsLockedException;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.DirectoryStatus;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.LockFileManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeDomain;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.ars.ars.persistence.directories.mgmt.util.RangeUpdater;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.ars.ars.persistence.layout.ShortPersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.sequence.ArchiveTimeSequenceSpecification;
import de.bsvrz.ars.ars.persistence.sequence.SequenceSpecification;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;

public class TimeBasedPersistenceDirectoryManager<T extends TimeRange<T>>
implements PersistenceDirectoryManager {
    @Nullable
    private ActivePersistenceDirectory activePersistenceDirectory = null;
    private final NavigableMap<T, PersistenceDirectory> allPersistenceDirectories = new TreeMap<T, PersistenceDirectory>();
    private final NavigableMap<Integer, ActivePersistenceDirectory> simulationDirectories = new TreeMap<Integer, ActivePersistenceDirectory>();
    private final ContainerCreator containerCreator;
    private final Path rootPath;
    private final RangeUpdater<T> rangeUpdater;
    private final TimeDomain<T> domain;
    private final LockFileManager lockFileManager = new LockFileManager();
    private static final Debug _debug = Debug.getLogger();
    private final ShortPersistenceDirectoryLayout layout = ShortPersistenceDirectoryLayout.Instance;
    public static final String GAP_FILE_FOLDER_NAME = "_gaps";

    public TimeBasedPersistenceDirectoryManager(ContainerCreator containerCreator, Path rootPath, TimeDomain<T> domain) {
        this.containerCreator = containerCreator;
        this.rootPath = rootPath;
        this.rangeUpdater = new RangeUpdater<T>(domain);
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws IOException, InterruptedException, PersistenceException, DirectoryIsLockedException {
        List<PersistenceDirectory> persistenceDirectories;
        TimeBasedPersistenceDirectoryManager timeBasedPersistenceDirectoryManager = this;
        synchronized (timeBasedPersistenceDirectoryManager) {
            this.initializeDirectories();
            if (this.allPersistenceDirectories.isEmpty()) {
                return;
            }
            PersistenceDirectory lastValue = this.allPersistenceDirectories.lastEntry().getValue();
            if (lastValue instanceof ActivePersistenceDirectory) {
                ActivePersistenceDirectory persistenceDirectory;
                this.activePersistenceDirectory = persistenceDirectory = (ActivePersistenceDirectory)lastValue;
            }
            persistenceDirectories = List.copyOf(this.allPersistenceDirectories.values());
        }
        for (PersistenceDirectory value : persistenceDirectories) {
            if (value == this.activePersistenceDirectory || !(value instanceof ActivePersistenceDirectory)) continue;
            ActivePersistenceDirectory apd = (ActivePersistenceDirectory)value;
            this.closePersistenceDirectory(apd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePersistenceDirectories(long archTime) throws IOException {
        ActivePersistenceDirectory directory;
        TimeBasedPersistenceDirectoryManager timeBasedPersistenceDirectoryManager = this;
        synchronized (timeBasedPersistenceDirectoryManager) {
            T nextRange = this.rangeUpdater.update(archTime);
            if (nextRange == null) {
                return;
            }
            directory = this.activePersistenceDirectory;
            if (directory != null && directory == this.allPersistenceDirectories.get(nextRange)) {
                return;
            }
            this.activePersistenceDirectory = this.createDirectory(nextRange);
            this.allPersistenceDirectories.put(nextRange, this.activePersistenceDirectory);
        }
        if (directory != null) {
            try {
                this.closePersistenceDirectory(directory);
            }
            catch (Exception e) {
                _debug.warning("Unerwarteter Fehler beim Abschlie\u00dfen eines Persistenzverzeichnisses", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePersistenceDirectory(ActivePersistenceDirectory activeDirectory) throws InterruptedException, PersistenceException {
        Path basePath = activeDirectory.getBasePath();
        Path relativePath = this.getRelativePath(basePath);
        _debug.info("Schlie\u00dfe Verzeichnis ab: " + String.valueOf(relativePath));
        T domain = this.domain.ofPath(relativePath);
        if (domain == null) {
            throw new PersistenceException("Zeitbereich des Verzeichnisses '" + String.valueOf(relativePath) + "' konnte nicht bestimmt werden.");
        }
        activeDirectory.closePermanently();
        try {
            this.lockFileManager.writeProtectPermanently(basePath);
        }
        catch (IOException e) {
            throw new PersistenceException("Fehler beim L\u00f6schen der Lock-Datei in " + String.valueOf(activeDirectory));
        }
        TimeBasedPersistenceDirectoryManager timeBasedPersistenceDirectoryManager = this;
        synchronized (timeBasedPersistenceDirectoryManager) {
            ReadonlyPersistenceDirectory immutableInstance = new ReadonlyPersistenceDirectory(this.containerCreator, activeDirectory.getLayoutInstance());
            immutableInstance.setCount(activeDirectory.estimate());
            this.allPersistenceDirectories.put(domain, immutableInstance);
        }
    }

    private void initializeDirectories() throws IOException, PersistenceException, DirectoryIsLockedException {
        Files.createDirectories(this.rootPath, new FileAttribute[0]);
        this.executeOnSubDirectories(this::initializeExistingDirectory);
    }

    public void executeOnSubDirectories(PathAction pathAction) throws PersistenceException, IOException, DirectoryIsLockedException {
        this.executeOnSubDirectories(this.rootPath, this.domain.getMaxDepth(), pathAction);
    }

    private void executeOnSubDirectories(Path p, int maxDepth, PathAction pathAction) throws PersistenceException, IOException, DirectoryIsLockedException {
        try (Stream<Path> pathStream = Files.list(p);){
            List<Path> paths = pathStream.sorted().toList();
            for (Path path : paths) {
                if (!Files.isDirectory(path, new LinkOption[0]) || path.getFileName().toString().equals("backup")) continue;
                if (this.getId(path) != null) {
                    pathAction.run(path);
                    continue;
                }
                if (maxDepth <= 1) continue;
                this.executeOnSubDirectories(path, maxDepth - 1, pathAction);
            }
        }
    }

    @Contract(pure=true)
    @NotNull
    public TimeDomain<T> getDomain() {
        return this.domain;
    }

    @Contract(pure=true)
    @Nullable
    public T getId(Path it) {
        return this.domain.ofPath(this.getRelativePath(it));
    }

    @Contract(pure=true)
    @NotNull
    private Path getRelativePath(@NotNull Path path) {
        if (path.isAbsolute() == this.rootPath.isAbsolute()) {
            return this.rootPath.relativize(path);
        }
        if (!path.isAbsolute()) {
            return path;
        }
        return this.rootPath.toAbsolutePath().relativize(path);
    }

    @NotNull
    private PersistenceDirectory initializeExistingDirectory(Path persistenceDirectory) throws PersistenceException, DirectoryIsLockedException {
        try {
            DirectoryStatus status = this.lockFileManager.open(persistenceDirectory);
            PersistenceDirectoryLayoutInstance layoutInstance = this.layout.createInstance(persistenceDirectory, 0);
            PersistenceDirectory tmp = status == DirectoryStatus.Writable ? new ActivePersistenceDirectory(this.containerCreator, layoutInstance) : new ReadonlyPersistenceDirectory(this.containerCreator, layoutInstance);
            this.allPersistenceDirectories.put(this.getId(persistenceDirectory), tmp);
            return tmp;
        }
        catch (IOException e) {
            throw new PersistenceException("Fehler beim Initialisieren des Verzeichnisses: " + String.valueOf(persistenceDirectory), e);
        }
    }

    @NotNull
    private ActivePersistenceDirectory createDirectory(T timeKey) throws IOException {
        Path persistenceDirectory = this.rootPath.resolve(this.domain.getPath(timeKey));
        this.lockFileManager.forceWritable(persistenceDirectory);
        ActivePersistenceDirectory tmp = new ActivePersistenceDirectory(this.containerCreator, this.layout.createInstance(persistenceDirectory, 0));
        this.allPersistenceDirectories.put(timeKey, tmp);
        return tmp;
    }

    @Override
    @Nullable
    public synchronized ActivePersistenceDirectory getActivePersistenceDirectory() {
        return this.activePersistenceDirectory;
    }

    @Override
    public synchronized List<? extends PersistenceDirectory> getPersistenceDirectories(int simVariant, SequenceSpecification sequenceSpecification) {
        if (simVariant != 0) {
            ActivePersistenceDirectory simulationPersistenceDirectory = this.getSimulationPersistenceDirectory(simVariant);
            if (simulationPersistenceDirectory != null) {
                return List.of(simulationPersistenceDirectory);
            }
            return List.of();
        }
        if (sequenceSpecification instanceof ArchiveTimeSequenceSpecification) {
            ArchiveTimeSequenceSpecification specification = (ArchiveTimeSequenceSpecification)sequenceSpecification;
            Range<Long> specificationMillisRange = specification.asMillisRange();
            return this.allPersistenceDirectories.entrySet().stream().filter(it -> specificationMillisRange.isConnected(((TimeRange)it.getKey()).getEpochMillisRange())).map(Map.Entry::getValue).filter(Objects::nonNull).toList();
        }
        return ImmutableList.copyOf(this.allPersistenceDirectories.values());
    }

    @Override
    @Nullable
    public synchronized ActivePersistenceDirectory getSimulationPersistenceDirectory(int simVariant) {
        if (simVariant < 1) {
            throw new IllegalArgumentException("Keine g\u00fcltige Simulationsvariante: " + simVariant);
        }
        return (ActivePersistenceDirectory)this.simulationDirectories.get(simVariant);
    }

    @Override
    public synchronized ActivePersistenceDirectory createSimulationDirectory(int simVariant) {
        if (simVariant < 1) {
            throw new IllegalArgumentException("Keine g\u00fcltige Simulationsvariante: " + simVariant);
        }
        return this.simulationDirectories.computeIfAbsent(simVariant, sv -> new ActivePersistenceDirectory(this.containerCreator, this.layout.createInstance(this.rootPath.resolve("sim" + sv), (int)sv)));
    }

    @Override
    @NotNull
    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public synchronized void shutDown() {
        for (PersistenceDirectory value : this.allPersistenceDirectories.values()) {
            try {
                this.lockFileManager.close(value.getBasePath());
            }
            catch (IOException e) {
                _debug.warning("Persistenzverzeichnis konnte nicht geschlossen werden: " + String.valueOf(value.getBasePath().toAbsolutePath()), (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void deleteSimulationDirectory(ActivePersistenceDirectory directory) {
        TaskManager.runExclusively("Simulationsverzeichnis f\u00fcr Simulation " + directory.getSimulationVariant() + " l\u00f6schen", tpi -> this.simulationDirectories.remove(directory.getSimulationVariant(), directory));
    }

    @Override
    @NotNull
    public Path getGapFilePath(IdDataIdentification dataIdentification) {
        return this.getRootPath().resolve(GAP_FILE_FOLDER_NAME).resolve(TimeBasedPersistenceDirectoryManager.generateFileName(dataIdentification));
    }

    static Path generateFileName(IdDataIdentification dataIdentification) {
        String atgName = ShortPersistenceDirectoryLayout.encode(dataIdentification.getAtgId());
        String aspName = ShortPersistenceDirectoryLayout.encode(dataIdentification.getAspectId());
        String objName = ShortPersistenceDirectoryLayout.encode(dataIdentification.getObjectId());
        return Paths.get(atgName, aspName, objName + ".datagaps");
    }

    public synchronized PersistenceDirectory getPersistenceDirectory(@NotNull T directoryTimeRange) {
        return (PersistenceDirectory)this.allPersistenceDirectories.get(Objects.requireNonNull(directoryTimeRange));
    }

    public synchronized boolean removePersistenceDirectory(T directoryTimeRange) {
        Path fileName = this.domain.getPath(directoryTimeRange);
        try {
            return TaskManager.computeExclusively("Verzeichnis " + String.valueOf(fileName) + " auswerfen", tpi -> {
                PersistenceDirectory directory = (PersistenceDirectory)this.allPersistenceDirectories.get(directoryTimeRange);
                if (directory == null || directory instanceof ActivePersistenceDirectory) {
                    return false;
                }
                try {
                    this.lockFileManager.close(directory.getBasePath());
                }
                catch (IOException e) {
                    _debug.warning("Persistenzverzeichnis konnte nicht geschlossen werden: " + String.valueOf(directory.getBasePath().toAbsolutePath()), (Throwable)e);
                }
                this.allPersistenceDirectories.remove(directoryTimeRange);
                return true;
            });
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPersistenceDirectory(T directoryTimeRange) {
        try {
            PersistenceDirectory existingDirectory;
            TimeBasedPersistenceDirectoryManager timeBasedPersistenceDirectoryManager = this;
            synchronized (timeBasedPersistenceDirectoryManager) {
                PersistenceDirectory directory = (PersistenceDirectory)this.allPersistenceDirectories.get(directoryTimeRange);
                if (directory != null) {
                    return false;
                }
                Path path = this.domain.getPath(directoryTimeRange);
                existingDirectory = this.initializeExistingDirectory(this.rootPath.resolve(path));
            }
            if (existingDirectory instanceof ActivePersistenceDirectory) {
                ActivePersistenceDirectory persistenceDirectory = (ActivePersistenceDirectory)existingDirectory;
                this.closePersistenceDirectory(persistenceDirectory);
            }
            return true;
        }
        catch (PersistenceException | DirectoryIsLockedException | InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean isRangeUnavailable(long fromArchiveTime, long toArchiveTime) {
        T toInterval;
        T fromInterval = this.domain.ofEpochMillis(fromArchiveTime);
        if (fromInterval.stepsUntil(toInterval = this.domain.ofEpochMillis(toArchiveTime)) <= 0L) {
            return false;
        }
        TimeRange temp = (TimeRange)fromInterval.next();
        while (!temp.equals(toInterval)) {
            if (this.getPersistenceDirectory(temp) == null) {
                return true;
            }
            temp = (TimeRange)temp.next();
        }
        return false;
    }

    public static interface PathAction {
        public void run(Path var1) throws PersistenceException, DirectoryIsLockedException;
    }
}

