/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories.mgmt.util;

import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeDomain;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;

public class RangeUpdater<T extends TimeRange<T>> {
    private final TimeDomain<T> domain;
    private T lastRange;

    public RangeUpdater(TimeDomain<T> domain) {
        this.domain = domain;
    }

    @Nullable
    public T update(long monotoneArchiveTime) {
        T currentRange = this.getRange(monotoneArchiveTime);
        if (this.lastRange == null || this.lastRange.compareTo(currentRange) < 0) {
            this.lastRange = currentRange;
            return currentRange;
        }
        return null;
    }

    @NotNull
    public T getRange(long monotoneArchiveTime) {
        return this.domain.ofEpochMillis(monotoneArchiveTime);
    }
}

