/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.gap;

import com.google.common.base.Splitter;
import com.google.common.collect.Range;
import de.bsvrz.ars.ars.mgmt.tasks.DataIndexRangeSet;
import de.bsvrz.ars.ars.persistence.gap.GapFile;
import de.bsvrz.ars.ars.persistence.gap.RemoteArchive;
import de.bsvrz.ars.ars.persistence.gap.util.RangeMultimap;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GapFileImpl
implements GapFile {
    private static final String GAP_KEYWORD = "<not_in>";
    private static final String GAP_IDX_SEPARATOR = "-";
    private static final String GAP_ARCH_SEPARATOR = "#";
    private static final Splitter ARS_SPLITTER = Splitter.on((String)"#");
    private static final Pattern GAP_PAT = Pattern.compile("^(\\d+)-(\\d+)<not_in>(\\S+)$");
    private static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private final Path _path;
    private static final Debug _debug = Debug.getLogger();

    public GapFileImpl(Path path) {
        this._path = path;
    }

    @Override
    public void readGaps(Map<? super RemoteArchive, DataIndexRangeSet> map) {
        Path gapFile = this._path;
        try (BufferedReader reader2 = Files.newBufferedReader(gapFile, CHARSET);){
            this.readGaps(map, reader2);
        }
        catch (NoSuchFileException reader2) {
        }
        catch (IOException e) {
            _debug.warning("Lueckendatei '" + String.valueOf(gapFile) + " konnte nicht gelesen werden.", (Throwable)e);
        }
    }

    @Override
    public void writeGaps(Map<? extends RemoteArchive, ? extends DataIndexRangeSet> map) {
        Path tmpGapFile = this._path.resolveSibling(String.valueOf(this._path.getFileName()) + ".tmp");
        try {
            Path parent = tmpGapFile.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(tmpGapFile, CHARSET, new OpenOption[0]);){
                GapFileImpl.writeGaps(map, writer);
            }
            Files.move(tmpGapFile, this._path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            _debug.warning("Temporaere Lueckendatei '" + String.valueOf(tmpGapFile) + " konnte nicht angelegt werden: " + e.getMessage());
        }
    }

    private void readGaps(Map<? super RemoteArchive, DataIndexRangeSet> resultMap, BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            Matcher m = GAP_PAT.matcher(line);
            if (!m.matches()) continue;
            long start = Long.parseLong(m.group(1));
            long end = Long.parseLong(m.group(2));
            Iterable pids = ARS_SPLITTER.split((CharSequence)m.group(3));
            for (String pid : pids) {
                RemoteArchive object = RemoteArchive.open(pid);
                DataIndexRangeSet ranges = resultMap.computeIfAbsent(object, key -> new DataIndexRangeSet());
                ranges.addRange(Util.dIdxNoModBits((long)start) + 1L, Util.dIdxNoModBits((long)end));
            }
        }
    }

    private static void writeGaps(Map<? extends RemoteArchive, ? extends DataIndexRangeSet> inputMap, BufferedWriter writer) throws IOException {
        RangeMultimap<Long, RemoteArchive> gapFileContent = new RangeMultimap<Long, RemoteArchive>();
        for (Map.Entry<? extends RemoteArchive, ? extends DataIndexRangeSet> entry : inputMap.entrySet()) {
            for (Range<Long> range : entry.getValue()) {
                gapFileContent.put(range, entry.getKey());
            }
        }
        for (Map.Entry<RemoteArchive, Iterable<Range<Long>>> entry : gapFileContent.entries()) {
            Range range = (Range)entry.getKey();
            SortedSet objects = (SortedSet)entry.getValue();
            writer.write(String.valueOf(Util.dIdxAppendZeroModBits((long)((Long)range.lowerEndpoint())) - 2L));
            writer.write(GAP_IDX_SEPARATOR);
            writer.write(String.valueOf(Util.dIdxAppendZeroModBits((long)((Long)range.upperEndpoint()))));
            writer.write(GAP_KEYWORD);
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                RemoteArchive object = (RemoteArchive)iterator.next();
                writer.write(object.getPid());
                if (!iterator.hasNext()) continue;
                writer.write(GAP_ARCH_SEPARATOR);
            }
            writer.newLine();
        }
    }
}

