/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.gap;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.Objects;

public class RemoteArchive
implements Comparable<RemoteArchive> {
    private static final Debug _debug = Debug.getLogger();
    private final String _pid;

    private RemoteArchive(String pid) {
        this._pid = Objects.requireNonNull(pid);
    }

    public static RemoteArchive open(String pid) {
        return new RemoteArchive(pid);
    }

    public static RemoteArchive open(SystemObject object) {
        return new RemoteArchive(object.getPid());
    }

    @Nullable
    public ArchiveRequestManager createRequestManager(ClientDavInterface connection) {
        SystemObject object = connection.getDataModel().getObject(this._pid);
        if (object != null) {
            try {
                return connection.getArchive(object);
            }
            catch (Exception e) {
                _debug.fine("Das Archiv mit der PID '" + this._pid + "' ist ung\u00fcltig.", (Throwable)e);
                return null;
            }
        }
        _debug.fine("Das Archiv mit der PID '" + this._pid + "' ist ung\u00fcltig.");
        return null;
    }

    public String getPid() {
        return this._pid;
    }

    @Override
    public int compareTo(RemoteArchive o) {
        return this._pid.compareTo(o.getPid());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteArchive that = (RemoteArchive)o;
        return this._pid.equals(that._pid);
    }

    public int hashCode() {
        return this._pid.hashCode();
    }

    public String toString() {
        return this._pid;
    }
}

