/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.gap.util;

import com.google.common.collect.Collections2;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class RangeMultimap<K extends Comparable<? super K>, V extends Comparable<V>> {
    private static final Object EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private final RangeMap<K, TreeSet<V>> _delegate = TreeRangeMap.create();

    @Nullable
    public SortedSet<V> get(K key) {
        TreeSet s = (TreeSet)this._delegate.get(key);
        if (s == null) {
            return (SortedSet)EMPTY_SORTED_SET;
        }
        return Collections.unmodifiableSortedSet(s);
    }

    public Range<K> span() {
        return this._delegate.span();
    }

    public void put(Range<K> range, V value) {
        this.addValueTo(value, range);
    }

    public void clear() {
        this._delegate.clear();
    }

    private void addValueTo(V value, Range<K> span) {
        TreeSet<V> set;
        Comparable lowerEndPoint = span.lowerEndpoint();
        Comparable upperEndpoint = span.upperEndpoint();
        Map.Entry lowerEntry = this._delegate.getEntry(lowerEndPoint);
        Map.Entry upperEntry = this._delegate.getEntry(upperEndpoint);
        if (lowerEntry != null && !((TreeSet)lowerEntry.getValue()).contains(value) && !((Range)lowerEntry.getKey()).lowerEndpoint().equals(lowerEndPoint)) {
            this._delegate.put(((Range)lowerEntry.getKey()).intersection(span), new TreeSet((SortedSet)lowerEntry.getValue()));
        }
        if (upperEntry != null && !((TreeSet)upperEntry.getValue()).contains(value) && !((Range)upperEntry.getKey()).upperEndpoint().equals(upperEndpoint)) {
            this._delegate.put(((Range)upperEntry.getKey()).intersection(span), new TreeSet((SortedSet)upperEntry.getValue()));
        }
        TreeRangeSet remainingSpans = TreeRangeSet.create();
        remainingSpans.add(span);
        for (Map.Entry entry : List.copyOf(this._delegate.subRangeMap(span).asMapOfRanges().entrySet())) {
            set = new TreeSet<V>((SortedSet)entry.getValue());
            set.add(value);
            this._delegate.putCoalescing((Range)entry.getKey(), set);
            remainingSpans.remove((Range)entry.getKey());
        }
        for (Range range : remainingSpans.asRanges()) {
            set = new TreeSet();
            set.add(value);
            this._delegate.putCoalescing(range, set);
        }
    }

    public Collection<Map.Entry<Range<K>, SortedSet<V>>> entries() {
        return Collections2.transform(this._delegate.asMapOfRanges().entrySet(), it -> Map.entry((Range)it.getKey(), Collections.unmodifiableSortedSet((SortedSet)it.getValue())));
    }

    public String toString() {
        return this._delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeMultimap that = (RangeMultimap)o;
        return this._delegate.equals(that._delegate);
    }

    public int hashCode() {
        return this._delegate.hashCode();
    }
}

