/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index;

import de.bsvrz.ars.ars.mgmt.datatree.IndexImpl;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndex;
import de.bsvrz.ars.ars.persistence.index.CorruptIndexException;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.backend.management.AbstractIndex;
import de.bsvrz.ars.ars.persistence.index.backend.management.ColumnType;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;
import java.nio.file.Path;

public class ArchiveTimeIndexImpl
extends AbstractIndex<IndexValues>
implements ArchiveTimeIndex {
    public static final String IDX_FILENAME = IndexImpl.ArchiveTime.getFileName();
    private static final IndexContentDescriptor<IndexValues> INDEX_CONTENT_DESCRIPTOR = new IndexContentDescriptor<IndexValues>(IndexValues.class);

    public ArchiveTimeIndexImpl(int bufferSize, Path file) throws CorruptIndexException {
        this(bufferSize, file, INDEX_CONTENT_DESCRIPTOR);
    }

    public ArchiveTimeIndexImpl(int bufferSize, Path file, IndexContentDescriptor<IndexValues> contentDescriptor) throws CorruptIndexException {
        super(contentDescriptor, bufferSize, file);
    }

    public void add(long dIMin, long dIMax, long aTMin, long aTMax, long dTMin, long dTMax, long cID) throws IndexException {
        this.checkAdd(dIMin, dIMax, aTMin, aTMax, dTMin, dTMax, cID);
        this.setInsertValue(IndexValues.DataIndexMin, dIMin);
        this.setInsertValue(IndexValues.DataIndexMax, dIMax);
        this.setInsertValue(IndexValues.ArchiveTimeMin, aTMin);
        this.setInsertValue(IndexValues.ArchiveTimeMax, aTMax);
        this.setInsertValue(IndexValues.DataTimeMin, dTMin);
        this.setInsertValue(IndexValues.DataTimeMax, dTMax);
        this.setInsertValue(IndexValues.ContainerId, cID);
        this.append();
    }

    protected void checkAdd(long dIMin, long dIMax, long aTMin, long aTMax, long dTMin, long dTMax, long cID) throws IndexException {
        try {
            if (dIMin < 0L || dIMax < 0L || aTMin < 0L || aTMax < 0L || dTMin < 0L || dTMax < 0L || cID <= 0L) {
                throw new IllegalArgumentException("Neueintrag im monotonen Index ung\u00fcltig:");
            }
        }
        catch (Exception e) {
            throw new CorruptIndexException(e.getMessage() + " (dIMin=" + dIMin + ", dIMax=" + dIMax + ", aTMin=" + aTMin + ", aTMax=" + aTMax + ", dTMin=" + dTMin + ", dTMax=" + dTMax + ", contID=" + cID + ")", this.getFile(), e);
        }
    }

    public long getAbsoluteATMin() throws IndexException {
        return this.getFirst(IndexValues.DataTimeMin);
    }

    public static int entrySize() {
        return INDEX_CONTENT_DESCRIPTOR.getEntryLengthBytes();
    }

    static {
        INDEX_CONTENT_DESCRIPTOR.addRange(8, IndexValues.DataIndexMin, ColumnType.Unordered, IndexValues.DataIndexMax, ColumnType.Unordered);
        INDEX_CONTENT_DESCRIPTOR.addRange(6, IndexValues.ArchiveTimeMin, ColumnType.Increasing, IndexValues.ArchiveTimeMax, ColumnType.Increasing);
        INDEX_CONTENT_DESCRIPTOR.addRange(6, IndexValues.DataTimeMin, ColumnType.Unordered, IndexValues.DataTimeMax, ColumnType.Unordered);
        INDEX_CONTENT_DESCRIPTOR.addColumn(5, IndexValues.ContainerId, ColumnType.StrictlyIncreasing);
    }

    @Deprecated
    public static enum Key {
        DI,
        AT,
        DT;

    }
}

