/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.backend.management;

import com.google.common.collect.ImmutableMap;
import de.bsvrz.ars.ars.persistence.index.CorruptIndexException;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.backend.management.BaseIndex;
import de.bsvrz.ars.ars.persistence.index.backend.management.ColumnType;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexImplementation;
import de.bsvrz.ars.ars.persistence.index.backend.management.LongRange;
import de.bsvrz.ars.ars.persistence.index.backend.storage.HybridStorage;
import de.bsvrz.ars.ars.persistence.index.result.BinaryIndexResult;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class AbstractIndex<E extends Enum<E>>
implements BaseIndex<E> {
    private final Map<IndexContentDescriptor.IndexColumn, IndexImplementation> _indexes;
    private final HybridStorage _storage;
    private final IndexContentDescriptor<E> _indexContentDescriptor;
    private final byte[] _tmp;
    private final IndexImplementation _mainIndex;
    private final long[] _insertLongValues;
    private final String[] _insertStringValues;
    private boolean _closed;

    public AbstractIndex(IndexContentDescriptor<E> indexContentDescriptor, int bufferSize, @Nullable Path file) throws CorruptIndexException {
        this._indexContentDescriptor = indexContentDescriptor;
        try {
            this._storage = new HybridStorage(this._indexContentDescriptor.getEntryLengthBytes(), bufferSize, file);
        }
        catch (IOException e) {
            throw new CorruptIndexException("Kann Index nicht \u00f6ffnen", file, e);
        }
        ImmutableMap.Builder indexMapBuilder = ImmutableMap.builder();
        for (IndexContentDescriptor.IndexColumn column : indexContentDescriptor.getColumns()) {
            switch (column.getType()) {
                case StrictlyIncreasing: {
                    indexMapBuilder.put((Object)column, (Object)new StrictlyIncreasingIndex(column));
                    break;
                }
                case Increasing: {
                    indexMapBuilder.put((Object)column, (Object)new IncreasingIndex(column));
                }
            }
        }
        this._tmp = new byte[this._storage.entryByteSize()];
        this._indexes = indexMapBuilder.build();
        if (this._indexes.isEmpty()) {
            throw new IllegalArgumentException("Keine Indexspalte definiert");
        }
        this._mainIndex = this._indexes.values().iterator().next();
        this._insertLongValues = new long[indexContentDescriptor.getColumns().size()];
        this._insertStringValues = new String[indexContentDescriptor.getColumns().size()];
    }

    @Override
    public IndexResult<E> query(Map<E, LongRange> query) throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        try {
            BinaryIndexResult<E> result = new BinaryIndexResult<E>(this._indexContentDescriptor);
            if (this._storage.numEntries() == 0L) {
                return result;
            }
            LongRange range = this.indexQuery(query);
            if (range == null) {
                return result;
            }
            long lowerEndpoint = range.lowerEndpoint();
            long upperEndpoint = range.upperEndpoint();
            byte[] data = null;
            for (long indexIdx = lowerEndpoint; indexIdx <= upperEndpoint; ++indexIdx) {
                byte[] prevData = data;
                data = new byte[this._indexContentDescriptor.getEntryLengthBytes()];
                this._storage.getEntries(indexIdx, 1, data);
                if (!this.isDirectMatch(data, query)) continue;
                if (prevData != null && this.containsIntervalStart(prevData, data, query)) {
                    result.add(prevData);
                }
                result.add(data);
                data = null;
            }
            if (result.isEmpty() && data != null) {
                result.add(data);
            }
            if (upperEndpoint < this._storage.numEntries() - 1L) {
                data = new byte[this._indexContentDescriptor.getEntryLengthBytes()];
                this._storage.getEntries(upperEndpoint + 1L, 1, data);
                result.setNext(data);
            }
            return result;
        }
        catch (IOException e) {
            throw new IndexException("Fehler bei Indexabfrage (" + String.valueOf(query) + ")", this.getFile(), e);
        }
    }

    @Override
    public IndexResult<E> query() throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        try {
            BinaryIndexResult<E> result = new BinaryIndexResult<E>(this._indexContentDescriptor);
            for (long indexIdx = 0L; indexIdx < this._storage.numEntries(); ++indexIdx) {
                byte[] data = new byte[this._indexContentDescriptor.getEntryLengthBytes()];
                this._storage.getEntries(indexIdx, 1, data);
                result.add(data);
            }
            return result;
        }
        catch (IOException e) {
            throw new IndexException("Fehler bei Indexabfrage (Alle Elemente)", this.getFile(), e);
        }
    }

    @Override
    public final void setInsertValue(E column, long value) {
        IndexContentDescriptor.IndexColumn tmp = this._indexContentDescriptor.getColumn(column);
        if (tmp == null) {
            return;
        }
        if (tmp.getType() == ColumnType.String) {
            throw new IllegalArgumentException("Versuch, einen Long-Wert in eine String-Spalte einzuf\u00fcgen.");
        }
        this._insertLongValues[tmp.getColumnIndex()] = value;
    }

    @Override
    public final void setInsertValue(E column, String value) {
        IndexContentDescriptor.IndexColumn tmp = this._indexContentDescriptor.getColumn(column);
        if (tmp == null) {
            return;
        }
        if (tmp.getType() != ColumnType.String) {
            throw new IllegalArgumentException("Versuch, einen String-Wert in eine Long-Spalte einzuf\u00fcgen.");
        }
        this._insertStringValues[tmp.getColumnIndex()] = value;
    }

    @Override
    public IndexResult<E> first() throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        BinaryIndexResult<E> result = new BinaryIndexResult<E>(this._indexContentDescriptor);
        if (this._storage.numEntries() == 0L) {
            return result;
        }
        byte[] tmp = new byte[this._indexContentDescriptor.getEntryLengthBytes()];
        try {
            this._storage.getFirst(tmp);
        }
        catch (IOException e) {
            throw new IndexException("Fehler beim Ermitteln des ersten Werts", this.getFile(), e);
        }
        result.add(tmp);
        return result;
    }

    private boolean isDirectMatch(byte[] data, Map<E, LongRange> query) {
        List<IndexContentDescriptor.IndexColumn> columns = this._indexContentDescriptor.getColumns();
        for (IndexContentDescriptor.IndexColumn column : columns) {
            long value;
            LongRange range = query.get(column.getData());
            if (range == null || range.contains(value = column.readLong(data))) continue;
            return false;
        }
        return true;
    }

    private boolean containsIntervalStart(byte[] prevData, byte[] data, Map<E, LongRange> query) {
        List<IndexContentDescriptor.IndexColumn> columns = this._indexContentDescriptor.getColumns();
        for (IndexContentDescriptor.IndexColumn column : columns) {
            LongRange range = query.get(column.getData());
            if (range == null || !range.hasLowerBound()) continue;
            long lowerEndpoint = range.lowerEndpoint();
            long prevValue = column.readLong(prevData);
            IndexContentDescriptor.IndexColumn minColumn = column.getMinColumn();
            long startValue = minColumn.readLong(data);
            if (lowerEndpoint <= prevValue || lowerEndpoint >= startValue) continue;
            return true;
        }
        return false;
    }

    @Override
    public void insert() throws IndexException {
        this.insert(false);
    }

    @Override
    public void insertOrReplace() throws IndexException {
        this.insertOrReplace(false);
    }

    @Override
    public void insert(boolean onlyCheck) throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        try {
            long entryIndex = this.findExistingItem();
            if (entryIndex >= 0L) {
                long insertValue = this._insertLongValues[this._mainIndex.getColumn().getColumnIndex()];
                throw new IndexException("Index enth\u00e4lt bereits einen Wert " + insertValue + " in der Spalte " + String.valueOf(this._mainIndex.getColumn().getData()) + " in Zeilenindex " + entryIndex, this.getFile());
            }
            long position = -(entryIndex + 1L);
            this.checkCanInsert(position);
            if (onlyCheck) {
                return;
            }
            this.serializeData();
            this._storage.insertEntries(position, 1, this._tmp);
        }
        catch (IOException e) {
            throw new IndexException("Fehler beim Einf\u00fcgen", this.getFile(), e);
        }
    }

    @Override
    public void insertOrReplace(boolean onlyCheck) throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        try {
            long entryIndex = this.findExistingItem();
            if (entryIndex >= 0L) {
                this.checkCanReplace(entryIndex);
                if (onlyCheck) {
                    return;
                }
                this.serializeData();
                this._storage.setEntries(entryIndex, 1, this._tmp);
            } else {
                long position = -(entryIndex + 1L);
                this.checkCanInsert(position);
                if (onlyCheck) {
                    return;
                }
                this.serializeData();
                this._storage.insertEntries(position, 1, this._tmp);
            }
        }
        catch (IOException e) {
            throw new IndexException("Fehler beim Aktualisieren eines Werts", this.getFile(), e);
        }
    }

    private long findExistingItem() throws IOException {
        long insertValue = this._insertLongValues[this._mainIndex.getColumn().getColumnIndex()];
        long startIndex = this._mainIndex.findEntryIndex(insertValue, this._tmp);
        if (startIndex < 0L) {
            return startIndex;
        }
        long endIndex = startIndex;
        if (this._mainIndex.getColumn().getType() == ColumnType.Increasing) {
            while (startIndex > 0L) {
                this._storage.getEntries(startIndex - 1L, 1, this._tmp);
                if (this._mainIndex.getColumn().readLong(this._tmp) != insertValue) break;
                --startIndex;
            }
            while (endIndex < this._storage.numEntries() - 1L) {
                this._storage.getEntries(endIndex + 1L, 1, this._tmp);
                if (this._mainIndex.getColumn().readLong(this._tmp) != insertValue) break;
                ++endIndex;
            }
        }
        for (long i = startIndex; i <= endIndex; ++i) {
            this._storage.getEntries(i, 1, this._tmp);
            for (IndexContentDescriptor.IndexColumn column : this._indexContentDescriptor.getColumns()) {
                if (column.getType() != ColumnType.Unique && column.getType() != ColumnType.StrictlyIncreasing || column.readLong(this._tmp) != this._insertLongValues[column.getColumnIndex()]) continue;
                return i;
            }
        }
        return -endIndex - 2L;
    }

    @Override
    public void append() throws IndexException {
        this.append(false);
    }

    @Override
    public void append(boolean onlyCheck) throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        try {
            this.checkCanInsert(this.numEntries());
            if (onlyCheck) {
                return;
            }
            this.serializeData();
            this._storage.addLast(this._tmp);
        }
        catch (IOException e) {
            throw new IndexException("Fehler beim Anh\u00e4ngen eines Werts", this.getFile(), e);
        }
    }

    private void checkCanInsert(long insertPosition) throws IOException, CorruptIndexException {
        boolean atStart = insertPosition == 0L;
        boolean atEnd = insertPosition == this.numEntries();
        int entryByteSize = this._storage.entryByteSize();
        this.checkInsertValues();
        if (!atStart && !atEnd) {
            byte[] bytes = new byte[entryByteSize * 2];
            this._storage.getEntries(insertPosition - 1L, 2, bytes);
            this.checkIsSmaller(bytes);
            this.checkIsLarger(bytes, entryByteSize);
        } else if (atStart && !atEnd) {
            byte[] bytes = new byte[entryByteSize];
            this._storage.getEntries(insertPosition, 1, bytes);
            this.checkIsLarger(bytes, 0);
        } else if (!atStart) {
            byte[] bytes = new byte[entryByteSize];
            this._storage.getEntries(insertPosition - 1L, 1, bytes);
            this.checkIsSmaller(bytes);
        }
    }

    private void checkCanReplace(long replacePosition) throws IOException, CorruptIndexException {
        boolean atStart = replacePosition == 0L;
        boolean atEnd = replacePosition == this.numEntries() - 1L;
        int entryByteSize = this._storage.entryByteSize();
        this.checkInsertValues();
        if (!atStart && !atEnd) {
            byte[] bytes = new byte[entryByteSize * 3];
            this._storage.getEntries(replacePosition - 1L, 3, bytes);
            this.checkIsSmaller(bytes);
            this.checkIsLarger(bytes, 2 * entryByteSize);
        } else if (atStart && !atEnd) {
            byte[] bytes = new byte[entryByteSize];
            this._storage.getEntries(replacePosition + 1L, 1, bytes);
            this.checkIsLarger(bytes, 0);
        } else if (!atStart) {
            byte[] bytes = new byte[entryByteSize];
            this._storage.getEntries(replacePosition - 1L, 1, bytes);
            this.checkIsSmaller(bytes);
        }
    }

    private void checkInsertValues() throws CorruptIndexException {
        for (IndexContentDescriptor.IndexColumn column : this._indexContentDescriptor.getColumns()) {
            long maxValue;
            long minValue;
            IndexContentDescriptor.IndexColumn minColumn = column.getMinColumn();
            if (minColumn == column || (minValue = this._insertLongValues[minColumn.getColumnIndex()]) <= (maxValue = this._insertLongValues[column.getColumnIndex()])) continue;
            throw new CorruptIndexException("Neuer Wert f\u00fcr " + String.valueOf(column.getData()) + " nicht gr\u00f6\u00dfer als der Wert f\u00fcr " + String.valueOf(minColumn.getData()) + ": [" + minValue + "..." + maxValue + "]", this.getFile());
        }
    }

    private void checkIsSmaller(byte[] bytes) throws CorruptIndexException {
        for (IndexContentDescriptor.IndexColumn column : this._indexContentDescriptor.getColumns()) {
            this.checkIsSmaller(column, bytes);
        }
    }

    private void checkIsLarger(byte[] bytes, int offset) throws CorruptIndexException {
        for (IndexContentDescriptor.IndexColumn column : this._indexContentDescriptor.getColumns()) {
            this.checkIsLarger(column, bytes, offset);
        }
    }

    private void checkIsSmaller(IndexContentDescriptor.IndexColumn column, byte[] bytes) throws CorruptIndexException {
        switch (column.getType()) {
            case StrictlyIncreasing: {
                long prevValue = column.readLong(bytes, 0);
                long insertValue = this._insertLongValues[column.getColumnIndex()];
                if (insertValue > prevValue) break;
                throw new CorruptIndexException("Neuer Wert f\u00fcr " + String.valueOf(column.getData()) + " nicht streng monoton steigend: " + insertValue + " (vorheriger Wert: " + prevValue + ")", this.getFile());
            }
            case Increasing: {
                long prevValue = column.readLong(bytes, 0);
                long insertValue = this._insertLongValues[column.getColumnIndex()];
                if (insertValue >= prevValue) break;
                throw new CorruptIndexException("Neuer Wert f\u00fcr " + String.valueOf(column.getData()) + " nicht monoton steigend: " + insertValue + " (vorheriger Wert: " + prevValue + ")", this.getFile());
            }
            case Unique: {
                long prevValue = column.readLong(bytes, 0);
                long insertValue = this._insertLongValues[column.getColumnIndex()];
                if (insertValue != prevValue) break;
                throw new CorruptIndexException("Neuer Wert f\u00fcr " + String.valueOf(column.getData()) + " nicht eindeutig: " + insertValue + " (vorheriger Wert: " + prevValue + ")", this.getFile());
            }
        }
    }

    private void checkIsLarger(IndexContentDescriptor.IndexColumn column, byte[] bytes, int offset) throws CorruptIndexException {
        switch (column.getType()) {
            case StrictlyIncreasing: {
                long nextValue = column.readLong(bytes, offset);
                long insertValue = this._insertLongValues[column.getColumnIndex()];
                if (insertValue < nextValue) break;
                throw new CorruptIndexException("Neuer Wert f\u00fcr " + String.valueOf(column.getData()) + " nicht streng monoton steigend: " + insertValue + " (nachfolgender Wert: " + nextValue + ")", this.getFile());
            }
            case Increasing: {
                long nextValue = column.readLong(bytes, offset);
                long insertValue = this._insertLongValues[column.getColumnIndex()];
                if (insertValue <= nextValue) break;
                throw new CorruptIndexException("Neuer Wert f\u00fcr " + String.valueOf(column.getData()) + " nicht monoton steigend: " + insertValue + " (nachfolgender Wert: " + nextValue + ")", this.getFile());
            }
            case Unique: {
                long nextValue = column.readLong(bytes, offset);
                long insertValue = this._insertLongValues[column.getColumnIndex()];
                if (insertValue != nextValue) break;
                throw new CorruptIndexException("Neuer Wert f\u00fcr " + String.valueOf(column.getData()) + " nicht eindeutig: " + insertValue + " (nachfolgender Wert: " + nextValue + ")", this.getFile());
            }
        }
    }

    private void serializeData() {
        List<IndexContentDescriptor.IndexColumn> columns = this._indexContentDescriptor.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            IndexContentDescriptor.IndexColumn column = columns.get(i);
            if (column.getType() == ColumnType.String) {
                String value = this._insertStringValues[i];
                column.writeBytes(value, this._tmp);
                continue;
            }
            long value = this._insertLongValues[i];
            column.writeBytes(value, this._tmp);
        }
    }

    @Override
    public long getLast(E column) throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        try {
            if (this._storage.numEntries() == 0L) {
                return -1L;
            }
            this._storage.getLast(this._tmp);
            return this._indexContentDescriptor.getColumn(column).readLong(this._tmp);
        }
        catch (IOException e) {
            throw new CorruptIndexException("Fehler beim Ermitteln des letzten Eintrags", this._storage.getFile(), e);
        }
    }

    @Override
    public long getFirst(E column) throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        try {
            if (this._storage.numEntries() == 0L) {
                return -1L;
            }
            this._storage.getFirst(this._tmp);
            return this._indexContentDescriptor.getColumn(column).readLong(this._tmp);
        }
        catch (IOException e) {
            throw new CorruptIndexException("Fehler beim Ermitteln des ersten Eintrags", this._storage.getFile(), e);
        }
    }

    public HybridStorage getStorage() {
        return this._storage;
    }

    @Override
    public void close() throws IndexException {
        this._closed = true;
        try {
            this._storage.close();
        }
        catch (IOException e) {
            throw new IndexException("Fehler beim Schlie\u00dfen des Indexes", this.getFile(), e);
        }
    }

    @Override
    public void flush() throws IndexException {
        try {
            this._storage.flush();
        }
        catch (IOException e) {
            throw new IndexException("Fehler beim Flushen des Indexes", this.getFile(), e);
        }
    }

    @Override
    public long numEntries() {
        return this.getStorage().numEntries();
    }

    public String toString() {
        return this.getFile().toString();
    }

    @Override
    public Path getFile() {
        return this._storage.getFile();
    }

    @Override
    public void removeAll(Map<E, LongRange> query) throws IndexException {
        if (this._closed) {
            throw new IllegalStateException();
        }
        if (this._storage.numEntries() == 0L) {
            return;
        }
        try {
            LongRange range = this.indexQuery(query);
            if (range == null) {
                return;
            }
            long lowerEndpoint = range.lowerEndpoint();
            long upperEndpoint = range.upperEndpoint();
            byte[] data = new byte[this._indexContentDescriptor.getEntryLengthBytes()];
            for (long indexIdx = lowerEndpoint; indexIdx <= upperEndpoint; ++indexIdx) {
                this._storage.getEntries(indexIdx, 1, data);
                if (!this.isDirectMatch(data, query)) continue;
                this._storage.deleteEntryAtIndex(indexIdx);
                --indexIdx;
                --upperEndpoint;
            }
        }
        catch (IOException e) {
            throw new IndexException("Fehler beim L\u00f6schen aus Index", this._storage.getFile(), e);
        }
    }

    @Nullable
    private LongRange indexQuery(Map<E, LongRange> query) throws IOException {
        LongRange range = new LongRange(0L, this._storage.numEntries() - 1L);
        for (IndexImplementation indexImplementation : this._indexes.values()) {
            LongRange inputRange = query.get(indexImplementation.getColumn().getData());
            if (inputRange == null) continue;
            LongRange queryResult = indexImplementation.query(inputRange);
            if (queryResult == null) {
                range = null;
                break;
            }
            if ((range = range.intersection(queryResult)) != null) continue;
            break;
        }
        return range;
    }

    private class StrictlyIncreasingIndex
    implements IndexImplementation {
        private final IndexContentDescriptor.IndexColumn _column;

        public StrictlyIncreasingIndex(IndexContentDescriptor.IndexColumn column) {
            this._column = column;
        }

        @Override
        @Nullable
        public LongRange query(LongRange inputRange) throws IOException {
            Long lowerBound = null;
            Long upperBound = null;
            byte[] tmp = new byte[AbstractIndex.this._storage.entryByteSize()];
            if (inputRange.hasLowerBound()) {
                lowerBound = this.findEntryIndexOrPreviousLowest(inputRange.lowerEndpoint(), tmp);
            }
            if (inputRange.hasUpperBound() && (upperBound = Long.valueOf(this.findEntryIndexOrPreviousHighest(inputRange.upperEndpoint(), tmp))) == -1L) {
                return null;
            }
            return new LongRange(lowerBound, upperBound);
        }

        public long findEntryIndexOrPreviousLowest(long searchValue, byte[] tmp) throws IOException {
            long index = this.findEntryIndex(searchValue, tmp);
            if (index < 0L) {
                index = -(index + 2L);
            }
            return index;
        }

        public long findEntryIndexOrPreviousHighest(long searchValue, byte[] tmp) throws IOException {
            long index = this.findEntryIndex(searchValue, tmp);
            if (index < 0L) {
                index = -(index + 2L);
            }
            return index;
        }

        @Override
        public long findEntryIndex(long searchValue, byte[] tmp) throws IOException {
            long low;
            long high = AbstractIndex.this._storage.numEntries() - 1L;
            long firstMemoryIndex = AbstractIndex.this._storage.firstMemoryIndex();
            if (firstMemoryIndex <= high && this.getValue(firstMemoryIndex, tmp) < searchValue) {
                low = firstMemoryIndex;
            } else {
                low = 0L;
                if (AbstractIndex.this._storage.numEntries() == 0L || searchValue < this.getValue(low, tmp)) {
                    return -1L;
                }
            }
            long highValue = this.getValue(high, tmp);
            if (searchValue > highValue) {
                return -(AbstractIndex.this._storage.numEntries() + 1L);
            }
            return this.binarySearch(low, high, searchValue, tmp);
        }

        @Override
        public IndexContentDescriptor.IndexColumn getColumn() {
            return this._column;
        }

        private long binarySearch(long low, long high, long searchValue, byte[] tmp) throws IOException {
            while (low <= high) {
                long mid = low + (high - low) / 2L;
                long midValue = this.getValue(mid, tmp);
                if (midValue < searchValue) {
                    low = mid + 1L;
                    continue;
                }
                if (midValue > searchValue) {
                    high = mid - 1L;
                    continue;
                }
                return mid;
            }
            return -(low + 1L);
        }

        public long getValue(long index, byte[] tmp) throws IOException {
            AbstractIndex.this._storage.getEntries(index, 1, tmp);
            return this._column.readLong(tmp);
        }
    }

    private class IncreasingIndex
    extends StrictlyIncreasingIndex {
        public IncreasingIndex(IndexContentDescriptor.IndexColumn column) {
            super(column);
        }

        @Override
        public long findEntryIndexOrPreviousLowest(long searchValue, byte[] tmp) throws IOException {
            long indexLowest;
            for (indexLowest = super.findEntryIndexOrPreviousLowest(searchValue, tmp); indexLowest > 0L && this.getValue(indexLowest - 1L, tmp) == searchValue; --indexLowest) {
            }
            return indexLowest;
        }

        @Override
        public long findEntryIndexOrPreviousHighest(long searchValue, byte[] tmp) throws IOException {
            long indexHighest;
            for (indexHighest = super.findEntryIndexOrPreviousHighest(searchValue, tmp); indexHighest < AbstractIndex.this._storage.numEntries() - 1L && this.getValue(indexHighest + 1L, tmp) == searchValue; ++indexHighest) {
            }
            return indexHighest;
        }
    }
}

