/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.backend.storage;

import de.bsvrz.ars.ars.persistence.index.backend.storage.FileIndexStorage;
import de.bsvrz.ars.ars.persistence.index.backend.storage.IndexStorage;
import java.io.IOException;

public class BufferedIndexStorage
implements IndexStorage,
AutoCloseable {
    private final FileIndexStorage _delegate;
    private final byte[] _cache;
    private final int _cacheSize;
    private long _cacheIndex = -1L;
    private int _bufferedCount;

    public BufferedIndexStorage(FileIndexStorage delegate, int cacheSize) {
        this._delegate = delegate;
        this._cacheSize = cacheSize;
        this._cache = new byte[this._cacheSize * delegate.entryByteSize()];
    }

    @Override
    public void getEntries(long entryIndex, int numEntries, byte[] result, int destPos) throws IOException {
        if (numEntries > this._cacheSize) {
            this._delegate.getEntries(entryIndex, numEntries, result, destPos);
            return;
        }
        this.cacheValues(entryIndex, numEntries);
        System.arraycopy(this._cache, (int)(entryIndex - this._cacheIndex) * this.entryByteSize(), result, destPos, numEntries * this.entryByteSize());
    }

    private void cacheValues(long entryIndex, int numEntries) throws IOException {
        if (!this.isCached(entryIndex, numEntries)) {
            int size = (int)Math.min((long)this._cacheSize, this.numEntries());
            if (size == 0) {
                throw new IOException("Ung\u00fcltiger Index: " + entryIndex);
            }
            this._bufferedCount = size;
            this._cacheIndex = Math.min(entryIndex, this.numEntries() - (long)size);
            this._delegate.getEntries(this._cacheIndex, size, this._cache, 0);
        }
    }

    private boolean isCached(long entryIndex, int numEntries) {
        return this._cacheIndex >= 0L && entryIndex >= this._cacheIndex && entryIndex + (long)numEntries <= this._cacheIndex + (long)this._cacheSize;
    }

    private void eraseCache() {
        this._cacheIndex = -1L;
        this._bufferedCount = 0;
    }

    @Override
    public void setEntries(long entryIndex, int numEntries, byte[] data, int fromPos) throws IOException {
        this._delegate.setEntries(entryIndex, numEntries, data, fromPos);
        this.eraseCache();
    }

    @Override
    public void insertEntries(long entryIndex, int numEntries, byte[] data, int fromPos) throws IOException {
        this._delegate.insertEntries(entryIndex, numEntries, data, fromPos);
        this.eraseCache();
    }

    @Override
    public long numEntries() throws IOException {
        return this._delegate.numEntries();
    }

    @Override
    public int entryByteSize() {
        return this._delegate.entryByteSize();
    }

    @Override
    public void deleteEntryAtIndex(long entryIndex) throws IOException {
        this._delegate.deleteEntryAtIndex(entryIndex);
        this.eraseCache();
    }

    public void flush() throws IOException {
        this._delegate.flush();
    }

    public String toString() {
        return this._delegate.toString();
    }

    @Override
    public void close() throws IOException {
        this._delegate.close();
        this.eraseCache();
    }

    public int getBufferedCount() {
        return this._bufferedCount;
    }
}

