/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.backend.storage;

import java.io.IOException;

public interface IndexStorage {
    default public void getFirst(byte[] result) throws IOException {
        this.getEntries(0L, 1, result, 0);
    }

    default public void getLast(byte[] result) throws IOException {
        this.getEntries(this.numEntries() - 1L, 1, result, 0);
    }

    public void getEntries(long var1, int var3, byte[] var4, int var5) throws IOException;

    default public void getEntries(long entryIndex, int numEntries, byte[] result) throws IOException {
        this.getEntries(entryIndex, numEntries, result, 0);
    }

    public void setEntries(long var1, int var3, byte[] var4, int var5) throws IOException;

    default public void setEntries(long entryIndex, int numEntries, byte[] data) throws IOException {
        this.setEntries(entryIndex, numEntries, data, 0);
    }

    default public void insertEntries(long entryIndex, int numEntries, byte[] data) throws IOException {
        this.insertEntries(entryIndex, numEntries, data, 0);
    }

    public void insertEntries(long var1, int var3, byte[] var4, int var5) throws IOException;

    public long numEntries() throws IOException;

    public int entryByteSize();

    default public void addLast(byte[] data, int numEntries) throws IOException {
        this.insertEntries(this.numEntries(), numEntries, data);
    }

    default public void addLast(byte[] data) throws IOException {
        this.addLast(data, 1);
    }

    default public byte[] getAll() throws IOException {
        byte[] result = new byte[Math.toIntExact((long)this.entryByteSize() * this.numEntries())];
        this.getEntries(0L, Math.toIntExact(this.numEntries()), result);
        return result;
    }

    public void deleteEntryAtIndex(long var1) throws IOException;
}

