/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.result;

import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.index.result.LocatedIndexResult;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class AggregateIndexResult<E extends Enum<E>>
implements LocatedIndexResult<E> {
    private int size;
    private final NavigableMap<Integer, LocatedIndexResult<E>> _indexesByStartIndex = new TreeMap<Integer, LocatedIndexResult<E>>();

    public void add(IndexResult<E> indexResult, PersistenceDirectory dir) {
        if (indexResult.isEmpty() && !this._indexesByStartIndex.isEmpty() && this._indexesByStartIndex.lastEntry().getValue().hasNext()) {
            return;
        }
        this._indexesByStartIndex.put(this.size, LocatedIndexResult.adapt(indexResult, dir));
        this.size += indexResult.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long get(int index, E value) {
        Map.Entry<Integer, LocatedIndexResult<E>> entry = this._indexesByStartIndex.floorEntry(index);
        return entry.getValue().get(index - entry.getKey(), value);
    }

    @Override
    public int getSignedInt(int index, E value) {
        Map.Entry<Integer, LocatedIndexResult<E>> entry = this._indexesByStartIndex.floorEntry(index);
        return entry.getValue().getSignedInt(index - entry.getKey(), value);
    }

    @Override
    public String getString(int index, E value) {
        Map.Entry<Integer, LocatedIndexResult<E>> entry = this._indexesByStartIndex.floorEntry(index);
        return entry.getValue().getString(index - entry.getKey(), value);
    }

    @Override
    public boolean getBoolean(int index, E value) {
        Map.Entry<Integer, LocatedIndexResult<E>> entry = this._indexesByStartIndex.floorEntry(index);
        return entry.getValue().getBoolean(index - entry.getKey(), value);
    }

    @Override
    public boolean hasNext() {
        return !this._indexesByStartIndex.isEmpty() && this._indexesByStartIndex.lastEntry().getValue().hasNext();
    }

    @Override
    public long getNext(E value) {
        return this._indexesByStartIndex.lastEntry().getValue().getNext(value);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long getMin(E value) {
        return this._indexesByStartIndex.values().stream().filter(it -> !it.isEmpty()).mapToLong(it -> it.getMin(value)).min().orElseThrow(IllegalStateException::new);
    }

    @Override
    public long getMax(E value) {
        return this._indexesByStartIndex.values().stream().filter(it -> !it.isEmpty()).mapToLong(it -> it.getMax(value)).max().orElseThrow(IllegalStateException::new);
    }

    @Override
    public List<IndexContentDescriptor.IndexColumn> getColumns() {
        if (this._indexesByStartIndex.isEmpty()) {
            return List.of();
        }
        return this._indexesByStartIndex.firstEntry().getValue().getColumns();
    }

    @Override
    public String toString() {
        return "AggregateIndexResult[" + this.size() + "]";
    }

    @Override
    public PersistenceDirectory getPersistenceDirectory(int index) {
        Map.Entry<Integer, LocatedIndexResult<E>> entry = this._indexesByStartIndex.floorEntry(index);
        return entry.getValue().getPersistenceDirectory(index - entry.getKey());
    }

    @Override
    public PersistenceDirectory getNextPersistenceDirectory() {
        return this._indexesByStartIndex.lastEntry().getValue().getNextPersistenceDirectory();
    }
}

