/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.iter;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.DataSequence;
import de.bsvrz.dav.daf.main.archive.ArchiveOrder;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;

public class CombineDataIterator
implements DataIterator {
    @Nullable
    private DataIterator _currentDelegate;
    final List<DataIterator> _iterators;
    private final ArchiveOrder _order;
    private boolean _closed;

    public CombineDataIterator(Collection<DataSequence> containerSequences, ArchiveOrder order) throws PersistenceException, SynchronizationFailedException {
        this._order = order;
        ArrayList<DataIterator> iterators = new ArrayList<DataIterator>(containerSequences.size());
        for (DataSequence sequence : containerSequences) {
            DataIterator iterator = sequence.iterator();
            iterators.add(iterator);
        }
        this._iterators = iterators;
        this.updateDelegate();
    }

    CombineDataIterator(List<DataIterator> iterators, ArchiveOrder order) {
        this._iterators = iterators;
        this._order = order;
        this.updateDelegate();
    }

    @Override
    public void peek(ContainerDataResult result) throws PersistenceException {
        if (this._currentDelegate == null) {
            throw new NoSuchElementException();
        }
        this._currentDelegate.peek(result);
    }

    @Override
    public long peekDataIndex() {
        if (this._currentDelegate == null) {
            throw new NoSuchElementException();
        }
        return this._currentDelegate.peekDataIndex();
    }

    @Override
    public long peekDataTime() {
        if (this._currentDelegate == null) {
            throw new NoSuchElementException();
        }
        return this._currentDelegate.peekDataTime();
    }

    @Override
    public long peekArchiveTime() {
        if (this._currentDelegate == null) {
            throw new NoSuchElementException();
        }
        return this._currentDelegate.peekArchiveTime();
    }

    @Override
    public void remove() throws PersistenceException, SynchronizationFailedException {
        if (this._closed) {
            throw new IllegalStateException("closed == true");
        }
        if (this._currentDelegate == null) {
            throw new NoSuchElementException();
        }
        this._currentDelegate.remove();
        this.updateDelegate();
    }

    protected final void updateDelegate() {
        this._currentDelegate = this._order == ArchiveOrder.BY_INDEX ? (DataIterator)this._iterators.stream().filter(it -> !it.isEmpty()).min(Comparator.comparing(DataIterator::peekDataIndex)).orElse(null) : (DataIterator)this._iterators.stream().filter(it -> !it.isEmpty()).min(Comparator.comparing(DataIterator::peekDataTime).thenComparing(DataIterator::peekDataIndex)).orElse(null);
    }

    @Override
    public boolean isEmpty() {
        return this._currentDelegate == null;
    }

    @Override
    public ContainerDataResult peekNext() throws PersistenceException, SynchronizationFailedException {
        if (!this.isEmpty()) {
            throw new IllegalStateException();
        }
        ArrayList<ContainerDataResult> results = new ArrayList<ContainerDataResult>();
        for (DataIterator iterator : this._iterators) {
            ContainerDataResult next = iterator.peekNext();
            if (next == null) continue;
            results.add(next);
        }
        if (results.isEmpty()) {
            return null;
        }
        if (this._order == ArchiveOrder.BY_INDEX) {
            return Collections.min(results, Comparator.comparing(ContainerDataResult::getDataIndex));
        }
        return Collections.min(results, Comparator.comparing(ContainerDataResult::getDataTime));
    }

    @Override
    public void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        for (DataIterator iterator : this._iterators) {
            iterator.close();
        }
    }

    @Override
    @NotNull
    public ContainerManagementData getContainerManagementData() throws PersistenceException {
        if (this._currentDelegate == null) {
            throw new NoSuchElementException();
        }
        return this._currentDelegate.getContainerManagementData();
    }

    public ArchiveOrder getOrder() {
        return this._order;
    }
}

