/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.iter;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.iter.DataGapManager;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.QueryDataSequence;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.util.List;

public class SequentialContainerIterator
implements DataIterator {
    private final List<QueryDataSequence.IndexedContainer> _containerFiles;
    private DataIterator _dataIterator;
    private int _index;
    private final ArchiveDataKind _adk;
    private final QueryDataSequence.IndexedContainer _nextContainer;
    private final IdDataIdentification _idDataIdentification;
    private ContainerDataResult insertGapDataset = null;
    private final DataGapManager gapManager;

    public SequentialContainerIterator(List<QueryDataSequence.IndexedContainer> containerFiles, ArchiveDataKind adk, @Nullable QueryDataSequence.IndexedContainer nextContainer, IdDataIdentification idDataIdentification, DataGapManager gapManager) throws PersistenceException {
        this.gapManager = gapManager;
        if (containerFiles.isEmpty()) {
            throw new IllegalArgumentException("containerFiles");
        }
        this._adk = adk;
        this._nextContainer = nextContainer;
        this._containerFiles = containerFiles;
        this._idDataIdentification = idDataIdentification;
        this.openContainer(this._index);
    }

    private void openContainer(int index) throws PersistenceException {
        QueryDataSequence.IndexedContainer container = this._containerFiles.get(index);
        this._dataIterator = this.getIterator(container);
    }

    @Override
    public void peek(ContainerDataResult result) throws PersistenceException {
        if (this.insertGapDataset != null) {
            this.insertGapDataset.copyTo(result);
            return;
        }
        this._dataIterator.peek(result);
    }

    @Override
    public ContainerDataResult peekNext() throws PersistenceException, SynchronizationFailedException {
        if (!this.isEmpty()) {
            throw new IllegalStateException();
        }
        ContainerDataResult peekNext = this._dataIterator.peekNext();
        if (peekNext == null && this._nextContainer != null) {
            try (DataIterator iterator = this.getIterator(this._nextContainer);){
                ContainerDataResult result = new ContainerDataResult();
                iterator.poll(result);
                ContainerDataResult containerDataResult = result;
                return containerDataResult;
            }
        }
        return peekNext;
    }

    private DataIterator getIterator(QueryDataSequence.IndexedContainer nextContainer) throws PersistenceException {
        return nextContainer.getDirectory().iterator(this._adk, nextContainer.getContainerId(), this._idDataIdentification);
    }

    @Override
    public long peekDataIndex() {
        if (this.insertGapDataset != null) {
            return this.insertGapDataset.getDataIndex();
        }
        return this._dataIterator.peekDataIndex();
    }

    @Override
    public long peekDataTime() {
        if (this.insertGapDataset != null) {
            return this.insertGapDataset.getDataTime();
        }
        return this._dataIterator.peekDataTime();
    }

    @Override
    public long peekArchiveTime() {
        if (this.insertGapDataset != null) {
            return this.insertGapDataset.getArchiveTime();
        }
        return this._dataIterator.peekArchiveTime();
    }

    @Override
    public void remove() throws PersistenceException, SynchronizationFailedException {
        if (this.insertGapDataset != null) {
            this.insertGapDataset = null;
            return;
        }
        long oldArchiveTime = this.peekArchiveTime();
        long oldDataTime = this.peekDataTime();
        long oldDataIndex = this.peekDataIndex();
        this._dataIterator.remove();
        while (this._dataIterator.isEmpty() && this._index < this._containerFiles.size() - 1) {
            long gapIndex;
            this._dataIterator.close();
            ++this._index;
            this.openContainer(this._index);
            long newDataIndex = this.peekDataIndex();
            long newArchiveTime = this.peekArchiveTime();
            if (!ArchiveTask.isIndexGap(oldDataIndex, newDataIndex) || !this.gapManager.isRangeUnavailable(oldArchiveTime, newArchiveTime) || (gapIndex = Util.dIdxSetArSBit((long)oldDataIndex)) <= oldDataIndex) continue;
            this.insertGapDataset = new ContainerDataResult();
            this.insertGapDataset.setArchiveTime(oldArchiveTime);
            this.insertGapDataset.setDataIndex(gapIndex);
            this.insertGapDataset.setDataTime(oldDataTime);
            this.insertGapDataset.setDataState(DataState.UNAVAILABLE_BLOCK);
            this.insertGapDataset.setDataKind(this._adk);
        }
    }

    @Override
    public boolean isEmpty() {
        return this._dataIterator.isEmpty();
    }

    @Override
    public void close() {
        this._dataIterator.close();
    }

    @Override
    @NotNull
    public ContainerManagementData getContainerManagementData() throws PersistenceException {
        return this._dataIterator.getContainerManagementData();
    }
}

