/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.iter;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.SimpleContainerManagementData;
import de.bsvrz.ars.ars.persistence.iter.CombineDataIterator;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.DataSequence;
import de.bsvrz.dav.daf.main.archive.ArchiveOrder;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;

public class TimeSpecificationCombineDataIterator
extends CombineDataIterator {
    private final ArchiveTimeSpecification _timeSpecification;
    private ContainerDataResult _last;
    private FirstDataSet _firstData;

    public TimeSpecificationCombineDataIterator(Collection<DataSequence> containerSequences, ArchiveOrder order, ArchiveTimeSpecification timeSpecification) throws PersistenceException, SynchronizationFailedException {
        super(containerSequences, order);
        this._timeSpecification = timeSpecification;
        ArrayList<FirstDataSet> firstDataCandidates = new ArrayList<FirstDataSet>();
        for (DataIterator iterator : this._iterators) {
            this.initIterator(iterator, firstDataCandidates);
        }
        super.updateDelegate();
        if (firstDataCandidates.contains(null)) {
            this._firstData = null;
            return;
        }
        this.eliminateIllegalCandidates(firstDataCandidates);
        if (firstDataCandidates.isEmpty()) {
            this._firstData = null;
            return;
        }
        if (timeSpecification.getTimingType() == TimingType.DATA_INDEX) {
            this._firstData = Collections.max(firstDataCandidates, Comparator.comparing(it -> it.getData().getDataIndex()));
        } else if (timeSpecification.getTimingType() == TimingType.DATA_TIME) {
            this._firstData = Collections.max(firstDataCandidates, Comparator.comparing(it -> it.getData().getDataTime()));
        } else if (timeSpecification.getTimingType() == TimingType.ARCHIVE_TIME) {
            this._firstData = Collections.max(firstDataCandidates, Comparator.comparing(it -> it.getData().getArchiveTime()));
        }
    }

    private void eliminateIllegalCandidates(List<FirstDataSet> firstDataCandidates) {
        if (this.isEmpty()) {
            return;
        }
        if (this.getOrder() == ArchiveOrder.BY_INDEX) {
            firstDataCandidates.removeIf(it -> it.getData().getDataIndex() > this.peekDataIndex());
        } else {
            firstDataCandidates.removeIf(it -> it.getData().getDataTime() > this.peekDataTime());
        }
    }

    private void initIterator(DataIterator iterator, List<FirstDataSet> firstDataCandidates) throws PersistenceException, SynchronizationFailedException {
        if (iterator.isEmpty()) {
            return;
        }
        if (this.exceedsUpperBound(iterator)) {
            this.removeIfInvalid(iterator);
            return;
        }
        if (this.exceedsLowerBound(iterator)) {
            SimpleContainerManagementData firstContainerManagementData;
            ContainerDataResult firstData = new ContainerDataResult();
            do {
                iterator.peek(firstData);
                firstContainerManagementData = new SimpleContainerManagementData(iterator.getContainerManagementData());
                iterator.remove();
                if (!iterator.isEmpty()) continue;
                firstDataCandidates.add(new FirstDataSet(firstData, firstContainerManagementData));
                return;
            } while (this.exceedsLowerBound(iterator));
            if (this.isAtStart(iterator)) {
                firstDataCandidates.add(null);
            } else {
                firstDataCandidates.add(new FirstDataSet(firstData, firstContainerManagementData));
            }
            return;
        }
        if (this.isAtStart(iterator)) {
            firstDataCandidates.add(null);
        }
    }

    private void removeIfInvalid(DataIterator iterator) throws PersistenceException, SynchronizationFailedException {
        if (iterator.isEmpty()) {
            return;
        }
        if (this.exceedsUpperBound(iterator)) {
            this._last = new ContainerDataResult();
            iterator.poll(this._last);
        }
        if (iterator.isEmpty()) {
            return;
        }
        while (this.exceedsUpperBound(iterator)) {
            iterator.remove();
            if (!iterator.isEmpty()) continue;
            return;
        }
    }

    private void removeIfInvalid() throws PersistenceException, SynchronizationFailedException {
        if (super.isEmpty()) {
            return;
        }
        if (this.exceedsUpperBound(this)) {
            this._last = new ContainerDataResult();
            super.peek(this._last);
            super.remove();
            if (super.isEmpty()) {
                return;
            }
            while (this.exceedsUpperBound(this)) {
                super.remove();
                if (!super.isEmpty()) continue;
                return;
            }
        }
    }

    @Override
    public ContainerDataResult peekNext() throws PersistenceException, SynchronizationFailedException {
        if (!this.isEmpty()) {
            throw new IllegalStateException();
        }
        return this._last != null ? this._last : super.peekNext();
    }

    private boolean exceedsLowerBound(DataIterator iterator) {
        if (this._timeSpecification.getTimingType() == TimingType.DATA_INDEX) {
            long dataIndex = iterator.peekDataIndex();
            return dataIndex < this._timeSpecification.getIntervalStart();
        }
        if (this._timeSpecification.getTimingType() == TimingType.DATA_TIME) {
            long dataTime = iterator.peekDataTime();
            return dataTime < this._timeSpecification.getIntervalStart();
        }
        if (this._timeSpecification.getTimingType() == TimingType.ARCHIVE_TIME) {
            long archiveTime = iterator.peekArchiveTime();
            return archiveTime < this._timeSpecification.getIntervalStart();
        }
        throw new AssertionError((Object)("Unbekannter TimingType: " + String.valueOf(this._timeSpecification.getTimingType())));
    }

    private boolean exceedsUpperBound(DataIterator iterator) {
        if (this._timeSpecification.getTimingType() == TimingType.DATA_INDEX) {
            long dataIndex = iterator.peekDataIndex();
            return dataIndex > this._timeSpecification.getIntervalEnd();
        }
        if (this._timeSpecification.getTimingType() == TimingType.DATA_TIME) {
            long dataTime = iterator.peekDataTime();
            if (dataTime == 0L) {
                return false;
            }
            return dataTime > this._timeSpecification.getIntervalEnd();
        }
        if (this._timeSpecification.getTimingType() == TimingType.ARCHIVE_TIME) {
            long archiveTime = iterator.peekArchiveTime();
            if (archiveTime == 0L) {
                return false;
            }
            return archiveTime > this._timeSpecification.getIntervalEnd();
        }
        throw new AssertionError((Object)("Unbekannter TimingType: " + String.valueOf(this._timeSpecification.getTimingType())));
    }

    private boolean isAtStart(DataIterator iterator) {
        if (this._timeSpecification.getTimingType() == TimingType.DATA_INDEX) {
            long dataIndex = iterator.peekDataIndex();
            return dataIndex == this._timeSpecification.getIntervalStart();
        }
        if (this._timeSpecification.getTimingType() == TimingType.DATA_TIME) {
            long dataTime = iterator.peekDataTime();
            return dataTime == this._timeSpecification.getIntervalStart();
        }
        if (this._timeSpecification.getTimingType() == TimingType.ARCHIVE_TIME) {
            long archiveTime = iterator.peekArchiveTime();
            return archiveTime == this._timeSpecification.getIntervalStart();
        }
        throw new AssertionError((Object)("Unbekannter TimingType: " + String.valueOf(this._timeSpecification.getTimingType())));
    }

    @Override
    public void peek(ContainerDataResult result) throws PersistenceException {
        if (this._firstData != null) {
            this._firstData.getData().copyTo(result);
            return;
        }
        super.peek(result);
    }

    @Override
    public long peekDataIndex() {
        if (this._firstData != null) {
            return this._firstData.getData().getDataIndex();
        }
        return super.peekDataIndex();
    }

    @Override
    public long peekDataTime() {
        if (this._firstData != null) {
            return this._firstData.getData().getDataTime();
        }
        return super.peekDataTime();
    }

    @Override
    public long peekArchiveTime() {
        if (this._firstData != null) {
            return this._firstData.getData().getArchiveTime();
        }
        return super.peekArchiveTime();
    }

    @Override
    public void remove() throws PersistenceException, SynchronizationFailedException {
        if (this._firstData != null) {
            this._firstData = null;
            if (!super.isEmpty()) {
                this.removeIfInvalid();
            }
            return;
        }
        super.remove();
        this.removeIfInvalid();
    }

    @Override
    public boolean isEmpty() {
        return this._firstData == null && super.isEmpty();
    }

    @Override
    @NotNull
    public ContainerManagementData getContainerManagementData() throws PersistenceException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this._firstData != null) {
            return this._firstData.getFirstContainerManagementData();
        }
        return super.getContainerManagementData();
    }

    private static class FirstDataSet {
        private final ContainerDataResult _data;
        private final SimpleContainerManagementData _firstContainerManagementData;

        public FirstDataSet(ContainerDataResult data, SimpleContainerManagementData firstContainerManagementData) {
            this._data = data;
            this._firstContainerManagementData = firstContainerManagementData;
        }

        public ContainerDataResult getData() {
            return this._data;
        }

        public SimpleContainerManagementData getFirstContainerManagementData() {
            return this._firstContainerManagementData;
        }
    }
}

