/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.layout;

import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.layout.PathType;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassicPersistenceDirectoryLayout
implements PersistenceDirectoryLayout {
    private static final String OBJ_ID_PREFIX = "obj";
    private static final String ATG_ID_PREFIX = "atg";
    private static final String ASP_ID_PREFIX = "asp";
    private static final String SV_PREFIX = "sv";
    public static final Pattern OBJ_DIRNAME_PAT = Pattern.compile("^obj(\\d+)$");
    private static final Pattern ATG_DIRNAME_PAT = Pattern.compile("^atg(\\d+)$");
    private static final Pattern ASP_DIRNAME_PAT = Pattern.compile("^asp(\\d+)$");
    private static final Pattern SV_DIRNAME_PAT = Pattern.compile("^sv(\\d+)$");
    private static final Pattern NUM_DIR_PAT = Pattern.compile("^\\w+?(\\d+)$");
    public static final ClassicPersistenceDirectoryLayout Instance = new ClassicPersistenceDirectoryLayout();

    private ClassicPersistenceDirectoryLayout() {
    }

    @Override
    public Path getPath(Path basePath, long objId, long atgId, long aspId) {
        Path tmp = basePath;
        tmp = this.appendIdElements(tmp, OBJ_ID_PREFIX, objId);
        tmp = this.appendIdElements(tmp, ATG_ID_PREFIX, atgId);
        tmp = this.appendIdElements(tmp, ASP_ID_PREFIX, aspId);
        return tmp.resolve("sv0");
    }

    public Path appendIdElements(Path basePath, String prefix, long id) {
        Path tmp = basePath;
        String idString = Long.toString(id);
        int end = idString.length();
        int start = 0;
        StringBuilder substringBuilder = new StringBuilder(prefix.length() + 3);
        substringBuilder.append(prefix);
        while (start < end) {
            int newStart = start + 3;
            if (newStart > end) {
                newStart = end;
            }
            substringBuilder.setLength(prefix.length());
            substringBuilder.append(idString, start, newStart);
            tmp = tmp.resolve(substringBuilder.toString());
            start = newStart;
        }
        return tmp;
    }

    private boolean isValidObjIdFolderName(String dirName) {
        return OBJ_DIRNAME_PAT.matcher(dirName).matches();
    }

    private boolean isValidAtgIdFolderName(String dirName) {
        return ATG_DIRNAME_PAT.matcher(dirName).matches();
    }

    private boolean isValidAspIdFolderName(String dirName) {
        return ASP_DIRNAME_PAT.matcher(dirName).matches();
    }

    public boolean isValidSvFolderName(String dirName) {
        return SV_DIRNAME_PAT.matcher(dirName).matches();
    }

    private String getIDPart(String dirName) {
        Matcher m = NUM_DIR_PAT.matcher(dirName);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalArgumentException(dirName);
    }

    @Override
    public int getMaxDepth() {
        return 22;
    }

    @Override
    public PathType identifyPath(List<String> pathStack) {
        int state = 0;
        int numObj = 0;
        int numAtg = 0;
        int numAsp = 0;
        int numSv = 0;
        for (String s : pathStack) {
            if (state == 0) {
                if (this.isValidObjIdFolderName(s)) {
                    ++numObj;
                    continue;
                }
                ++state;
            }
            if (state == 1) {
                if (this.isValidAtgIdFolderName(s)) {
                    ++numAtg;
                    continue;
                }
                ++state;
            }
            if (state == 2) {
                if (this.isValidAspIdFolderName(s)) {
                    ++numAsp;
                    continue;
                }
                ++state;
            }
            if (numSv == 0 && this.isValidSvFolderName(s)) {
                ++numSv;
                continue;
            }
            return PathType.ForeignPath;
        }
        if (numSv == 0) {
            return PathType.PartialIdPath;
        }
        if (numObj == 0 || numAtg == 0 || numAsp == 0) {
            return PathType.ForeignPath;
        }
        return this.getDataIdentificationFromPath(pathStack, 0) != null ? PathType.CompleteIdPath : PathType.ForeignPath;
    }

    @Override
    public IdDataIdentification getDataIdentificationFromPath(List<String> pathStack, int simulationVariant) {
        try {
            ArrayDeque<String> tmp = new ArrayDeque<String>(pathStack);
            String fileName = tmp.pollLast();
            if (!this.isValidSvFolderName(fileName)) {
                return null;
            }
            int sv = Integer.parseInt(this.getIDPart(fileName));
            fileName = tmp.pollLast();
            StringBuilder aspString = new StringBuilder();
            StringBuilder atgString = new StringBuilder();
            StringBuilder objString = new StringBuilder();
            do {
                if (fileName == null) {
                    return null;
                }
                if (!this.isValidAspIdFolderName(fileName)) break;
                aspString.insert(0, this.getIDPart(fileName));
            } while ((fileName = tmp.pollLast()) != null);
            do {
                if (fileName == null) {
                    return null;
                }
                if (!this.isValidAtgIdFolderName(fileName)) break;
                atgString.insert(0, this.getIDPart(fileName));
            } while ((fileName = tmp.pollLast()) != null);
            do {
                if (fileName == null) {
                    return null;
                }
                if (!this.isValidObjIdFolderName(fileName)) break;
                objString.insert(0, this.getIDPart(fileName));
            } while ((fileName = tmp.pollLast()) != null);
            return new IdDataIdentification(Long.parseLong(objString.toString()), Long.parseLong(atgString.toString()), Long.parseLong(aspString.toString()), sv);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static PersistenceDirectoryLayoutInstance instance(Path basePath, int simulationVariant) {
        return Instance.createInstance(basePath, simulationVariant);
    }
}

