/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.layout;

import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class DataKinds {
    private DataKinds() {
    }

    public static ArchiveDataKindCombination getAvailableDataKinds(Path dataIdentificationDir) throws PersistenceException {
        ArchiveDataKindCombination archiveDataKindCombination;
        block10: {
            DirectoryStream<Path> paths = Files.newDirectoryStream(dataIdentificationDir);
            try {
                ArrayList<ArchiveDataKind> dataKindList = new ArrayList<ArchiveDataKind>();
                for (Path path : paths) {
                    if (!DataKinds.isValidDataKindSuffix(path.getFileName().toString())) continue;
                    dataKindList.add(DataKinds.getArchiveDataKind(path));
                }
                archiveDataKindCombination = new ArchiveDataKindCombination(dataKindList);
                if (paths == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return new ArchiveDataKindCombination(List.of());
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            paths.close();
        }
        return archiveDataKindCombination;
    }

    public static boolean isValidDataKindSuffix(String dirName) {
        return switch (dirName) {
            case "oa", "on", "na", "nn" -> true;
            default -> false;
        };
    }

    public static ArchiveDataKind getArchiveDataKind(Path path) {
        ArchiveDataKind kind = DataKinds.getArchiveDataKindOptional(path);
        if (kind == null) {
            throw new IllegalArgumentException("Ung\u00fcltiges Verzeichnis: " + String.valueOf(path));
        }
        return kind;
    }

    public static ArchiveDataKind getArchiveDataKindOptional(Path path) {
        String dirName;
        return switch (dirName = path.getFileName().toString()) {
            case "oa" -> ArchiveDataKind.ONLINE;
            case "on" -> ArchiveDataKind.ONLINE_DELAYED;
            case "na" -> ArchiveDataKind.REQUESTED;
            case "nn" -> ArchiveDataKind.REQUESTED_DELAYED;
            default -> null;
        };
    }

    public static String getDataKindSuffix(ArchiveDataKind adk) {
        return DataKinds.getDataKindSuffix(Util.getDataKindIndex((ArchiveDataKind)adk));
    }

    public static String getDataKindSuffix(int adkIdx) {
        return switch (adkIdx) {
            case 0 -> "oa";
            case 1 -> "on";
            case 2 -> "na";
            case 3 -> "nn";
            default -> throw new IllegalArgumentException("adkIdx=" + adkIdx);
        };
    }
}

