/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.layout;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.WeekDomain;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.backend.management.BaseIndex;
import de.bsvrz.ars.ars.persistence.layout.ClassicPersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.layout.DataKinds;
import de.bsvrz.ars.ars.persistence.layout.PathType;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.layout.ShortPersistenceDirectoryLayout;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;

public record PersistenceDirectoryLayoutInstance(PersistenceDirectoryLayout layout, Path basePath, int simulationVariant) {
    public IdContainerFileDir getContainerDirectory(BaseIndex<?> index) throws IndexException {
        try {
            return this.getContainerDirectory(index.getFile().getParent());
        }
        catch (PersistenceException e) {
            throw new IndexException("Kann Datenidentifikation von Index nicht bestimmen", index.getFile(), e);
        }
    }

    public IdContainerFileDir getContainerDirectory(Path containerDirectory) throws PersistenceException {
        ArchiveDataKind dataKind = DataKinds.getArchiveDataKindOptional(containerDirectory);
        if (dataKind == null) {
            throw new PersistenceException("Ung\u00fcltiges Verzeichnis: " + String.valueOf(containerDirectory));
        }
        IdDataIdentification did = this.layout.getDataIdentificationFromPath(PersistenceDirectoryLayoutInstance.toStack(this.basePath.relativize(containerDirectory.getParent())), this.simulationVariant);
        return new IdContainerFileDir(did, dataKind);
    }

    private static List<String> toStack(Path path) {
        ArrayList<String> list = new ArrayList<String>();
        for (Path element : path) {
            Path fileName = element.getFileName();
            if (fileName == null) continue;
            list.add(fileName.toString());
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public Path getPath(ContainerDirectory containerDirectory) {
        Path didPath = this.getPath(containerDirectory.dataIdentification());
        String suffix = DataKinds.getDataKindSuffix(containerDirectory.archiveDataKind());
        return didPath.resolve(suffix);
    }

    public Path getPath(IdDataIdentification dataIdentification) {
        return this.layout.getPath(this.basePath, dataIdentification);
    }

    public PathType getPathType(ArrayList<String> pathStack) {
        return this.layout.identifyPath(pathStack);
    }

    public IdDataIdentification getPath(ArrayList<String> pathStack) {
        return this.layout.getDataIdentificationFromPath(pathStack, this.simulationVariant);
    }

    @NotNull
    public static PersistenceDirectoryLayoutInstance detectFromPath(Path path) throws PersistenceException {
        path = path.toAbsolutePath();
        Path tmp = path.getRoot();
        for (Path element : path) {
            String pathName = element.getFileName().toString();
            if (ClassicPersistenceDirectoryLayout.OBJ_DIRNAME_PAT.matcher(pathName).matches()) {
                return ClassicPersistenceDirectoryLayout.instance(tmp, 0);
            }
            if (ShortPersistenceDirectoryLayout.decodeFast(pathName) != -1L) {
                return ShortPersistenceDirectoryLayout.instance(tmp, 0);
            }
            if (tmp == null) {
                tmp = element;
                continue;
            }
            tmp = tmp.resolve(element);
        }
        try {
            WeekDomain domain = ArchiveManager.detectDomain(path, true);
            if (domain == null) {
                return ClassicPersistenceDirectoryLayout.instance(path, 0);
            }
            return ShortPersistenceDirectoryLayout.instance(path, 0);
        }
        catch (IOException e) {
            throw new PersistenceException("Kann Wurzelverzeichnis von '" + String.valueOf(path) + "' nicht bestimmen", e);
        }
    }
}

