/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.util;

import de.bsvrz.ars.ars.persistence.util.SyncResult;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class FileSync {
    public SyncResult syncDirectories(Path from, Path to) throws IOException {
        SyncVisitor syncVisitor = new SyncVisitor(from, to);
        RemoveVisitor removeVisitor = new RemoveVisitor(from, to);
        Files.walkFileTree(from, syncVisitor);
        Files.walkFileTree(to, removeVisitor);
        return new SyncResult(syncVisitor.getFilesCopied(), removeVisitor.getFilesRemoved(), syncVisitor.getBytesCopied());
    }

    protected boolean shouldIgnore(String fileName) {
        return false;
    }

    public static boolean isIdentical(Path sourceFile, Path targetFile) throws IOException {
        if (!Files.exists(targetFile, new LinkOption[0])) {
            return false;
        }
        try {
            long targetTime;
            if (Files.isDirectory(targetFile, new LinkOption[0])) {
                return true;
            }
            if (Files.size(sourceFile) != Files.size(targetFile)) {
                return false;
            }
            long sourceTime = FileSync.getTruncatedModTime(sourceFile);
            return Math.abs(sourceTime - (targetTime = FileSync.getTruncatedModTime(targetFile))) <= 1L;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    private static long getTruncatedModTime(Path file) throws IOException {
        return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis() / 1000L;
    }

    private class SyncVisitor
    extends SimpleFileVisitor<Path> {
        private final Path _source;
        private final Path _target;
        private long _filesCopied;
        private long _bytesCopied;

        public SyncVisitor(Path source, Path target) {
            this._source = source;
            this._target = target;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            block4: {
                Path targetDir = this._target.resolve(this._source.relativize(dir));
                try {
                    if (!Files.isDirectory(targetDir, new LinkOption[0])) {
                        Path parent = targetDir.getParent();
                        if (!Files.isDirectory(parent, new LinkOption[0])) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        Files.copy(dir, targetDir, StandardCopyOption.COPY_ATTRIBUTES);
                        ++this._filesCopied;
                    }
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.isDirectory(targetDir, new LinkOption[0])) break block4;
                    throw e;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path targetFile = this._target.resolve(this._source.relativize(file));
            if (FileSync.this.shouldIgnore(file.getFileName().toString())) {
                return FileVisitResult.CONTINUE;
            }
            if (!FileSync.isIdentical(file, targetFile)) {
                Files.copy(file, targetFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                if (!FileSync.isIdentical(file, targetFile)) {
                    Files.setLastModifiedTime(targetFile, Files.getLastModifiedTime(file, new LinkOption[0]));
                }
                ++this._filesCopied;
                this._bytesCopied += Files.size(targetFile);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        public long getFilesCopied() {
            return this._filesCopied;
        }

        public long getBytesCopied() {
            return this._bytesCopied;
        }
    }

    private class RemoveVisitor
    extends SimpleFileVisitor<Path> {
        private final Path _source;
        private final Path _target;
        private long _filesRemoved;

        public RemoveVisitor(Path source, Path target) {
            this._source = source;
            this._target = target;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            super.postVisitDirectory(dir, exc);
            Path sourceDirectory = this._source.resolve(this._target.relativize(dir));
            if (!Files.exists(sourceDirectory, new LinkOption[0])) {
                Files.delete(dir);
                ++this._filesRemoved;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path sourceFile = this._source.resolve(this._target.relativize(file));
            if (!FileSync.this.shouldIgnore(file.getFileName().toString()) && !Files.exists(sourceFile, new LinkOption[0])) {
                Files.delete(file);
                ++this._filesRemoved;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        public long getFilesRemoved() {
            return this._filesRemoved;
        }
    }
}

