/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.util;

import de.bsvrz.ars.ars.persistence.util.TerminatedException;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToLongFunction;

public class SignalingQueue<E> {
    private final ArrayDeque<E> delegate;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition canTake = this.lock.newCondition();
    private final Condition empty = this.lock.newCondition();
    private boolean terminated = false;
    private final AtomicInteger capacityEstimate = new AtomicInteger();

    public SignalingQueue() {
        this.delegate = new ArrayDeque();
    }

    public void add(@NotNull E element) {
        this.lock.lock();
        try {
            if (this.terminated) {
                return;
            }
            boolean wasEmpty = this.delegate.isEmpty();
            this.delegate.add(element);
            this.updateCapacityEstimate(this.delegate.size());
            if (wasEmpty) {
                this.canTake.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateCapacityEstimate(int size) {
        int capacity = size + size / 2;
        if (capacity < size) {
            capacity = size;
        }
        this.capacityEstimate.accumulateAndGet(capacity, Math::max);
    }

    public E take() throws InterruptedException, TerminatedException {
        this.lock.lock();
        try {
            while (this.delegate.isEmpty() && !this.terminated) {
                this.canTake.await();
            }
            if (this.delegate.isEmpty()) {
                throw new TerminatedException();
            }
            E result = this.delegate.pop();
            if (this.delegate.isEmpty()) {
                this.empty.signalAll();
            }
            E e = result;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take(Duration timeout) throws InterruptedException, TerminatedException {
        long nanos = timeout.toNanos();
        this.lock.lockInterruptibly();
        try {
            while (this.delegate.isEmpty() && !this.terminated) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.canTake.awaitNanos(nanos);
            }
            if (this.delegate.isEmpty()) {
                throw new TerminatedException();
            }
            E result = this.delegate.pop();
            if (this.delegate.isEmpty()) {
                this.empty.signalAll();
            }
            E e = result;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmpty(Duration timeout) throws InterruptedException {
        long nanos = timeout.toNanos();
        this.lock.lock();
        try {
            while (!this.delegate.isEmpty()) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.empty.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void terminateNow() {
        this.lock.lock();
        try {
            this.terminated = true;
            this.delegate.clear();
            this.canTake.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void terminate() {
        this.lock.lock();
        try {
            this.terminated = true;
            this.canTake.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumElements(ToLongFunction<? super E> extractor) {
        this.lock.lock();
        try {
            long l = this.delegate.stream().mapToLong(extractor).sum();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long capacityEstimate() {
        return this.capacityEstimate.get();
    }
}

