/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.walk.internal;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.DataIdentificationDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.sequence.SequenceSpecification;
import de.bsvrz.ars.ars.persistence.walk.ContainerAction;
import de.bsvrz.ars.ars.persistence.walk.ContainerWalk;
import de.bsvrz.ars.ars.persistence.walk.DataIdentificationDirWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StandardContainerWalk
implements ContainerWalk {
    private final DataIdentificationDirWalk _dirWalk;
    private final PersistenceManager _persistenceManager;
    private final PersistenceDirectory _persistenceDirectory;

    public StandardContainerWalk(PersistenceManager persistenceManager, DataIdentificationDirWalk dirWalk, PersistenceDirectory persistenceDirectory) {
        this._persistenceManager = persistenceManager;
        this._dirWalk = dirWalk;
        this._persistenceDirectory = persistenceDirectory;
    }

    @Override
    public Duration getStatusInterval() {
        return this._dirWalk.getStatusInterval();
    }

    @Override
    public void setStatusInterval(Duration statusInterval) {
        this._dirWalk.setStatusInterval(statusInterval);
    }

    @Override
    public StatusPrinter getStatusPrinter() {
        return this._dirWalk.getStatusPrinter();
    }

    @Override
    public void setStatusPrinter(StatusPrinter statusPrinter) {
        this._dirWalk.setStatusPrinter(statusPrinter);
    }

    @Override
    public void execute(String actionName, int numThreads, ContainerAction action) throws PersistenceException {
        this._dirWalk.execute(actionName, numThreads, (DataIdentificationDir dataIdentificationDir, DataIdentificationDirWalk standardContainerDirWalk) -> {
            Collection<ArchiveDataSpecification> ads = dataIdentificationDir.getArchiveDataSpecifications();
            action.preVisitDirectory(dataIdentificationDir);
            try (SyncKey<IdDataIdentification> lock = this._persistenceManager.lockIndex(dataIdentificationDir.getDataIdentification());){
                for (LockedContainerDirectory lockedContainerDirectory : dataIdentificationDir.getContainerDirectories(lock)) {
                    Collection<ContainerHeaders> hdrList;
                    if (ads == null) {
                        IndexResult<ContainerManagementInformation> headers = this._persistenceDirectory.getContainerHeaders(lockedContainerDirectory);
                        this._dirWalk.increaseContCount(headers.size());
                        hdrList = IntStream.range(0, headers.size()).mapToObj(it -> new ContainerHeaders(headers, it, containerDirectory)).collect(Collectors.toList());
                    } else {
                        hdrList = new LinkedHashSet<ContainerHeaders>();
                        for (ArchiveDataSpecification dataSpecification : ads) {
                            ArchiveTimeSpecification timeSpec = dataSpecification.getTimeSpec();
                            SequenceSpecification sequence = this._persistenceManager.createSequenceFromArchiveTimeSpecification(timeSpec, lockedContainerDirectory);
                            IndexResult<IndexValues> indexResult = this._persistenceDirectory.getIndexResult(lockedContainerDirectory, sequence);
                            this._dirWalk.increaseContCount(indexResult.size());
                            for (int j = 0; j < indexResult.size(); ++j) {
                                long containerId = indexResult.get(j, IndexValues.ContainerId);
                                hdrList.add(this._persistenceDirectory.getContainerHeaders(lockedContainerDirectory, containerId));
                            }
                        }
                    }
                    action.run(dataIdentificationDir, lockedContainerDirectory, hdrList);
                }
            }
        });
    }

    @Override
    public void terminate() {
        this._dirWalk.terminate();
    }
}

