/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.walk.internal;

import java.text.NumberFormat;
import java.time.Duration;

public class StatusPrinter {
    public String getStatusMessage(String actionName, Duration runtime, ApproximationType approximationType, long allContainerDirs, long visitedContainerDirs, long visitedContainerFiles) {
        if (approximationType == ApproximationType.Minimum) {
            return actionName + " l\u00e4uft.\nBisherige Laufzeit: " + StatusPrinter.formatDuration(runtime) + "...\n" + visitedContainerDirs + " von mindestens " + allContainerDirs + " Container-Verzeichnissen besucht.\n" + StatusPrinter.estimateMinRuntime(runtime, visitedContainerDirs, allContainerDirs) + "..." + (String)(visitedContainerFiles == 0L ? "" : "\n" + visitedContainerFiles + " Container-Dateien besucht.");
        }
        if (approximationType == ApproximationType.Approximation) {
            return actionName + " l\u00e4uft.\nBisherige Laufzeit: " + StatusPrinter.formatDuration(runtime) + "...\n" + visitedContainerDirs + " von ungef\u00e4hr " + allContainerDirs + " Container-Verzeichnissen besucht.\n" + StatusPrinter.estimateRuntime(runtime, visitedContainerDirs, allContainerDirs) + "..." + (String)(visitedContainerFiles == 0L ? "" : "\n" + visitedContainerFiles + " Container-Dateien besucht.");
        }
        return actionName + " l\u00e4uft.\nBisherige Laufzeit: " + StatusPrinter.formatDuration(runtime) + "...\n" + visitedContainerDirs + " von " + allContainerDirs + " Container-Verzeichnissen besucht.\n" + StatusPrinter.estimateRuntime(runtime, visitedContainerDirs, allContainerDirs) + "..." + (String)(visitedContainerFiles == 0L ? "" : "\n" + visitedContainerFiles + " Container-Dateien besucht.");
    }

    public String getSuccessMessage(String actionName, Duration runtime, long visitedContainerDirs, long visitedContainerFiles) {
        return actionName + " beendet.\nLaufzeit: " + StatusPrinter.formatDuration(runtime) + ".\n" + visitedContainerDirs + " Container-Verzeichnisse besucht." + (String)(visitedContainerFiles == 0L ? "" : "\n" + visitedContainerFiles + " Container-Dateien besucht.");
    }

    public String getErrorMessage(String actionName, Duration runtime, long visitedContainerDirs, long visitedContainerFiles) {
        return actionName + " nach Fehler abgebrochen.\nLaufzeit: " + StatusPrinter.formatDuration(runtime) + ".\n" + visitedContainerDirs + " Container-Verzeichnisse besucht." + (String)(visitedContainerFiles == 0L ? "" : "\n" + visitedContainerFiles + " Container-Dateien besucht.");
    }

    public static String estimateRuntime(Duration runtime, long visited, long all) {
        double finishedRatio = (double)visited / (double)all;
        long currentRuntimeSeconds = runtime.getSeconds();
        double estimatedCompleteTime = (double)currentRuntimeSeconds / finishedRatio;
        if (visited == 0L || all == 0L || estimatedCompleteTime > (double)Duration.ofDays(1000L).getSeconds()) {
            return "Fortschritt: Unbekannt";
        }
        long remainingSeconds = (long)(estimatedCompleteTime - (double)currentRuntimeSeconds);
        Duration remainingDuration = Duration.ofSeconds(remainingSeconds);
        String duration = StatusPrinter.formatDuration(remainingDuration);
        return "Fortschritt: " + NumberFormat.getPercentInstance().format(finishedRatio) + ", noch ca. " + duration;
    }

    public static String estimateMinRuntime(Duration runtime, long visited, long indexed) {
        double maxFinishedRatio = (double)visited / (double)indexed;
        long currentRuntimeSeconds = runtime.getSeconds();
        double estimatedMinCompleteTime = (double)currentRuntimeSeconds / maxFinishedRatio;
        long remainingMinSeconds = (long)(estimatedMinCompleteTime - (double)currentRuntimeSeconds);
        Duration remainingDuration = Duration.ofSeconds(remainingMinSeconds);
        if (remainingDuration.toMinutes() < 1L) {
            return "Fortschritt: unbekannt";
        }
        String minDuration = StatusPrinter.formatDuration(remainingDuration);
        return "Fortschritt: unbekannt, gesch\u00e4tzte Laufzeit: noch mindestens " + minDuration;
    }

    public static String formatDuration(Duration runtime) {
        long days = runtime.toDays();
        long hours = runtime.toHours() % 24L;
        long minutes = runtime.toMinutes() % 60L;
        long seconds = runtime.getSeconds() % 60L;
        if (days == 0L) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        if (days == 1L) {
            return String.format("1 Tag, %02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%d Tage, %02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static enum ApproximationType {
        Minimum,
        Approximation,
        Exact;

    }
}

