/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.persistence.writer.ArchiveOnlineData;
import de.bsvrz.ars.ars.persistence.writer.ArchiveRequestedData;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.ars.ars.persistence.writer.AsyncSerializableDataset;
import de.bsvrz.ars.ars.persistence.writer.CloseContainerObject;
import de.bsvrz.ars.ars.persistence.writer.RequestedDataFinished;
import de.bsvrz.dav.daf.communication.dataRepresentation.data.byteArray.ByteArrayData;
import de.bsvrz.dav.daf.main.Data;
import java.util.function.Consumer;

public sealed interface ArchiveJob
extends Consumer<ArchiveTask>
permits ArchiveOnlineData, ArchiveRequestedData, CloseContainerObject, RequestedDataFinished {
    public long estimateMemoryUsage();

    public static int estimateDataUsage(Data data) {
        if (data == null) {
            return 0;
        }
        if (data instanceof ByteArrayData) {
            ByteArrayData byteArrayData = (ByteArrayData)data;
            return 52 + byteArrayData.getBytes().length;
        }
        return 32;
    }

    public static long estimateDatasetUsage(AsyncSerializableDataset data) {
        long size = 54L;
        Data d = data.originalData();
        if (d != null) {
            size += (long)ArchiveJob.estimateDataUsage(d);
        }
        return size;
    }
}

