/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.writer.ArchiveJob;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Objects;

public record ArchiveRequestedData(SerializableDataset dataset, IdDataIdentification dataIdentification, boolean delayed) implements ArchiveJob
{
    private static final Debug _debug = Debug.getLogger();

    @Override
    public void accept(ArchiveTask archiveTask) {
        try {
            long archTime = this.dataset.archiveTime();
            ArchiveDataKind adk = this.delayed ? ArchiveDataKind.REQUESTED_DELAYED : ArchiveDataKind.REQUESTED;
            IdContainerFileDir containerFileDir = this.dataIdentification.resolve(adk);
            ActivePersistenceDirectory persistenceDirectory = archiveTask.getPersistenceManager().updateAndGetActivePersistenceDirectory(archTime, this.dataIdentification.getSimVariant());
            boolean append = archiveTask.getSerializationHelper().writeData(this.dataset, persistenceDirectory, containerFileDir);
            if (!append) {
                archiveTask.getFailCounterRequested().incrementAndGet();
                return;
            }
            persistenceDirectory.markAsDirty(containerFileDir);
            archiveTask.getSuccessCounterRequested().incrementAndGet();
        }
        catch (Exception e) {
            archiveTask.getFailCounterRequested().incrementAndGet();
            _debug.error(archiveTask.getName() + ": Fehler beim Archivieren eines Datensatzes: " + e.getMessage() + Debug.NEWLINE + String.valueOf(this.dataset), (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArchiveRequestedData that = (ArchiveRequestedData)obj;
        return Objects.equals(this.dataset, that.dataset);
    }

    @Override
    public String toString() {
        return "ArchiveRequestedData[dataset=" + String.valueOf(this.dataset) + "]";
    }

    @Override
    public long estimateMemoryUsage() {
        return 28L + this.dataset.estimateMemoryUsage();
    }
}

