/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.writer.ArchiveJob;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.sys.funclib.debug.Debug;

public record CloseContainerObject(IdDataIdentification did) implements ArchiveJob
{
    private static final Debug _debug = Debug.getLogger();

    @Override
    public void accept(ArchiveTask archiveTask) {
        ActivePersistenceDirectory persistenceDirectory = archiveTask.getPersistenceManager().getActivePersistenceDirectory(this.did.getSimVariant());
        if (persistenceDirectory == null) {
            return;
        }
        try (SyncKey<IdDataIdentification> lock = archiveTask.getPersistenceManager().lockIndex(this.did);){
            for (ArchiveDataKind dataKind : ArchiveDataKindCombination.all()) {
                persistenceDirectory.closeOpenContainer(new LockedContainerDirectory(lock, dataKind));
            }
            archiveTask.getCloseCounter().incrementAndGet();
        }
        catch (Exception e) {
            _debug.error("Fehler beim Abschliessen eines Containers: " + e.getMessage() + Debug.NEWLINE + String.valueOf(this), (Throwable)e);
        }
    }

    @Override
    public long estimateMemoryUsage() {
        return 74L;
    }
}

