/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.util.Util;

public record RegularSerializableDataset(long archiveTime, long dataTime, long dataIndex, @NotNull byte[] serializedData, int uncompressedSize, boolean isAlreadyCompressed) implements SerializableDataset
{
    public RegularSerializableDataset(long archiveTime, long dataTime, long dataIndex, byte[] serializedData) {
        this(archiveTime, dataTime, dataIndex, serializedData, 0, false);
    }

    @Override
    @NotNull
    public DataState dataState() {
        if (this.serializedData.length == 6) {
            if (Util.cmpBytes((byte[])this.serializedData, (int)0, (byte[])ContainerFile.NO_DATA)) {
                return DataState.NO_DATA;
            }
            if (Util.cmpBytes((byte[])this.serializedData, (int)0, (byte[])ContainerFile.NO_SOURCE)) {
                return DataState.NO_SOURCE;
            }
            if (Util.cmpBytes((byte[])this.serializedData, (int)0, (byte[])ContainerFile.NO_RIGHTS)) {
                return DataState.NO_RIGHTS;
            }
            if (Util.cmpBytes((byte[])this.serializedData, (int)0, (byte[])ContainerFile.POT_GAP)) {
                return DataState.POSSIBLE_GAP;
            }
        }
        return DataState.DATA;
    }

    @Override
    public long estimateMemoryUsage() {
        return 45 + this.serializedData.length;
    }

    @Override
    public Data originalData() {
        return null;
    }

    @Override
    public String toString() {
        return "RegularSerializableDataset[\n  Archivzeit=" + Util.timestrMillisFormatted((long)this.archiveTime()) + "\n  Datenzeit=" + Util.timestrMillisFormatted((long)this.dataTime()) + "\n  Datenindex=" + Util.dIdx2StrExt((long)this.dataIndex()) + "\n  Art=" + String.valueOf(this.dataState()) + "\n  Komprimiert=" + Util.printHex((byte[])this.serializedData()) + "\n  Speicherverbrauch=" + (this.uncompressedSize() == 0 ? this.serializedData().length : this.uncompressedSize()) + " Bytes\n]";
    }
}

