/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.repair;

import de.bsvrz.ars.ars.persistence.DataIdentificationManager;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.ReadonlyPersistenceDirectory;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.ars.ars.repair.PersistenceCheckRunner;
import de.bsvrz.ars.ars.repair.RescueResult;
import de.bsvrz.ars.ars.repair.ScanMode;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.nio.file.Path;

public class ContainerRescue {
    private final Path _startDirectory;
    private final boolean _recursiveScan;
    private final boolean _fixDefects;
    private final boolean _checkContainerFiles;
    private final boolean _checkIndexFiles;
    private final boolean _extended;

    public static void main(String[] args) {
        try {
            ArgumentList arguments = new ArgumentList(args);
            Debug.init((String)"ContainerRescue", (ArgumentList)arguments);
            ContainerRescue containerRescue = new ContainerRescue(arguments);
            containerRescue.start();
        }
        catch (Exception e) {
            System.err.println("Ein unerwarteter Fehler ist w\u00e4hrend der Programmausf\u00fchrung aufgetreten: " + String.valueOf(e));
            e.printStackTrace(System.err);
        }
    }

    public ContainerRescue(ArgumentList arguments) {
        this._startDirectory = arguments.fetchArgument("-verzeichnis=.").asPath();
        this._recursiveScan = arguments.fetchArgument("-rekursiv=ja").booleanValue();
        this._checkContainerFiles = arguments.fetchArgument("-container=ja").booleanValue();
        this._checkIndexFiles = arguments.fetchArgument("-index=ja").booleanValue();
        this._extended = arguments.fetchArgument("-erweitert=nein").booleanValue();
        this._fixDefects = arguments.fetchArgument("-reparieren=nein").booleanValue();
        arguments.ensureAllArgumentsUsed();
    }

    private void start() throws PersistenceException {
        RescueResult rescueResult;
        System.out.println("Aufrufparameter: -verzeichnis=" + String.valueOf(this._startDirectory) + " -rekursiv=" + (this._recursiveScan ? "ja" : "nein") + " -container=" + (this._checkContainerFiles ? "ja" : "nein") + " -index=" + (this._checkIndexFiles ? "ja" : "nein") + " -erweitert=" + (this._extended ? "ja" : "nein") + " -reparieren=" + (this._fixDefects ? "ja" : "nein"));
        System.out.println("########## Das Verzeichnis " + String.valueOf(this._startDirectory.toAbsolutePath()) + (this._recursiveScan ? " und rekursiv alle enthaltenen Unterverzeichnisse werden" : " wird") + " nach defekten Dateien untersucht. Defekte Dateien werden ausgegeben " + (this._fixDefects ? "und" : "aber nicht") + " repariert.");
        long t0 = System.currentTimeMillis();
        DataIdentificationManager containerCreator = dataIdentification -> {
            throw new AssertionError();
        };
        PersistenceDirectoryLayoutInstance layoutInstance = PersistenceDirectoryLayoutInstance.detectFromPath(this._startDirectory);
        ScanMode scanMode = new ScanMode(this._checkIndexFiles, this._checkContainerFiles, this._checkIndexFiles && this._extended, this._checkContainerFiles && this._extended, true, false);
        if (!this._recursiveScan) {
            rescueResult = new RescueResult();
            PersistenceCheckRunner.scanDirectory(this._startDirectory, layoutInstance, scanMode, rescueResult);
        } else {
            ReadonlyPersistenceDirectory persistenceDirectory = new ReadonlyPersistenceDirectory(containerCreator, layoutInstance);
            rescueResult = PersistenceCheckRunner.scan(persistenceDirectory, scanMode);
        }
        long t1 = System.currentTimeMillis();
        long scanTime = t1 - t0;
        System.out.println("########## Zusammenfassung der Pr\u00fcfung:");
        System.out.println("Dauer der Pr\u00fcfung:                      " + String.format("%.3f Sekunden", (double)scanTime / 1000.0));
        System.out.println("Anzahl gepr\u00fcfter Container:             " + rescueResult.getCheckedContainerFileCount());
        System.out.println("Anzahl Container ohne Defekte:          " + rescueResult.getValidContainerFileCount());
        System.out.println("Anzahl Container mit Defekten:          " + rescueResult.getDefectContainerFileCount());
        System.out.println("Anzahl gepr\u00fcfter Indexdateien:          " + rescueResult.getCheckedIndexFileCount());
        System.out.println("Anzahl Indexdateien ohne Defekte:       " + rescueResult.getValidIndexFileCount());
        System.out.println("Anzahl Indexdateien mit Defekten:       " + rescueResult.getDefectIndexFileCount());
        System.out.println("Anzahl korrigierbare Defekte:           " + rescueResult.getFixableDefectsCount());
        System.out.println("Anzahl gel\u00f6schte Backup-Index-Dateien : " + rescueResult.getDeletedFiles());
        if (rescueResult.getFixableDefectsCount() > 0) {
            if (this._fixDefects) {
                PersistenceCheckRunner.fixDefects(rescueResult, layoutInstance);
            } else {
                System.out.println("########## Zur Korrektur der korrigierbaren Defekte bitte das Aufrufargument -reparieren=ja verwenden.");
            }
        }
    }
}

