/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.repair;

import de.bsvrz.ars.ars.persistence.BasicContainerFileHandle;
import de.bsvrz.ars.ars.persistence.ContainerDataIterator;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerHdr;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.DeletedContainerFile;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.StandaloneContainerFileHandle;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.ContainerManagementIndex;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.layout.DataIdentificationListener;
import de.bsvrz.ars.ars.persistence.layout.DataKinds;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.ars.ars.persistence.walk.internal.DataIdentificationDirGetters;
import de.bsvrz.ars.ars.persistence.walk.internal.StandardDataidentificationDirWalk;
import de.bsvrz.ars.ars.repair.Defect;
import de.bsvrz.ars.ars.repair.RescueResult;
import de.bsvrz.ars.ars.repair.ScanMode;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.util.BufferedRandomAccessFile;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.EOFException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class PersistenceCheckRunner {
    private static final FilenameFilter _containerFilenameFilter;
    private static final FilenameFilter _indexFilenameFilter;

    @NotNull
    public static RescueResult scan(PersistenceDirectory persistenceDirectory, ScanMode scanMode) throws PersistenceException {
        final RescueResult rescueResult = new RescueResult();
        DataIdentificationListener listener = new DataIdentificationListener(){

            @Override
            public void foundDataIdentification(IdDataIdentification dataIdentification, Path dir) {
                rescueResult.incrDataIdentificationsVisited();
            }

            @Override
            public void foundForeignDirectory(Path dir) {
                new Defect(dir, rescueResult.getCantFix(), "Unerwartetes Verzeichnis in der Verzeichnisstruktur");
            }

            @Override
            public void foundForeignFile(Path file) {
                new Defect(file, rescueResult.getCantFix(), "Unerwartete Datei in der Verzeichnisstruktur");
            }

            @Override
            public void ioException(Path file, IOException exception) {
                new Defect(file, rescueResult.getCantFix(), "Fehler beim Zugriff", exception);
            }
        };
        StandardDataidentificationDirWalk containerDirWalk = new StandardDataidentificationDirWalk(DataIdentificationDirGetters.allWithDelegate(persistenceDirectory, listener));
        containerDirWalk.execute("\u00dcberpr\u00fcfung", 11, (containerFileDir, standardContainerDirWalk) -> {
            Path dataIdentificationDir = containerFileDir.getDataIdentificationDir();
            for (ArchiveDataKind dataKind : containerFileDir.getArchiveDataKinds()) {
                String dataKindSuffix = DataKinds.getDataKindSuffix(dataKind);
                PersistenceCheckRunner.scanDirectory(dataIdentificationDir.resolve(dataKindSuffix), persistenceDirectory.getLayoutInstance(), scanMode, rescueResult);
            }
        });
        return rescueResult;
    }

    public static void fixDefects(RescueResult rescueResult, PersistenceDirectoryLayoutInstance layoutInstance) {
        long correctedDefectCount;
        long t1 = System.currentTimeMillis();
        if (!rescueResult.getOneByteShortDefects().isEmpty()) {
            System.out.println("########## Korrektur der gel\u00f6schten Container, die ein Byte zu kurz sind. Anzahl: " + rescueResult.getOneByteShortDefects().size());
            List<Defect> oneByteShortDefects = List.copyOf(rescueResult.getOneByteShortDefects());
            rescueResult.getOneByteShortDefects().clear();
            for (Defect oneByteShortDefect : oneByteShortDefects) {
                PersistenceCheckRunner.fixOneByteShortDefect(oneByteShortDefect);
            }
            System.out.println("  ########## Erneute Pr\u00fcfung der korrigierten Container:");
            for (Defect oneByteShortDefect : oneByteShortDefects) {
                PersistenceCheckRunner.checkContainerFile(oneByteShortDefect.getFile(), rescueResult, true);
            }
            correctedDefectCount = oneByteShortDefects.size() - rescueResult.getOneByteShortDefects().size();
            System.out.println("  ########## Anzahl erfolgreich korrigierter Defekte: " + correctedDefectCount);
            rescueResult.incrCorrectedDefectCount(correctedDefectCount);
        }
        if (!rescueResult.getBadRangeEndDefects().isEmpty()) {
            System.out.println("########## Korrektur der gel\u00f6schten Container, die eine falsche Endangabe eines Datensatzindexbereichs enthalten. Anzahl: " + rescueResult.getBadRangeEndDefects().size());
            List<Defect> badRangeEndDefects = List.copyOf(rescueResult.getBadRangeEndDefects());
            rescueResult.getBadRangeEndDefects().clear();
            for (Defect badRangeEndDefect : badRangeEndDefects) {
                PersistenceCheckRunner.fixBadRangeEndDefect(badRangeEndDefect);
            }
            System.out.println("  ########## Erneute Pr\u00fcfung der korrigierten Container:");
            for (Defect badRangeEndDefect : badRangeEndDefects) {
                PersistenceCheckRunner.checkContainerFile(badRangeEndDefect.getFile(), rescueResult, true);
            }
            correctedDefectCount = badRangeEndDefects.size() - rescueResult.getBadRangeEndDefects().size();
            System.out.println("  ########## Anzahl erfolgreich korrigierter Defekte: " + correctedDefectCount);
            rescueResult.incrCorrectedDefectCount(correctedDefectCount);
        }
        if (!rescueResult.getBadContainerFileEnd().isEmpty()) {
            System.out.println("########## Korrektur der Container-Dateien mit ung\u00fcltigen Bytes am Dateiende. Anzahl: " + rescueResult.getBadContainerFileEnd().size());
            List<Defect> badContainerFileEnds = List.copyOf(rescueResult.getBadContainerFileEnd());
            rescueResult.getBadContainerFileEnd().clear();
            for (Defect badContainerFileEnd : badContainerFileEnds) {
                PersistenceCheckRunner.fixBadContainerFileEnd(badContainerFileEnd, layoutInstance);
            }
            System.out.println("  ########## Erneute Pr\u00fcfung der korrigierten Container:");
            for (Defect badContainerFileEnd : badContainerFileEnds) {
                PersistenceCheckRunner.checkContainerFile(badContainerFileEnd.getFile(), rescueResult, true);
            }
            correctedDefectCount = badContainerFileEnds.size() - rescueResult.getBadContainerFileEnd().size();
            System.out.println("  ########## Anzahl erfolgreich korrigierter Defekte: " + correctedDefectCount);
            rescueResult.incrCorrectedDefectCount(correctedDefectCount);
        }
        if (!rescueResult.getShortContainerFiles().isEmpty()) {
            System.out.println("########## Korrektur der leeren Container-Dateien. Anzahl: " + rescueResult.getShortContainerFiles().size());
            List<Defect> shortContainerFiles = List.copyOf(rescueResult.getShortContainerFiles());
            rescueResult.getShortContainerFiles().clear();
            for (Defect shortContainerFile : shortContainerFiles) {
                PersistenceCheckRunner.fixShortContainerFile(shortContainerFile);
            }
            rescueResult.incrCorrectedDefectCount(shortContainerFiles.size());
        }
        if (!rescueResult.getBadIndexFiles().isEmpty()) {
            System.out.println("########## Korrektur von Indexdateien, die fehlerhafte oder unvollst\u00e4ndige Eintr\u00e4ge enthalten. Anzahl: " + rescueResult.getBadIndexFiles().size());
            List<Defect> badIndexFileDefects = List.copyOf(rescueResult.getBadIndexFiles());
            rescueResult.getBadIndexFiles().clear();
            for (Defect badIndexFileDefect : badIndexFileDefects) {
                PersistenceCheckRunner.fixBadIndexFileDefect(badIndexFileDefect);
            }
            System.out.println("  ########## Erneute Pr\u00fcfung der korrigierten Indexdateien:");
            for (Defect badIndexFileDefect : badIndexFileDefects) {
                Path directory = badIndexFileDefect.getFile().getParent();
                Path[] containerFiles = PersistenceCheckRunner.listFiles(directory, _containerFilenameFilter);
                HashSet<Long> containerIDs = PersistenceCheckRunner.getContainerIdsInDirectory(directory, layoutInstance, containerFiles);
                Map<Long, ContainerHeaders> actualContainerHeaders = PersistenceCheckRunner.loadContainerHeaders(directory, layoutInstance, containerFiles);
                PersistenceCheckRunner.checkIndexFile(badIndexFileDefect.getFile(), containerIDs, rescueResult, actualContainerHeaders);
            }
            long correctedDefectCount2 = badIndexFileDefects.size() - rescueResult.getBadIndexFiles().size();
            System.out.println("  ########## Anzahl erfolgreich korrigierter Defekte: " + correctedDefectCount2);
            rescueResult.incrCorrectedDefectCount(correctedDefectCount2);
        }
        System.out.println("########## Gesamtzahl erfolgreich korrigierter Defekte: " + rescueResult.getCorrectedDefectCount());
        long t2 = System.currentTimeMillis();
        long fixTime = t2 - t1;
        System.out.println("Dauer der Korrektur:             " + String.format("%.3f Sekunden", (double)fixTime / 1000.0));
    }

    private static void fixShortContainerFile(Defect defect) {
        Path containerFile = defect.getFile();
        try {
            Files.deleteIfExists(containerFile);
            Path indexFile = containerFile.resolveSibling(ContainerManagementIndex.IDX_FILENAME);
            Files.deleteIfExists(indexFile);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(containerFile) + ": Unerwarteter Fehler bei der Reparatur: " + String.valueOf(e));
        }
    }

    public static void scanDirectory(Path directory, PersistenceDirectoryLayoutInstance layoutInstance, ScanMode scanMode, RescueResult rescueResult) {
        try {
            Path[] containerFiles = PersistenceCheckRunner.listFiles(directory, _containerFilenameFilter);
            if (scanMode.containerFiles() || scanMode.containerHeaderConsistency()) {
                for (Path containerFile : containerFiles) {
                    PersistenceCheckRunner.checkContainerFile(containerFile, rescueResult, scanMode.containerHeaderConsistency());
                }
            }
            HashSet<Long> containerIDs = PersistenceCheckRunner.getContainerIdsInDirectory(directory, layoutInstance, containerFiles);
            if (scanMode.indexFiles() || scanMode.indexHeaderConsistency()) {
                Path[] indexFileArray;
                Map<Long, ContainerHeaders> actualContainerHeaders = null;
                if (scanMode.indexHeaderConsistency()) {
                    actualContainerHeaders = PersistenceCheckRunner.loadContainerHeaders(directory, layoutInstance, containerFiles);
                }
                for (Path indexFile : indexFileArray = PersistenceCheckRunner.listFiles(directory, _indexFilenameFilter)) {
                    PersistenceCheckRunner.checkIndexFile(indexFile, containerIDs, rescueResult, actualContainerHeaders);
                }
            }
        }
        catch (Exception e) {
            System.out.println(directory.toString() + ": Unerwarteter Fehler bei der Analyse: " + String.valueOf(e));
        }
    }

    private static Map<Long, ContainerHeaders> loadContainerHeaders(Path directory, PersistenceDirectoryLayoutInstance layoutInstance, Path[] containerFiles) {
        try {
            TreeMap<Long, ContainerHeaders> actualContainerHeaders = new TreeMap<Long, ContainerHeaders>();
            for (Path containerFile : containerFiles) {
                try (StandaloneContainerFileHandle containerFileHandle = new StandaloneContainerFileHandle(containerFile);){
                    containerFileHandle.readContainerHeader();
                    actualContainerHeaders.put(containerFileHandle.getContainerId(), new ContainerHeaders(containerFileHandle));
                }
            }
            DeletedContainerFile deletedContainerFile = new DeletedContainerFile(directory, layoutInstance.getContainerDirectory(directory));
            if (deletedContainerFile.exists()) {
                deletedContainerFile.read();
                for (Long container : deletedContainerFile.containers()) {
                    actualContainerHeaders.putIfAbsent(container, new ContainerHeaders(deletedContainerFile.headers(container)));
                }
            }
            return actualContainerHeaders;
        }
        catch (Exception e) {
            System.out.println(directory.toString() + ": Unerwarteter Fehler bei der Analyse: " + String.valueOf(e));
            return null;
        }
    }

    private static HashSet<Long> getContainerIdsInDirectory(Path directory, PersistenceDirectoryLayoutInstance layoutInstance, Path[] containerFileArray) {
        List<Path> containerFiles = Arrays.asList(containerFileArray);
        HashSet<Long> result = PersistenceCheckRunner.fileListToIdList(containerFiles);
        try {
            IdContainerFileDir containerDirectory = layoutInstance.getContainerDirectory(directory);
            DeletedContainerFile deletedContainerFile = new DeletedContainerFile(directory, containerDirectory);
            if (deletedContainerFile.exists()) {
                deletedContainerFile.read();
            }
            result.addAll(deletedContainerFile.containers());
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        return result;
    }

    private static HashSet<Long> fileListToIdList(List<Path> containerFiles) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Path containerFile : containerFiles) {
            hashSet.add(ContainerFile.getContID(containerFile.getFileName().toString()));
        }
        return hashSet;
    }

    private static void checkIndexFile(Path indexFile, HashSet<Long> containerIDs, RescueResult rescueResult, Map<Long, ContainerHeaders> actualContainerHeaders) {
        rescueResult.incrCheckedIndexFileCount();
        Defect defect = PersistenceCheckRunner.inspectIndexFile(indexFile, containerIDs, rescueResult, actualContainerHeaders);
        if (defect == null) {
            rescueResult.incrValidIndexFileCount();
        } else {
            rescueResult.incrDefectIndexFileCount();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Defect inspectIndexFile(Path indexFile, HashSet<Long> containerIDs, RescueResult rescueResult, Map<Long, ContainerHeaders> actualContainerHeaders) {
        try {
            if (!Files.exists(indexFile, new LinkOption[0])) {
                return null;
            }
            if (!Files.isReadable(indexFile)) return new Defect(indexFile, rescueResult.getCantFix(), "Datei nicht lesbar");
            try (RandomAccessFile raf = new RandomAccessFile(indexFile.toFile(), "r");){
                String fileName = indexFile.getFileName().toString();
                if (fileName.startsWith("_didx")) {
                    Defect defect = PersistenceCheckRunner.checkDIDIndexFile(raf, indexFile, containerIDs, rescueResult, actualContainerHeaders);
                    return defect;
                }
                if (fileName.startsWith("_datatime")) {
                    Defect defect = PersistenceCheckRunner.checkDataTimeIndexFile(raf, indexFile, containerIDs, rescueResult, actualContainerHeaders);
                    return defect;
                }
                if (fileName.startsWith("_dataindex")) {
                    Defect defect = PersistenceCheckRunner.checkDataIndexFile(raf, indexFile, containerIDs, rescueResult, actualContainerHeaders);
                    return defect;
                }
                if (fileName.startsWith("_backupindex")) {
                    PersistenceCheckRunner.checkBackupIndexFile(indexFile, rescueResult);
                    Defect defect = null;
                    return defect;
                }
                if (!fileName.equals(ContainerManagementIndex.IDX_FILENAME)) return new Defect(indexFile, rescueResult.getCantFix(), "Unbekannter Dateityp");
                Defect defect = PersistenceCheckRunner.checkManagementIndexFile(indexFile, containerIDs, rescueResult, actualContainerHeaders);
                return defect;
            }
        }
        catch (EOFException e) {
            return new Defect(indexFile, rescueResult.getBadIndexFiles(), "Datei nicht vollst\u00e4ndig");
        }
        catch (IOException e) {
            return new Defect(indexFile, rescueResult.getCantFix(), "Fehler beim Lesen: " + String.valueOf(e));
        }
    }

    private static Defect checkManagementIndexFile(Path indexFile, HashSet<Long> containerIDs, RescueResult rescueResult, Map<Long, ContainerHeaders> actualContainerHeaders) {
        try {
            IndexResult<ContainerManagementInformation> result;
            try (ContainerManagementIndex index = new ContainerManagementIndex(1024, indexFile);){
                result = index.query();
            }
            HashSet<Long> containerFileIDs = new HashSet<Long>(containerIDs);
            for (int i = 0; i < result.size(); ++i) {
                long contId = result.get(i, ContainerManagementInformation.CHP_CONT_ID);
                if (actualContainerHeaders != null) {
                    int indexAnz;
                    ContainerHeaders containerHeaders = actualContainerHeaders.get(contId);
                    if (containerHeaders == null) {
                        return new Defect(indexFile, rescueResult.getBadIndexFiles(), "Containerdatei fehlt: " + contId);
                    }
                    ContainerHeaders indexHeaders = new ContainerHeaders(result, i, containerHeaders.getLocation());
                    int contAnz = containerHeaders.getContainerHeaderParamAsInt(ContainerManagementInformation.CHP_ANZ_DS);
                    if (contAnz != (indexAnz = indexHeaders.getContainerHeaderParamAsInt(ContainerManagementInformation.CHP_ANZ_DS))) {
                        return new Defect(indexFile, rescueResult.getBadIndexFiles(), "Abweichung in Verwaltungsdatenindex von Container-Header: ANZ_DS (container: " + contAnz + ", index: " + indexAnz + ")");
                    }
                    if (contAnz != -1) {
                        List<ContainerManagementInformation> relevantHeaders = List.of(ContainerManagementInformation.CHP_DATA_IDX_MIN, ContainerManagementInformation.CHP_DATA_IDX_MAX, ContainerManagementInformation.CHP_ARC_TIME_MIN, ContainerManagementInformation.CHP_ARC_TIME_MAX, ContainerManagementInformation.CHP_DATA_TIME_MIN, ContainerManagementInformation.CHP_DATA_TIME_MAX);
                        for (ContainerManagementInformation info : relevantHeaders) {
                            long indexValue;
                            long contValue = containerHeaders.getContainerHeaderParamAsLong(info);
                            if (contValue == (indexValue = indexHeaders.getContainerHeaderParamAsLong(info))) continue;
                            return new Defect(indexFile, rescueResult.getBadIndexFiles(), "Abweichung in Verwaltungsdatenindex von Container-Header: " + String.valueOf((Object)info) + " (container: " + contValue + ", index: " + indexValue + ")");
                        }
                    }
                }
                containerFileIDs.remove(contId);
            }
            if (!containerFileIDs.isEmpty()) {
                return new Defect(indexFile, rescueResult.getBadIndexFiles(), "Es kommen nicht alle ContainerIDs in der Indexdatei vor.");
            }
        }
        catch (IndexException e) {
            return new Defect(indexFile, rescueResult.getBadIndexFiles(), "ContainerHeaderIndex konnte nicht gelesen werden: " + e.getMessage());
        }
        return null;
    }

    private static void checkBackupIndexFile(Path indexFile, RescueResult rescueResult) throws IOException {
        if (Files.deleteIfExists(indexFile)) {
            rescueResult.incrDeletedFiles();
        }
    }

    private static Defect checkDIDIndexFile(RandomAccessFile raf, Path fileName, HashSet<Long> containerIDs, RescueResult rescueResult, Map<Long, ContainerHeaders> actualContainerHeaders) throws IOException {
        long length = raf.length();
        long atmax_old = Long.MIN_VALUE;
        long cid_old = Long.MIN_VALUE;
        HashSet<Long> containerFileIDs = new HashSet<Long>(containerIDs);
        while (raf.getFilePointer() < length) {
            long dimin = raf.readLong();
            long dimax = raf.readLong();
            long atmin = PersistenceCheckRunner.read6(raf);
            long atmax = PersistenceCheckRunner.read6(raf);
            long dtmin = PersistenceCheckRunner.read6(raf);
            long dtmax = PersistenceCheckRunner.read6(raf);
            long cid = PersistenceCheckRunner.read5(raf);
            if (atmax_old > atmin) {
                return new Defect(fileName, rescueResult.getBadIndexFiles(), "Archivzeit nicht monoton steigend");
            }
            if (cid_old >= cid) {
                return new Defect(fileName, rescueResult.getBadIndexFiles(), "ContainerID nicht streng monoton steigend");
            }
            if (actualContainerHeaders != null) {
                ContainerHeaders containerHeaders = actualContainerHeaders.get(cid);
                if (containerHeaders == null) {
                    return new Defect(fileName, rescueResult.getBadIndexFiles(), "Containerdatei fehlt: " + cid);
                }
                if (containerHeaders.getContainerHeaderParamAsInt(ContainerManagementInformation.CHP_ANZ_DS) != -1) {
                    if (dimin != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MIN)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_IDX_MIN");
                    }
                    if (dimax != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_IDX_MAX");
                    }
                    if (atmin != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MIN)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: ARC_TIME_MIN");
                    }
                    if (atmax != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: ARC_TIME_MAX");
                    }
                    if (dtmin != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MIN)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_TIME_MIN");
                    }
                    if (dtmax != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_TIME_MAX");
                    }
                }
            }
            containerFileIDs.remove(cid);
            atmax_old = atmax;
            cid_old = cid;
        }
        if (!containerFileIDs.isEmpty()) {
            return new Defect(fileName, rescueResult.getBadIndexFiles(), "Es kommen nicht alle ContainerIDs in der Indexdatei vor.");
        }
        return null;
    }

    private static Defect checkDataTimeIndexFile(RandomAccessFile raf, Path fileName, HashSet<Long> containerIDs, RescueResult rescueResult, Map<Long, ContainerHeaders> actualContainerHeaders) throws IOException {
        long length = raf.length();
        long dtmin_old = Long.MIN_VALUE;
        HashSet<Long> indexContainerIds = new HashSet<Long>();
        HashSet<Long> containerFileIDs = new HashSet<Long>(containerIDs);
        while (raf.getFilePointer() < length) {
            long dtmin = PersistenceCheckRunner.read6(raf);
            long dtmax = PersistenceCheckRunner.read6(raf);
            long dimin = raf.readLong();
            long dimax = raf.readLong();
            long cid = PersistenceCheckRunner.read5(raf);
            if (indexContainerIds.contains(cid)) {
                return new Defect(fileName, rescueResult.getBadIndexFiles(), "ContainerID mehrfach vorhanden");
            }
            if (dtmin_old > dtmin) {
                return new Defect(fileName, rescueResult.getBadIndexFiles(), "Datenzeit nicht monoton steigend");
            }
            if (actualContainerHeaders != null) {
                ContainerHeaders containerHeaders = actualContainerHeaders.get(cid);
                if (containerHeaders == null) {
                    return new Defect(fileName, rescueResult.getBadIndexFiles(), "Containerdatei fehlt: " + cid);
                }
                if (containerHeaders.getContainerHeaderParamAsInt(ContainerManagementInformation.CHP_ANZ_DS) != -1) {
                    if (dimin != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MIN)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_IDX_MIN");
                    }
                    if (dimax != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_IDX_MAX");
                    }
                    if (dtmin != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MIN)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_TIME_MIN");
                    }
                    if (dtmax != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_TIME_MAX");
                    }
                }
            }
            indexContainerIds.add(cid);
            containerFileIDs.remove(cid);
            dtmin_old = dtmin;
        }
        if (!containerFileIDs.isEmpty()) {
            return new Defect(fileName, rescueResult.getBadIndexFiles(), "Es kommen nicht alle ContainerIDs in der Indexdatei vor.");
        }
        return null;
    }

    private static Defect checkDataIndexFile(RandomAccessFile raf, Path fileName, HashSet<Long> containerIDs, RescueResult rescueResult, Map<Long, ContainerHeaders> actualContainerHeaders) throws IOException {
        long length = raf.length();
        long dimin_old = Long.MIN_VALUE;
        HashSet<Long> indexContainerIds = new HashSet<Long>();
        HashSet<Long> containerFileIDs = new HashSet<Long>(containerIDs);
        while (raf.getFilePointer() < length) {
            long dimin = raf.readLong();
            long dimax = raf.readLong();
            long cid = PersistenceCheckRunner.read5(raf);
            if (indexContainerIds.contains(cid)) {
                return new Defect(fileName, rescueResult.getBadIndexFiles(), "ContainerID mehrfach vorhanden");
            }
            if (dimin_old > dimin) {
                return new Defect(fileName, rescueResult.getBadIndexFiles(), "Datenindex nicht monoton steigend");
            }
            if (actualContainerHeaders != null) {
                ContainerHeaders containerHeaders = actualContainerHeaders.get(cid);
                if (containerHeaders == null) {
                    return new Defect(fileName, rescueResult.getBadIndexFiles(), "Containerdatei fehlt: " + cid);
                }
                if (containerHeaders.getContainerHeaderParamAsInt(ContainerManagementInformation.CHP_ANZ_DS) != -1) {
                    if (dimin != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MIN)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_IDX_MIN");
                    }
                    if (dimax != containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX)) {
                        return new Defect(fileName, rescueResult.getBadIndexFiles(), "Abweichung in Indexdatei von Container-Header: DATA_IDX_MAX");
                    }
                }
            }
            indexContainerIds.add(cid);
            containerFileIDs.remove(cid);
            dimin_old = dimin;
        }
        if (!containerFileIDs.isEmpty()) {
            return new Defect(fileName, rescueResult.getBadIndexFiles(), "Es kommen nicht alle ContainerIDs in der Indexdatei vor.");
        }
        return null;
    }

    private static long read5(RandomAccessFile raf) throws IOException {
        return (((long)raf.readByte() & 0xFFL) << 32) + ((long)raf.readInt() & 0xFFFFFFFFL);
    }

    private static long read6(RandomAccessFile raf) throws IOException {
        return (((long)raf.readShort() & 0xFFFFL) << 32) + ((long)raf.readInt() & 0xFFFFFFFFL);
    }

    private static void fixBadIndexFileDefect(Defect badIndexFileDefect) {
        try {
            Path indexFile = badIndexFileDefect.getFile();
            PersistenceCheckRunner.rebuildIndexFile(indexFile);
        }
        catch (Exception e) {
            System.out.println("Fehler beim Wiederherstellen der Indexdatei '" + String.valueOf(badIndexFileDefect.getFile()) + "'");
            e.printStackTrace(System.out);
        }
    }

    private static void rebuildIndexFile(Path indexFile) throws IOException {
        Files.delete(indexFile);
    }

    private static void checkContainerFile(Path containerFile, RescueResult rescueResult, boolean checkConsistency) {
        rescueResult.incrCheckedContainerFileCount();
        Defect defect = PersistenceCheckRunner.inspectContainerFile(containerFile, rescueResult);
        if (defect == null && checkConsistency) {
            defect = PersistenceCheckRunner.checkConsistency(containerFile, rescueResult);
        }
        if (defect == null) {
            rescueResult.incrValidContainerFileCount();
        } else {
            rescueResult.incrDefectContainerFileCount();
        }
    }

    private static Defect checkConsistency(Path containerFile, RescueResult rescueResult) {
        long lastDataIndex = Long.MIN_VALUE;
        long lastArcTime = Long.MIN_VALUE;
        long plDataIndexMin = Long.MAX_VALUE;
        long plDataIndexMax = Long.MIN_VALUE;
        long plArcTimeMin = Long.MAX_VALUE;
        long plArcTimeMax = Long.MIN_VALUE;
        long plDataTimeMin = Long.MAX_VALUE;
        long plDataTimeMax = Long.MIN_VALUE;
        long plCount = 0L;
        try {
            StandaloneContainerFileHandle containerFileHandle = new StandaloneContainerFileHandle(containerFile);
            containerFileHandle.readContainerHeader();
            if (!containerFileHandle.isContainerClosed()) {
                return null;
            }
            long dIdxMin = containerFileHandle.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MIN);
            long dIdxMax = containerFileHandle.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX);
            long aTMin = containerFileHandle.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MIN);
            long aTMax = containerFileHandle.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX);
            long dTMin = containerFileHandle.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MIN);
            long dTMax = containerFileHandle.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX);
            ContainerDataIterator i = containerFileHandle.iterator();
            ContainerDataResult result = new ContainerDataResult();
            while (!i.isEmpty()) {
                ++plCount;
                i.peek(result);
                if (result.getDataIndex() > plDataIndexMax) {
                    plDataIndexMax = result.getDataIndex();
                }
                if (result.getDataIndex() < plDataIndexMin) {
                    plDataIndexMin = result.getDataIndex();
                }
                if (lastDataIndex >= result.getDataIndex()) {
                    return new Defect(containerFile, rescueResult.getCantFix(), "DatenIndex nicht streng monoton steigend\nI_n-1=" + Util.dIdx2StrExt((long)lastDataIndex) + " (" + lastDataIndex + "), I_n=" + Util.dIdx2StrExt((long)result.getDataIndex()) + " (" + result.getDataIndex() + ")");
                }
                if (result.getDataState() == DataState.NO_SOURCE && (Util.dIdxDaVBit((long)result.getDataIndex()) != 1 || Util.dIdxArSBit((long)result.getDataIndex()) != 0)) {
                    return new Defect(containerFile, rescueResult.getCantFix(), "Datensatz mit Kennung 'keine Quelle' hat DAV-Bit nicht gesetzt oder Archiv-Bit gesetzt: Pos. " + result.getDataIndex());
                }
                if (result.getDataState() == DataState.NO_DATA && (Util.dIdxDaVBit((long)result.getDataIndex()) != 0 || Util.dIdxArSBit((long)result.getDataIndex()) != 0)) {
                    return new Defect(containerFile, rescueResult.getCantFix(), "Datensatz mit Kennung 'keine Daten' hat DAV-Bit oder Archiv-Bit gesetzt: Pos. " + result.getDataIndex());
                }
                if (result.isData() && (Util.dIdxDaVBit((long)result.getDataIndex()) != 0 || Util.dIdxArSBit((long)result.getDataIndex()) != 0)) {
                    return new Defect(containerFile, rescueResult.getCantFix(), "regulaerer Datensatz hat DAV-Bit oder Archiv-Bit gesetzt: Pos. " + result.getDataIndex());
                }
                if (result.getDataState() == DataState.POSSIBLE_GAP && (Util.dIdxDaVBit((long)result.getDataIndex()) != 0 || Util.dIdxArSBit((long)result.getDataIndex()) != 1)) {
                    return new Defect(containerFile, rescueResult.getCantFix(), "Datensatz mit Kennung 'Datenluecke' hat DAV-Bit gesetzt oder Archiv-Bit nicht gesetzt: Pos. " + result.getDataIndex());
                }
                if (Util.dIdxSrcSubscrTime((long)result.getDataIndex()) == 0L) {
                    return new Defect(containerFile, rescueResult.getCantFix(), "Datenindex mit AnmeldezeitQuelle==0 gefunden: Pos. " + result.getDataIndex());
                }
                if (result.getArchiveTime() > plArcTimeMax) {
                    plArcTimeMax = result.getArchiveTime();
                }
                if (result.getArchiveTime() < plArcTimeMin) {
                    plArcTimeMin = result.getArchiveTime();
                }
                if (lastArcTime > result.getArchiveTime()) {
                    return new Defect(containerFile, rescueResult.getCantFix(), "Archivzeit nicht monoton steigend\nI_n-1=" + Util.timestrMillisFormatted((long)lastArcTime) + " (" + lastArcTime + "), I_n=" + Util.timestrMillisFormatted((long)result.getArchiveTime()) + " (" + result.getArchiveTime() + ")");
                }
                if (result.getDataTime() > plDataTimeMax) {
                    plDataTimeMax = result.getDataTime();
                }
                if (result.getDataTime() < plDataTimeMin) {
                    plDataTimeMin = result.getDataTime();
                }
                lastDataIndex = result.getDataIndex();
                lastArcTime = result.getArchiveTime();
                i.remove();
            }
            i.close();
            long headerCount = containerFileHandle.getContainerHeaderParamAsLong(ContainerHdr.CHP_ANZ_DS);
            if (plCount != headerCount) {
                return new Defect(containerFile, rescueResult.getCantFix(), "Anzahl Datens\u00e4tze: Headerinformation (" + headerCount + ") stimmt nicht mit den Nutzdaten (" + plCount + ") \u00fcberein.");
            }
            if (plDataIndexMin != dIdxMin) {
                return new Defect(containerFile, rescueResult.getCantFix(), "DataIndexMin: Headerinformation (" + dIdxMin + ") stimmt nicht mit den Nutzdaten (" + plDataIndexMin + ") \u00fcberein.");
            }
            if (plDataIndexMax != dIdxMax) {
                return new Defect(containerFile, rescueResult.getCantFix(), "DataIndexMax: Headerinformation (" + dIdxMax + ") stimmt nicht mit den Nutzdaten (" + plDataIndexMax + ") \u00fcberein.");
            }
            if (plArcTimeMin != aTMin) {
                return new Defect(containerFile, rescueResult.getCantFix(), "ArcTimeMin: Headerinformation (" + aTMin + ") stimmt nicht mit den Nutzdaten (" + plArcTimeMin + ") \u00fcberein.");
            }
            if (plArcTimeMax != aTMax) {
                return new Defect(containerFile, rescueResult.getCantFix(), "ArcTimeMax: Headerinformation (" + aTMax + ") stimmt nicht mit den Nutzdaten (" + plArcTimeMax + ") \u00fcberein.");
            }
            if (plDataTimeMin != dTMin) {
                return new Defect(containerFile, rescueResult.getCantFix(), "DataTimeMin: Headerinformation (" + dTMin + ") stimmt nicht mit den Nutzdaten (" + plDataTimeMin + ") \u00fcberein.");
            }
            if (plDataTimeMax != dTMax) {
                return new Defect(containerFile, rescueResult.getCantFix(), "DataTimeMax: Headerinformation (" + dTMax + ") stimmt nicht mit den Nutzdaten (" + plDataTimeMax + ") \u00fcberein.");
            }
        }
        catch (PersistenceException e) {
            return new Defect(containerFile, rescueResult.getCantFix(), "Fehler beim Lesen der Containerdatei", e);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static Defect inspectContainerFile(Path containerFile, RescueResult rescueResult) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[TRYBLOCK]], but top level block is 19[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void fixOneByteShortDefect(Defect defect) {
        try (RandomAccessFile container = new RandomAccessFile(defect.getFile().toFile(), "rw");){
            container.seek(164L);
            byte[] propertyName = new byte[6];
            container.readFully(propertyName);
            char[] properyValueChars = new char[19];
            for (int i = 0; i < properyValueChars.length; ++i) {
                properyValueChars[i] = (char)container.readByte();
            }
            byte propertySeparator = container.readByte();
            if (propertyName[0] != 68 || propertyName[1] != 73 || propertyName[2] != 109 || propertyName[3] != 97 || propertyName[4] != 120 || propertyName[5] != 61) {
                System.out.println(String.valueOf(defect.getFile()) + ": Reparatur nicht m\u00f6glich, weil die Kennung DImax= nicht an der erwarteten Stelle ist.");
                return;
            }
            if (propertySeparator != 10) {
                System.out.println(String.valueOf(defect.getFile()) + ": Reparatur nicht m\u00f6glich, weil der Wert der Kennung DImax= nicht mit NewLine terminiert ist.");
                return;
            }
            String propertyValueString = String.valueOf(properyValueChars);
            long propertyValue = Long.parseLong(propertyValueString);
            long fileLength = container.length();
            container.seek(fileLength - 8L);
            long lastLongValue = container.readLong() << 8;
            if (lastLongValue != Long.MIN_VALUE && lastLongValue != (propertyValue & 0xFFFFFFFFFFFFFF00L)) {
                System.out.println(String.valueOf(defect.getFile()) + ": Reparatur nicht m\u00f6glich, weil die letzten 7 Byte der Datei nicht den erwarteten Werten entsprechen.");
                return;
            }
            container.seek(fileLength - 7L);
            container.writeLong(propertyValue);
            System.out.println(String.valueOf(defect.getFile()) + ": Container wurde repariert");
        }
        catch (IOException e) {
            System.out.println(String.valueOf(defect.getFile()) + ": Unerwarteter Fehler bei der Reparatur: " + String.valueOf(e));
        }
    }

    private static void fixBadRangeEndDefect(Defect defect) {
        try (RandomAccessFile container = new RandomAccessFile(defect.getFile().toFile(), "rw");){
            container.seek(384L);
            long startRangeIndex = container.readLong();
            byte separator = container.readByte();
            long badEndRangeIndex = container.readLong();
            if (separator != 45) {
                System.out.println(String.valueOf(defect.getFile()) + ": Reparatur nicht m\u00f6glich, weil Separatorzeichen nicht an erwarteter Stelle.");
                return;
            }
            if (badEndRangeIndex != Long.MIN_VALUE) {
                System.out.println(String.valueOf(defect.getFile()) + ": Reparatur nicht m\u00f6glich, weil Bereichsende des ersten Bereichs nicht defekt ist.");
                return;
            }
            container.seek(393L);
            container.writeLong(startRangeIndex);
            System.out.println(String.valueOf(defect.getFile()) + ": Container wurde repariert");
        }
        catch (IOException e) {
            System.out.println(String.valueOf(defect.getFile()) + ": Unerwarteter Fehler bei der Reparatur: " + String.valueOf(e));
        }
    }

    private static void fixBadContainerFileEnd(Defect defect, PersistenceDirectoryLayoutInstance layoutInstance) {
        Path containerFile;
        block24: {
            containerFile = defect.getFile();
            long anzDs = -1L;
            try (BasicContainerFileHandle handle = new BasicContainerFileHandle(containerFile, layoutInstance.getContainerDirectory(containerFile.getParent()));){
                handle.ensureHeaderRead();
                anzDs = handle.getContainerHeaderParamAsLong(ContainerHdr.CHP_ANZ_DS);
            }
            catch (PersistenceException e) {
                System.out.println(String.valueOf(containerFile) + ": Unerwarteter Fehler bei der Reparatur: " + String.valueOf(e));
            }
            try (BufferedRandomAccessFile container = new BufferedRandomAccessFile(containerFile.toFile(), "rw");){
                if (container.length() < 384L) {
                    throw new IOException("Container hat keinen Header, L\u00e4nge ist nur " + container.length() + " Bytes.");
                }
                container.seek(384L);
                long lastValidPosition = 384L;
                long actualAnzDs = 0L;
                long oldLength = container.length();
                while (container.getFilePointer() < oldLength) {
                    try {
                        lastValidPosition = container.getFilePointer();
                        int length = container.readInt();
                        if (length <= 0) break;
                        byte[] tmp = new byte[length];
                        container.readFully(tmp);
                        if (tmp[tmp.length - 3] != 35 || tmp[tmp.length - 2] != 35) break;
                        if (tmp[tmp.length - 1] != 10) {
                        }
                    }
                    catch (EOFException ignored) {}
                    break;
                    ++actualAnzDs;
                }
                if (lastValidPosition == container.length()) {
                    System.out.println(String.valueOf(containerFile) + ": Unerwarteter Fehler bei der Reparatur: Es wurde kein Fehler zum reparieren gefunden");
                }
                if (anzDs == -1L || anzDs == actualAnzDs) {
                    container.setLength(lastValidPosition);
                    break block24;
                }
                System.out.println(String.valueOf(containerFile) + ": Fehler bei der Reparatur: Die Anzahl der g\u00fcltigen Datens\u00e4tze im Container stimmt nicht mit dem Container-Header \u00fcberein.");
                return;
            }
            catch (Exception e) {
                System.out.println(String.valueOf(containerFile) + ": Unerwarteter Fehler bei der Reparatur: " + String.valueOf(e));
                return;
            }
        }
        try {
            PersistenceCheckRunner.rebuildIndexFiles(containerFile.getParent());
        }
        catch (Exception e) {
            System.out.println(String.valueOf(containerFile) + ": Unerwarteter Fehler bei der Reparatur: " + String.valueOf(e));
        }
    }

    private static void rebuildIndexFiles(Path parentFile) throws IOException {
        Path[] indexFiles;
        for (Path indexFile : indexFiles = PersistenceCheckRunner.listFiles(parentFile, _indexFilenameFilter)) {
            PersistenceCheckRunner.rebuildIndexFile(indexFile);
        }
    }

    @NotNull
    private static Path[] listFiles(Path parentFile, FilenameFilter filter) {
        File[] files = parentFile.toFile().listFiles(filter);
        if (files == null) {
            return new Path[0];
        }
        return (Path[])Arrays.stream(files).map(File::toPath).toArray(Path[]::new);
    }

    static {
        Pattern _containerFilenamePattern = Pattern.compile("dc[0-9]*\\.dat");
        _containerFilenameFilter = (dir, name) -> _containerFilenamePattern.matcher(name).matches();
        Pattern _indexFilenamePattern = Pattern.compile("_.+\\.idx");
        _indexFilenameFilter = (dir, name) -> _indexFilenamePattern.matcher(name).matches();
    }
}

