/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.repair;

import de.bsvrz.ars.ars.repair.Defect;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RescueResult {
    private final Set<Defect> cantFix = ConcurrentHashMap.newKeySet();
    private final Set<Defect> oneByteShortDefects = ConcurrentHashMap.newKeySet();
    private final Set<Defect> badRangeEndDefects = ConcurrentHashMap.newKeySet();
    private final Set<Defect> badContainerFileEnd = ConcurrentHashMap.newKeySet();
    private final Set<Defect> shortContainerFiles = ConcurrentHashMap.newKeySet();
    private final Set<Defect> badIndexFiles = ConcurrentHashMap.newKeySet();
    private final AtomicLong validContainerFileCount = new AtomicLong();
    private final AtomicLong checkedContainerFileCount = new AtomicLong();
    private final AtomicLong defectContainerFileCount = new AtomicLong();
    private final AtomicLong validIndexFileCount = new AtomicLong();
    private final AtomicLong checkedIndexFileCount = new AtomicLong();
    private final AtomicLong defectIndexFileCount = new AtomicLong();
    private final AtomicLong correctedDefectCount = new AtomicLong();
    private final AtomicInteger deletedFiles = new AtomicInteger();
    private final AtomicLong dataIdentificationsVisited = new AtomicLong();

    public int getFixableDefectsCount() {
        return this.getOneByteShortDefects().size() + this.getBadRangeEndDefects().size() + this.getBadContainerFileEnd().size() + this.getBadIndexFiles().size();
    }

    public Set<Defect> getCantFix() {
        return this.cantFix;
    }

    public Set<Defect> getOneByteShortDefects() {
        return this.oneByteShortDefects;
    }

    public Set<Defect> getBadRangeEndDefects() {
        return this.badRangeEndDefects;
    }

    public Set<Defect> getBadContainerFileEnd() {
        return this.badContainerFileEnd;
    }

    public Set<Defect> getShortContainerFiles() {
        return this.shortContainerFiles;
    }

    public Set<Defect> getBadIndexFiles() {
        return this.badIndexFiles;
    }

    public long getValidContainerFileCount() {
        return this.validContainerFileCount.get();
    }

    public long getCheckedContainerFileCount() {
        return this.checkedContainerFileCount.get();
    }

    public long getDefectContainerFileCount() {
        return this.defectContainerFileCount.get();
    }

    public long getValidIndexFileCount() {
        return this.validIndexFileCount.get();
    }

    public long getCheckedIndexFileCount() {
        return this.checkedIndexFileCount.get();
    }

    public long getDefectIndexFileCount() {
        return this.defectIndexFileCount.get();
    }

    public long getCorrectedDefectCount() {
        return this.correctedDefectCount.get();
    }

    public int getDeletedFiles() {
        return this.deletedFiles.get();
    }

    public void incrCorrectedDefectCount(long correctedDefectCount) {
        this.correctedDefectCount.addAndGet(correctedDefectCount);
    }

    public void incrCheckedIndexFileCount() {
        this.checkedIndexFileCount.getAndIncrement();
    }

    public void incrValidIndexFileCount() {
        this.validIndexFileCount.getAndIncrement();
    }

    public void incrDefectIndexFileCount() {
        this.defectIndexFileCount.getAndIncrement();
    }

    public void incrDeletedFiles() {
        this.deletedFiles.getAndIncrement();
    }

    public void incrCheckedContainerFileCount() {
        this.checkedContainerFileCount.getAndIncrement();
    }

    public void incrValidContainerFileCount() {
        this.validContainerFileCount.getAndIncrement();
    }

    public void incrDefectContainerFileCount() {
        this.defectContainerFileCount.getAndIncrement();
    }

    public boolean isConsistent() {
        return this.defectIndexFileCount.get() == 0L && this.defectContainerFileCount.get() == 0L;
    }

    public void incrDataIdentificationsVisited() {
        this.dataIdentificationsVisited.getAndIncrement();
    }

    public long getDataIdentificationsVisited() {
        return this.dataIdentificationsVisited.get();
    }
}

