/*
 *
 * Copyright 2010-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt;

import de.bsvrz.ars.ars.mgmt.tasks.base.Task;
import de.bsvrz.dav.daf.main.ClientDavInterface;

/**
 * Schnittstelle zur Verwaltung und Dokumentation der Zustände von Tasks und den Fortschritt von langwierigen Aktionen zu dokumentieren
 *
 * @author Kappich Systemberatung
 * @version $Revision: none $
 */
public interface LongTermTaskStatePublisher {

	/**
	 * Nimmt eine neue Task in die Verwaltung der Tasks auf. Diese Methode sollte von jeder Task einmal aufgerufen werden. Über das zurückgelieferte Task-Objekt
	 * kann die Task ihren Zustand und ihren Fortschritt mit entsprechenden Methoden bekannt geben.
	 * @param taskName Name der Task
	 * @return Task-Objekt über das die Task ihren Zustand und ihren Fortschritt mit entsprechenden Methoden bekannt geben kann.
	 */
	Task registerTask(String taskName);

	/**
	 * Übergibt die Verbindung zum Datenverteiler. Nach Aufruf dieser Methode kann die Task-Verwaltung die Zustände der einzelnen Task über den Datenverteiler
	 * publizieren. Der Aufruf dieser Methode ist optional.
	 *
	 * @param davConnection Datenverteilerverbindung
	 */
	void setDavConnection(ClientDavInterface davConnection);

}
