/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.commands;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

/**
 * Diese Klasse sendet eine Sequenz über das Telnet-Interface des Archivsystems, so dass dieses beendet wird.
 *
 * @author beck et al. projects GmbH
 * @author Alexander Schmidt
 * @version $Revision$ / $Date$ / ($Author$)
 */
@SuppressWarnings("UseOfSystemOutOrSystemErr")
public class ArSQuitCmdSender {

	/**
	 * Beendet das unter host:port befindliche Archivsystem. Falls kein host angegeben ist, wird localhost verwendet. Meldet sich kein Archivsystem, wird nach
	 * einem Timeout ein Fehler ausgegeben. Die korrekte Beendigung des Archivsystems wird am connection reset erkannt. In diesem Fall wird 0 an das OS
	 * zurückgegeben, sonst 1.
	 *
	 * @param args [host] port
	 */
	public static void main(String[] args) {
		int portNum = 0;
		String host = "localhost";

		if(args.length == 1) {
			try {
				portNum = Integer.parseInt(args[0]);
			}
			catch(NumberFormatException e) {
				System.out.println("Fehler: keine gueltige Portnummer: " + args[0]);
				System.exit(1);
			}
		}
		else if(args.length == 2) {
			host = args[0];
			try {
				portNum = Integer.parseInt(args[1]);
			}
			catch(NumberFormatException e) {
				System.out.println("Fehler: keine gueltige Portnummer: " + args[1]);
				System.exit(1);
			}
		}
		else {
			System.out.println("Fehler: falsche Parameterzahl. Korrekte Verwendung\n  " + ArSQuitCmdSender.class.getSimpleName() + " [host] port");
			System.exit(1);
		}

		try {
			ArSCmdInterface.sendQuitCmd(host, portNum);
		}
		catch(UnknownHostException e) {
			System.out.println("Fehler: Host '" + host + "' nicht gefunden");
			System.exit(1);
		}
		catch(SocketTimeoutException e) {
			System.out.println(
					"Fehler: Keine Antwort vom Archivsystem unter " + host + ":" + portNum + " nach " + ArSCmdInterface.SEND_TIMEOUT + " Sekunden"
			);
			System.exit(1);
		}
		catch(IOException e) {
			if(e.getMessage().endsWith("Connection reset")) {
				System.out.println("OK - Archivsystem unter " + host + ":" + portNum + " beendet.");
				System.exit(0);
			}
			else {
				System.out.println("Fehler: Kommunikation zum Archivsystem unter " + host + ":" + portNum + " fehlgeschlagen: " + e.getMessage());
				System.exit(1);
			}
		}
	}
}
