/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * Klasse zur zyklischen Abfrage der Archiv-Warteschlangen
 *
 * @author beck et al. projects GmbH
 * @author Alexander Schmidt
 * @version $Revision$ / $Date$ / ($Author$)
 */
public class ArchiveMonitor extends Thread {

	private static final String BAR = "##################################################";

	private static final String BLANK = "                                                  ";

	private static final ThreadLocal<DateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd.MM.yyyy  HH:mm:ss,SSS"));

	private final int uInt;

	private final ArchiveManager aMgr;

	private final Command cmd;

	private boolean terminated;

	public ArchiveMonitor(ArchiveManager am, int updateInterval, Command command) {
		aMgr = am;
		uInt = updateInterval;
		cmd = command;
	}

	public void terminate() {
		terminated = true;
		interrupt();
	}


	@Override
	public void run() {
		int oldQueueLoad = -1;
		while (!terminated) {
			try {
				int queueLoad = aMgr.getInQueuesMgr().countDataInQueues();

				if (queueLoad != oldQueueLoad) {
					try {
						cmd.printlnPlain("               ------------- " + dateFormat.get().format(new Date()) + " -------------");
						double loadFraction = (double) queueLoad / aMgr.getInQueuesMgr().getArchiveQueueCapacity();
						int filledBarLength = (int) (loadFraction * BAR.length());
						cmd.printlnPlain(
								String.format("Queue: %12d ", queueLoad)
										+ "["
										+ BAR.substring(0, filledBarLength)
										+ BLANK.substring(0, BLANK.length() - filledBarLength)
										+ "] "
										+ String.format("%3d%%", (int) (loadFraction * 100))
						);
					} catch (Exception e) {
						break;
					}
					oldQueueLoad = queueLoad;
				}
				//noinspection BusyWait
				sleep(uInt);
			} catch (InterruptedException e) {
				break;
			}
		}
	}
}
