/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.persistence.RebuildMode;
import de.bsvrz.ars.ars.persistence.RestorePersDirTsk;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.PersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.sequence.AllDataSpecification;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;

/**
 * Kommando, um Indexdateien wiederherzustellen
 */
public class CreateIndexesCommand extends Command {

	private final ArchiveManager archiveManager;

	/**
	 * Konstruktor
	 *
	 * @param archiveManager Archivmanager
	 */
	public CreateIndexesCommand(ArchiveManager archiveManager) {
		super("Indexdateien regenerieren", "");
		this.archiveManager = archiveManager;
	}

	@Override
	public void execute() throws Exception {
		new Thread(() -> {
			PersistenceDirectoryManager manager = archiveManager.getPersistenceManager().getPersistenceDirectoryManager();
			for (PersistenceDirectory directory : manager.getPersistenceDirectories(0, AllDataSpecification.Instance)) {
				RestorePersDirTsk.RestoreWorker worker = new RestorePersDirTsk.RestoreWorker("Indexdateien im Verzeichnis " + directory + " regenerieren", RebuildMode.Slow, archiveManager.getPersistenceManager(), 1);
				worker.doRestore(directory);
			}
		}).start();
	}

}
