/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;

import java.util.Set;

/**
 * Befehl zur Ausgabe des Arbeitsspeicherverbrauchs
 *
 * @author Kappich Systemberatung
 */
public class LargeContainerDirDump extends Command {
	private final ArchiveManager _archMgr;

	/**
	 * Kommando für {@link de.bsvrz.sys.funclib.losb.util.cmdinterface.CmdInterpreter}
	 *
	 * @param desc    die Beschreibung
	 * @param help    der Hilfetext
	 * @param archMgr Archivmanager
	 */
	public LargeContainerDirDump(final String desc, final String help, final ArchiveManager archMgr) {
		super(desc, help);
		_archMgr = archMgr;
	}

	@Override
	public void execute() throws Exception {
		for (PersistenceDirectory directory : _archMgr.getPersistenceManager().getPersistenceDirectories(0)) {
			printlnPlain(directory.toString() + ":");
			final Set<IdContainerFileDir> dataIdentifications = directory.getLargeDataIdentifications();
			printlnPlain(dataIdentifications.size() + " Verzeichnisse mit einer großen Anzahl an Containern:");
			for (IdContainerFileDir dataIdentification : dataIdentifications) {
				printlnPlain(directory.getPath(dataIdentification).toString());
			}
		}
	}

}
