/*
 * Copyright 2019-2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;

/**
 * Befehl zur Ausgabe des Arbeitsspeicherverbrauchs
 *
 * @author Kappich Systemberatung
 */
public class MemoryDumpCmd extends Command {
	private final ArchiveManager _archMgr;

	/**
	 * Kommando für {@link de.bsvrz.sys.funclib.losb.util.cmdinterface.CmdInterpreter}
	 *
	 * @param desc    die Beschreibung
	 * @param help    der Hilfetext
	 * @param archMgr Archivmanager
	 */
	public MemoryDumpCmd(final String desc, final String help, final ArchiveManager archMgr) {
		super(desc, help);
		_archMgr = archMgr;
	}

	@Override
	public void execute() throws Exception {
		final PersistenceManager.Statistics statistics = _archMgr.getPersistenceManager().getStatistics();
		printlnPlain("Aktueller Arbeitsspeicherverbrauch: ");
		Runtime runtime = Runtime.getRuntime();
		long usedMemory = runtime.totalMemory() - runtime.freeMemory();
		printlnPlain(String.format("%n%9.3f MB insgesamt, davon", usedMemory / 1048576.0));
		printlnPlain(String.format("%n%9.3f MB zur Synchronisierung", statistics.getLockMemory() / 1048576.0));
		printlnPlain(String.format("%n%9.3f MB für %d Datenknoten", statistics.getNodeMemory() / 1048576.0, statistics.getNumNodes()));
		printlnPlain(String.format("%n%9.3f MB für %d offene Container", statistics.getActiveMemory() / 1048576.0, statistics.getNumOpenContainerData()));
		printlnPlain(String.format("%n%9.3f MB für %d Datensätze in der Warteschlange", statistics.getQueueMemory() / 1048576.0, statistics.getQueueSize()));
		printlnPlain(String.format("%n%9.3f MB zwischengespeichert für Archivierungs-Cache (davon %.0f%% ungenutzt)",
				statistics.getCachedMemory().totalBytesUsed() / 1048576.0,
				100.0 - 100.0 * (double) statistics.getCachedMemory().cachedBytes() / statistics.getCachedMemory().totalBytesUsed())
		);
	}

}
