/*
 * Copyright 2020 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.dav.daf.util.cron.CronDefinition;

import java.nio.file.Path;

public class MirrorDefinition {
	private final CronDefinition _cronDefinition;
	private final Path _targetDirectory;
	private final String[] _commandLine;

	public MirrorDefinition(final CronDefinition cronDefinition, final Path targetBaseDir, final String[] commandLine) {
		_cronDefinition = cronDefinition;
		_targetDirectory = targetBaseDir;
		_commandLine = commandLine;
	}

	public CronDefinition getCronDefinition() {
		return _cronDefinition;
	}

	public Path getTargetDirectory() {
		return _targetDirectory;
	}

	public String[] getCommandLine() {
		return _commandLine;
	}
}
