/*
 *
 * Copyright 2013-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.query.QueryHandler;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.sys.funclib.losb.datk.MessageType;

/**
 * Klasse, die einfache Anfragen bzgl. der maximalen Anzahl ausführbarer Archivanfragen entgegennimmt.
 * Kann ggf. um weitere Abfragen erweitert werden.
 *
 * @author Kappich Systemberatung
*/
public class NumQueriesInfoTask extends SingleTask {

	public NumQueriesInfoTask(final ArchiveManager archMgr) {
		super(archMgr);
	}

	@Override
	protected void work(final ResultData resultData) {
		if(!resultData.hasData()) return;
		QueryHandler queryHandler = new QueryHandler(getName(), getArchMgr(), MessageType.NUM_QUERIES_INFO_RESULT, resultData.getData());
		try {
			final int requestType = queryHandler.getDeserializer().readInt();
			if(requestType != 0){
				queryHandler.sendErrorResponse("Unbekannter Anfrage-Typ: " + requestType + " (Archivsystem aktualisieren?)");
			}
			queryHandler.sendResponse(MessageType.NUM_QUERIES_INFO_RESULT, true, "", serializer -> {
				serializer.writeInt(getArchMgr().getMaximumQueriesPerApplication());
				serializer.writeInt(getArchMgr().getArchiveQueryCountForApplication(queryHandler.getQueryApplication()));
			});
		}
		catch(Exception e) {
			_debug.error("Abfrage Anzahl gleichzeitiger Archivanfragen fehlgeschlagen", e);
			queryHandler.sendErrorResponse("Abfrage Anzahl gleichzeitiger Archivanfragen: " + e.getMessage());
		}
	}

}
